/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.notification.Notification;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.geode.GeodeCacheAccessable;
import com.seeyon.ctp.common.cache.geode.GeodeCacheObject;
import com.seeyon.ctp.common.cache.geode.GeodeCacheSet;
import com.seeyon.ctp.common.cache.geode.GeodeEventHandler;
import com.seeyon.ctp.common.cache.geode.GeodeNotificationManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.springframework.util.StopWatch;

public class GeodeService {
    private static Log logger = CtpLogFactory.getLog(GeodeService.class);
    public static final String CLUSTER_NAME = "seeyon-cluster";
    private static Cache rootCache;
    private static Region<NotificationType, ? extends Serializable> eventRegion;
    private static Region<? extends Serializable, ? extends Serializable> cacheNotifyRegion;
    private static Region<? extends Serializable, ? extends Serializable> linkedCacheMapRegion;
    private static Region<? extends Serializable, ? extends Serializable> lruCacheMapRegion;
    private static RegionFactory regionFactory;
    private static RegionFactory lockRegionFactory;
    private static RegionFactory localRegionFactory;
    private static RegionFactory eventRegionFactory;
    private static boolean hasInitialized;
    private static final Map<String, GeodeCacheAccessable> groupCacheMap;
    private static GeodeEventHandler eventHandler;
    private static String masterIp;
    private static int locatorPort;
    private static AtomicBoolean online;

    public static synchronized void initialize() {
        if (hasInitialized) {
            return;
        }
        try {
            System.setProperty("gemfire.disableManagement", "true");
            ClusterConfigBean clusterConfigBean = ClusterConfigBean.getInstance();
            locatorPort = clusterConfigBean.getGeodeLocatorPort();
            logger.info((Object)"\u542f\u52a8Geode\u670d\u52a1...");
            StopWatch watch = new StopWatch();
            watch.start();
            org.apache.geode.cache.CacheFactory cacheFactory = new org.apache.geode.cache.CacheFactory().set("log-level", "warning").set("bind-address", clusterConfigBean.getLocalhost()).set("tcp-port", String.valueOf(clusterConfigBean.getGeodeServerPort())).set("membership-port-range", clusterConfigBean.getMemeberPortRange()).set("name", clusterConfigBean.getClusterHostIndex()).set("disable-auto-reconnect", "false").set("max-num-reconnect-tries", "100").set("max-wait-time-reconnect", "60000").set("enable-network-partition-detection", "true").set("async-distribution-timeout", "500").set("async-max-queue-size", "64").set("member-timeout", "30000").set("groups", CLUSTER_NAME);
            String locators = clusterConfigBean.getHosts();
            LinkedHashSet<String> locatorIps = new LinkedHashSet<String>();
            if (Strings.isNotBlank(locators)) {
                String[] locatorArray = locators.split(",");
                for (int i = 0; i < locatorArray.length && i < 2; ++i) {
                    if (!clusterConfigBean.isClusterMain() && !clusterConfigBean.getLocalhost().equals(locatorArray[i]) && masterIp == null) {
                        masterIp = locatorArray[i];
                    }
                    locatorIps.add(locatorArray[i]);
                }
            }
            String locator = null;
            if (clusterConfigBean.isClusterEnabled() && clusterConfigBean.isGeodeLocatorOn() && locatorIps.contains(clusterConfigBean.getLocalhost())) {
                locator = clusterConfigBean.getLocalhost() + "[" + locatorPort + "]";
                cacheFactory.set("start-locator", locator);
            }
            StringBuilder locatorsBuffer = new StringBuilder();
            for (String ipAddress : locatorIps) {
                locatorsBuffer.append(ipAddress);
                locatorsBuffer.append("[");
                locatorsBuffer.append(locatorPort);
                locatorsBuffer.append("]");
                locatorsBuffer.append(",");
            }
            String locatorsValue = "";
            if (Strings.isNotBlank(locatorsBuffer.toString())) {
                locatorsValue = locatorsBuffer.substring(0, locatorsBuffer.length() - 1);
            }
            cacheFactory.set("locators", locatorsValue);
            logger.info((Object)("locatorServer: " + (locator == null ? "\u65e0" : locator)));
            logger.info((Object)("locators: " + locatorsValue));
            rootCache = cacheFactory.create();
            regionFactory = rootCache.createRegionFactory(RegionShortcut.REPLICATE);
            regionFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
            lockRegionFactory = rootCache.createRegionFactory(RegionShortcut.REPLICATE);
            lockRegionFactory.setScope(Scope.GLOBAL);
            localRegionFactory = rootCache.createRegionFactory(RegionShortcut.LOCAL);
            eventRegionFactory = rootCache.createRegionFactory(RegionShortcut.REPLICATE).addCacheListener((CacheListener)eventHandler);
            eventRegionFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
            eventRegion = eventRegionFactory.create("GEODE_EVENT");
            cacheNotifyRegion = eventRegionFactory.create("CACHE_NOTIFICATION");
            linkedCacheMapRegion = eventRegionFactory.create("LINKED_CACHE_MAP_REGION");
            lruCacheMapRegion = eventRegionFactory.create("LRU_CACHE_MAP_REGION");
            final InternalDistributedSystem ds = (InternalDistributedSystem)rootCache.getDistributedSystem();
            int memberNum = ds.getDistributionManager().getViewMembers().size();
            CacheFactory.setSkipFillData(memberNum > 1);
            ds.getDM().addMembershipListener(new MembershipListener(){

                public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
                    GeodeService.printDistributedMembers(ds, "memberJoined");
                    online.set(true);
                }

                public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
                    int memberSize = GeodeService.printDistributedMembers(ds, "memberDeparted");
                    if (memberSize == 1 && masterIp != null) {
                        GeodeService.suicideIfNecessary();
                    }
                }

                public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
                    GeodeService.printDistributedMembers(ds, "memberSuspect");
                }

                public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
                    GeodeService.printDistributedMembers(ds, "quorumLost");
                }
            });
            ds.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                public void onDisconnect(InternalDistributedSystem sys) {
                    logger.warn((Object)"--------------------- Geode\u96c6\u7fa4\u8fde\u63a5\u65ad\u5f00 --------------------");
                }
            });
            InternalDistributedSystem.addReconnectListener((InternalDistributedSystem.ReconnectListener)new InternalDistributedSystem.ReconnectListener(){

                public void reconnecting(InternalDistributedSystem oldSystem) {
                    logger.warn((Object)"Geode\u96c6\u7fa4\u91cd\u8fde\u4e2d... ");
                }

                public void onReconnect(InternalDistributedSystem oldSystem, final InternalDistributedSystem newSystem) {
                    newSystem.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                        public void onDisconnect(InternalDistributedSystem sys) {
                            logger.warn((Object)"--------------------- Geode\u96c6\u7fa4\u8fde\u63a5\u65ad\u5f00 --------------------");
                        }
                    });
                    newSystem.getDM().addMembershipListener(new MembershipListener(){

                        public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
                            GeodeService.printDistributedMembers(newSystem, "memberJoined");
                            online.set(true);
                        }

                        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
                            int memberSize = GeodeService.printDistributedMembers(newSystem, "memberDeparted");
                            if (memberSize == 1 && masterIp != null) {
                                GeodeService.suicideIfNecessary();
                            }
                        }

                        public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
                            GeodeService.printDistributedMembers(newSystem, "memberSuspect");
                        }

                        public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
                            GeodeService.printDistributedMembers(newSystem, "quorumLost");
                        }
                    });
                    logger.warn((Object)"Geode\u96c6\u7fa4\u91cd\u8fde\u6210\u529f,\u5f00\u59cb\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58...");
                    online.set(true);
                    StopWatch watch = new StopWatch();
                    watch.start();
                    rootCache = rootCache.getReconnectedCache();
                    regionFactory = rootCache.createRegionFactory(RegionShortcut.REPLICATE);
                    regionFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    lockRegionFactory = rootCache.createRegionFactory(RegionShortcut.REPLICATE);
                    lockRegionFactory.setScope(Scope.GLOBAL);
                    localRegionFactory = rootCache.createRegionFactory(RegionShortcut.LOCAL);
                    for (Map.Entry entry : groupCacheMap.entrySet()) {
                        GeodeCacheAccessable groupCache = (GeodeCacheAccessable)entry.getValue();
                        Region parentRegion = regionFactory.create((String)entry.getKey());
                        groupCache.setRegion(parentRegion);
                        for (String mapKey : groupCache.mapKeySet()) {
                            groupCache.getGeodeMap(mapKey).setRegion(regionFactory.createSubregion(parentRegion, mapKey));
                        }
                        for (String setKey : groupCache.setKeySet()) {
                            ((GeodeCacheSet)groupCache.getSet(setKey)).setRegion(regionFactory.createSubregion(parentRegion, setKey));
                        }
                        if (groupCache.getObjectMap() == null) continue;
                        groupCache.getObjectMap().setRegion(regionFactory.createSubregion(parentRegion, "OBJECT_REGION_NAME"));
                        for (String objectKey : groupCache.objectKeySet()) {
                            ((GeodeCacheObject)groupCache.getObject(objectKey)).setRegion(groupCache.getObjectMap());
                        }
                    }
                    eventRegionFactory = rootCache.createRegionFactory(RegionShortcut.REPLICATE).addCacheListener((CacheListener)eventHandler);
                    eventRegionFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    eventRegion = eventRegionFactory.create("GEODE_EVENT");
                    ((GeodeNotificationManager)NotificationManager.getInstance()).setEventRegion(eventRegion);
                    cacheNotifyRegion = eventRegionFactory.create("CACHE_NOTIFICATION");
                    linkedCacheMapRegion = eventRegionFactory.create("LINKED_CACHE_MAP_REGION");
                    lruCacheMapRegion = eventRegionFactory.create("LRU_CACHE_MAP_REGION");
                    watch.stop();
                    logger.warn((Object)("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\u6210\u529f\uff0c\u8017\u65f6\uff1a" + watch.getTotalTimeMillis() + "ms"));
                }
            });
            hasInitialized = true;
            watch.stop();
            logger.info((Object)(" \u542f\u52a8Geode\u670d\u52a1\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + watch.getTotalTimeMillis() + "ms"));
        }
        catch (Throwable t) {
            logger.error((Object)"Geode \u521d\u59cb\u5316\u51fa\u9519", t);
        }
    }

    public static synchronized GeodeCacheAccessable getGroupCacheInstance(String groupName) {
        if (!hasInitialized) {
            GeodeService.initialize();
        }
        if (regionFactory != null) {
            if (!groupCacheMap.containsKey(groupName)) {
                GeodeCacheAccessable groupCache = new GeodeCacheAccessable(regionFactory.create(groupName));
                groupCacheMap.put(groupName, groupCache);
            }
            return groupCacheMap.get(groupName);
        }
        logger.warn((Object)" regionFactory \u4e3a\u7a7a\uff0c \u8bf7\u68c0\u67e5\u96c6\u7fa4\u76f8\u5173\u914d\u7f6e\uff01");
        return null;
    }

    public static void enableCacheNotify() {
        if (groupCacheMap == null) {
            return;
        }
        for (Map.Entry<String, GeodeCacheAccessable> cacheMapEntry : groupCacheMap.entrySet()) {
            GeodeCacheAccessable cacheAccessable = cacheMapEntry.getValue();
            cacheAccessable.enableLinkedCacheMapNotify();
            cacheAccessable.enableLRUCacheMapNotify();
        }
    }

    public static boolean isAlone() {
        InternalDistributedSystem ds = (InternalDistributedSystem)rootCache.getDistributedSystem();
        int memberNum = ds.getDistributionManager().getViewMembers().size();
        return memberNum == 1;
    }

    public static RegionFactory getRegionFactory() {
        return regionFactory;
    }

    public static RegionFactory getLockRegionFactory() {
        return lockRegionFactory;
    }

    public static RegionFactory getLocalRegionFactory() {
        return localRegionFactory;
    }

    public static Region getEventRegion() {
        if (!hasInitialized) {
            GeodeService.initialize();
        }
        return eventRegion;
    }

    public static Region getCacheNotifyRegion() {
        if (!hasInitialized) {
            GeodeService.initialize();
        }
        return cacheNotifyRegion;
    }

    public static Region getLinkedCacheMapRegion() {
        if (!hasInitialized) {
            GeodeService.initialize();
        }
        return linkedCacheMapRegion;
    }

    public static Region getLRUCacheMapRegion() {
        if (!hasInitialized) {
            GeodeService.initialize();
        }
        return lruCacheMapRegion;
    }

    public static void register(NotificationType type, NotificationListener listener) {
        if (listener == null) {
            return;
        }
        eventHandler.register(type, listener);
    }

    public static void handleNotify(Notification n) {
        eventHandler.handleNotification(n.getType(), n);
    }

    private static int printDistributedMembers(InternalDistributedSystem ds, String reason) {
        List members = ds.getDM().getViewMembers();
        logger.info((Object)(" ********************* Geode Cluster Member List (" + reason + ") ************************* "));
        for (InternalDistributedMember member : members) {
            logger.info((Object)(member.getHost() + "[" + member.getName() + "]"));
        }
        logger.info((Object)" ****************************************************************************************** ");
        return members.size();
    }

    private static void suicideIfNecessary() {
        online.set(false);
        new Timer("ClusterDeparted-SuicideThread").schedule(new TimerTask(){

            @Override
            public void run() {
                if (online.get()) {
                    logger.error((Object)"\u96c6\u7fa4\u5df2\u6062\u590d ^_^ ");
                    return;
                }
                if (!ClusterConfigBean.getInstance().isClusterMain() && GeodeService.masterIsOnline()) {
                    logger.error((Object)"\u96c6\u7fa4\u5f02\u5e38\u65ad\u5f00\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u60c5\u51b5\uff01");
                    logger.error((Object)" ******************************** \u96c6\u7fa4\u5f02\u5e38\u65ad\u5f00\uff0c\u4e3b\u8282\u70b9\u6b63\u5e38\u5728\u7ebf\uff0c\u4e3a\u907f\u514d\u96c6\u7fa4\u7f13\u5b58\u4e0d\u4e00\u81f4\uff0c\u505c\u6b62\u8be5\u8282\u534f\u540c\u670d\u52a1...");
                    System.exit(-1);
                }
            }
        }, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean masterIsOnline() {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(masterIp, locatorPort), 10000);
        }
        catch (IOException e) {
            logger.error((Object)"\u76d1\u6d4b\u4e3b\u8282\u70b9Locator\u8fde\u901a\u6027", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (Throwable e) {
                logger.error((Object)"socket\u5173\u95ed\u5f02\u5e38", e);
            }
        }
        return true;
    }

    static {
        hasInitialized = false;
        groupCacheMap = new ConcurrentHashMap<String, GeodeCacheAccessable>();
        eventHandler = new GeodeEventHandler();
        online = new AtomicBoolean(true);
    }
}

