/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.AbstractCacheFactory;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.GroupCacheable;
import com.seeyon.ctp.common.cache.TimeRing;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class ThreadCacheFactory
extends AbstractCacheFactory {
    private static Log log = CtpLogFactory.getLog(ThreadCacheFactory.class);
    private static ThreadLocal<Map<String, GroupCacheable>> local = new ThreadLocal();
    private static Map<String, CacheAccessable> INSTANCE_HOLDER = new ConcurrentHashMap<String, CacheAccessable>();
    private static byte[] lock = new byte[0];

    protected ThreadCacheFactory(final String group) {
        super(group);
        this.DEFAULT_CONFIG = new CacheConfiguration(CacheConfiguration.CacheScope.Local);
        this.pool = new AbstractCacheFactory.CachePool(){

            @Override
            protected GroupCacheable get(String key) {
                Map<String, GroupCacheable> caches = this.getCache();
                return caches.get(this.buildKey(group, key));
            }

            private Map<String, GroupCacheable> getCache() {
                ConcurrentHashMap caches = (ConcurrentHashMap)local.get();
                if (caches == null) {
                    caches = new ConcurrentHashMap();
                    local.set(caches);
                }
                return caches;
            }

            @Override
            protected boolean contains(String key) {
                return this.getCache().containsKey(key);
            }

            @Override
            protected void put(String key, GroupCacheable cache) {
                this.getCache().put(this.buildKey(group, key), cache);
            }

            @Override
            public String[] getCacheNames(String group2) {
                throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\uff01");
            }

            @Override
            public void clear() {
                local.remove();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final CacheAccessable getInstance(String group) {
        if (INSTANCE_HOLDER.get(group) != null) return INSTANCE_HOLDER.get(group);
        byte[] byArray = lock;
        synchronized (lock) {
            INSTANCE_HOLDER.put(group, new ThreadCacheFactory(group));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE_HOLDER.get(group);
        }
    }

    public static final CacheAccessable getInstance(Class group) {
        return ThreadCacheFactory.getInstance(group.getCanonicalName());
    }

    public static final void reset() {
        local.remove();
    }

    @Override
    public <E extends Serializable> TimeRing<E> createTimeRing(String cacheName) {
        return null;
    }

    @Override
    public String[] getCacheNames() {
        return null;
    }
}

