/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.AbstractGroupCache;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.MapIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class IndexManager<K extends Serializable, V extends Serializable>
extends AbstractGroupCache
implements CacheMap<K, V> {
    private Map<String, MapIndex<V>> indexes = new ConcurrentHashMap<String, MapIndex<V>>();
    private Map<String, Map<Object, Collection<K>>> index = new ConcurrentHashMap<String, Map<Object, Collection<K>>>();
    private static final String NULL_KEY = "null_key_ctp_null_@#\uffe5%key";

    public IndexManager(String group, String name, CacheConfiguration config) {
        super(group, name, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(MapIndex<V> idx) {
        this.indexes.put(idx.getName(), idx);
        Map<String, Map<Object, Collection<K>>> map = this.index;
        synchronized (map) {
            if (!this.index.containsKey(idx.getName())) {
                this.index.put(idx.getName(), new ConcurrentHashMap());
            }
        }
    }

    public static Object indexKey(Object v) {
        Object key = v;
        if (v == null) {
            return NULL_KEY;
        }
        return key;
    }

    protected void createIndex(K key, V value) {
        for (MapIndex<V> idx : this.indexes.values()) {
            Object indexKey;
            Map<Object, Collection<Object>> map = this.index.get(idx.getName());
            Collection<K> list = map.get(indexKey = IndexManager.indexKey(idx.getValue(value)));
            if (list == null) {
                list = Collections.newSetFromMap(new ConcurrentHashMap());
                map.put(indexKey, list);
            }
            list.add(key);
        }
    }

    protected void removeIndex(K key, V result) {
        for (MapIndex<V> idx : this.indexes.values()) {
            Object indexKey;
            Map<Object, Collection<K>> map = this.index.get(idx.getName());
            Collection<K> list = map.get(indexKey = IndexManager.indexKey(idx.getValue(result)));
            if (list == null) continue;
            list.remove(key);
        }
    }

    protected void clearIndex() {
        for (Map<Object, Collection<K>> idx : this.index.values()) {
            idx.clear();
        }
    }

    @Override
    public Collection<V> values(String indexName, Object o) {
        MapIndex<V> idx = this.indexes.get(indexName);
        if (idx == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        Map<Object, Collection<K>> map = this.index.get(idx.getName());
        Collection<K> collection = map.get(IndexManager.indexKey(o));
        if (collection != null) {
            for (Serializable k : collection) {
                if (!this.contains(k)) continue;
                result.add(this.get(k));
            }
        }
        return result;
    }
}

