/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMapChange;
import com.seeyon.ctp.common.cache.CacheStatistics;
import com.seeyon.ctp.common.cache.GroupCacheable;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

abstract class AbstractGroupCache
implements GroupCacheable {
    private final String group;
    private final String name;
    protected final CacheConfiguration config;
    protected final transient CacheStatistics statistics;
    private boolean distributed;

    public AbstractGroupCache(String group, String name, CacheConfiguration config) {
        this.group = group;
        this.name = name;
        this.config = config;
        this.distributed = CacheConfiguration.CacheScope.Global.equals((Object)config.getScope()) && ClusterConfigBean.getInstance().isClusterEnabled();
        this.statistics = new CacheStatistics(this);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CacheConfiguration.CacheScope getScope() {
        return this.config.getScope();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected void sendNotification(Serializable key, Serializable value, CacheNotification.Action action) {
        if (!this.distributed || RedisHandler.isRedisEnabled()) {
            return;
        }
        if (!CacheFactory.isClusterEnabled()) {
            return;
        }
        boolean mapUpdate = false;
        if (value instanceof HashMap) {
            HashMap m = new HashMap();
            m.putAll(value);
            value = m;
        } else if (value instanceof ArrayList) {
            ArrayList l = new ArrayList((List)((Object)value));
            value = l;
        } else if (value instanceof CacheMapChange) {
            mapUpdate = true;
        }
        this.sendCacheChangedNotification(key, (Serializable)((Object)value), action, mapUpdate);
    }

    private void sendCacheChangedNotification(Serializable key, Serializable value, CacheNotification.Action action, boolean mapUpdate) {
        CacheNotification notification = new CacheNotification();
        notification.setGroup(this.getGroup());
        notification.setCacheName(this.getName());
        notification.setKey(key);
        notification.setValue(value);
        notification.setAction(action.ordinal());
        notification.setMapUpdate(mapUpdate);
        NotificationManager.getInstance().send(NotificationType.CacheChanged, notification);
    }

    @Override
    public CacheStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void loadFromCacheCenter() {
    }
}

