/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.LoginUtil;
import com.seeyon.ctp.common.authenticate.domain.UserCustomizeCache;
import com.seeyon.ctp.common.authenticate.domain.UserHelper;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.flag.BrowserEnum;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.util.LocaleUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class User
implements Serializable {
    private static final long serialVersionUID = 6768748394172336911L;
    private login_state_enum loginState = login_state_enum.logging;
    private String sessionId = null;
    private Long id = Constants.GLOBAL_NULL_ID;
    private long securityKey;
    private String loginName;
    private String password;
    private String name;
    private Long loginAccount;
    private String loginAccountName;
    private String loginAccountShortName;
    private String province;
    private String city;
    private String rectangle;
    private String nodeIndex = "";
    private Long departmentId;
    private Long levelId;
    private Long postId;
    private Long accountId;
    private String remoteAddr;
    private String userAgentFrom;
    private boolean isInternal = true;
    private Integer externalType = 0;
    private boolean isVisitor = false;
    private boolean administrator;
    private boolean groupAdmin;
    private boolean superAdmin;
    private boolean systemAdmin;
    private boolean auditAdmin;
    private boolean platformAdmin;
    private Locale locale;
    private Set<Long> accessSystemMenu = new HashSet<Long>();
    private long loginTimestamp = System.currentTimeMillis();
    private Long loginLogId;
    private String skin;
    private String fontSize = "";
    private String userSSOFrom;
    private BrowserEnum browser;
    private TimeZone timeZone = TimeZone.getDefault();
    private String mainFrame;
    private boolean canSendSMS;
    private String etagRandom;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public String getNodeIndex() {
        return this.nodeIndex;
    }

    public void setNodeIndex(String nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public String getLoginAccountShortName() {
        return this.loginAccountShortName;
    }

    public void setLoginAccountShortName(String loginAccountShortName) {
        this.loginAccountShortName = loginAccountShortName;
    }

    public login_state_enum getLoginState() {
        return this.loginState;
    }

    public void setLoginState(login_state_enum loginState) {
        this.loginState = loginState;
    }

    @JsonIgnore
    public String getUserInfoJsonStr() {
        HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
        userInfoMap.put("id", this.id);
        userInfoMap.put("name", this.name);
        userInfoMap.put("loginAccount", this.loginAccount);
        userInfoMap.put("loginAccountName", this.loginAccountName);
        userInfoMap.put("canSendSMS", this.canSendSMS);
        userInfoMap.put("isInternal", this.isInternal);
        userInfoMap.put("isAdmin", this.isAdmin());
        userInfoMap.put("textDirection", LocaleUtil.getTextDirection(this));
        return JSONUtil.toJSONString(userInfoMap);
    }

    @JsonIgnore
    public String getCustomize(String key) {
        return UserCustomizeCache.getCustomize(key);
    }

    @JsonIgnore
    public Object getCustomizeJson(String key) {
        return this.getCustomizeJson(key, null);
    }

    @JsonIgnore
    public <T> T getCustomizeJson(String key, Class<T> cls) {
        String value = this.getCustomize(key);
        if (value != null) {
            return JSONUtil.parseJSONString(value, cls);
        }
        return null;
    }

    public void setCustomizeJson(String key, Object valueObj) {
        String value = JSONUtil.toJSONString(valueObj);
        UserCustomizeCache.setCustomize(key, value);
    }

    public void setCustomizes(Map<String, String> customize) {
        UserCustomizeCache.setCustomizes(customize);
    }

    public boolean hasResourceCode(String resCode) {
        if (AppContext.isRunningModeDevelop()) {
            return true;
        }
        return UserHelper.hasMenuCode(resCode);
    }

    @JsonIgnore
    public String getResourceJsonStr() {
        return UserHelper.getResourceJsonStr();
    }

    @JsonIgnore
    public String getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(String mainFrame) {
        if (mainFrame != null) {
            this.mainFrame = "/main/frames/" + mainFrame;
        }
    }

    public boolean isCanSendSMS() {
        return this.canSendSMS;
    }

    public void setCanSendSMS(boolean canSendSMS) {
        this.canSendSMS = canSendSMS;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Long getLoginAccount() {
        return this.loginAccount;
    }

    public void setLoginAccount(Long loginAccount) {
        this.loginAccount = loginAccount;
    }

    public String getLoginAccountName() {
        return this.loginAccountName;
    }

    public void setLoginAccountName(String loginAccountName) {
        this.loginAccountName = loginAccountName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getPostId() {
        return this.postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getUserAgentFrom() {
        return this.userAgentFrom;
    }

    @JsonIgnore
    public Constants.login_useragent_from getUserAgentFromEnum() {
        Constants.login_useragent_from f = null;
        if (null != this.userAgentFrom) {
            f = Constants.login_useragent_from.valueOf(this.userAgentFrom);
        }
        return f == null ? Constants.login_useragent_from.pc : f;
    }

    public boolean isFromM1() {
        return LoginUtil.isFromM1(this);
    }

    public int getLoginSign() {
        return LoginUtil.getLoginSign(this.getUserAgentFrom());
    }

    public void setUserAgentFrom(String userAgentFrom) {
        this.userAgentFrom = userAgentFrom;
    }

    public boolean isAdministrator() {
        return this.administrator;
    }

    public void setAdministrator(boolean administrator) {
        this.administrator = administrator;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public boolean isSystemAdmin() {
        return this.systemAdmin;
    }

    public void setSystemAdmin(boolean systemAdmin) {
        this.systemAdmin = systemAdmin;
    }

    public boolean isAuditAdmin() {
        return this.auditAdmin;
    }

    public void setAuditAdmin(boolean auditAdmin) {
        this.auditAdmin = auditAdmin;
    }

    public boolean isPlatformAdmin() {
        return this.platformAdmin;
    }

    public void setPlatformAdmin(boolean platformAdmin) {
        this.platformAdmin = platformAdmin;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isGroupAdmin() {
        return this.groupAdmin;
    }

    public void setGroupAdmin(boolean groupAdmin) {
        this.groupAdmin = groupAdmin;
    }

    public boolean isSuperAdmin() {
        return this.superAdmin;
    }

    public void setSuperAdmin(boolean superAdmin) {
        this.superAdmin = superAdmin;
    }

    public boolean isAdmin() {
        return this.systemAdmin || this.groupAdmin || this.administrator || this.auditAdmin || this.superAdmin || this.platformAdmin;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public Integer getExternalType() {
        if (this.externalType == null) {
            this.externalType = 0;
        }
        return this.externalType;
    }

    public void setExternalType(Integer externalType) {
        this.externalType = externalType;
    }

    public boolean isV5Member() {
        return this.getExternalType().equals(0);
    }

    public boolean isVJoinMember() {
        return this.getExternalType().equals(1);
    }

    public boolean isV5External() {
        return !this.isInternal && this.getExternalType().equals(0);
    }

    public boolean isVisitor() {
        return this.isVisitor;
    }

    public void setVisitor(boolean isVisitor) {
        this.isVisitor = isVisitor;
    }

    @JsonIgnore
    public Set<Long> getAccessSystemMenu() {
        return this.accessSystemMenu;
    }

    public void setAccessSystemMenu(Set<Long> accessSystemMenu) {
        this.accessSystemMenu = accessSystemMenu;
    }

    public Boolean isGuest() {
        return !this.isInternal() && this.getExternalType().equals(2);
    }

    public boolean isDefaultGuest() {
        return this.id.equals(-6964000252392685202L);
    }

    public boolean isScreenGuest() {
        return this.isGuest() != false && !this.id.equals(-6964000252392685202L);
    }

    public String getSkin() {
        if (this.skin == null) {
            this.skin = this.getCustomize("skin");
        }
        this.skin = !"GOV_red".equals(this.skin) ? "default" : "GOV_red";
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    @JsonIgnore
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public Date getLoginTimestamp() {
        return new Date(this.loginTimestamp);
    }

    public void setLoginTimestamp(long loginTimestamp) {
        this.loginTimestamp = loginTimestamp;
    }

    public Long getLoginLogId() {
        return this.loginLogId;
    }

    public void setLoginLogId(Long loginLogId) {
        this.loginLogId = loginLogId;
    }

    public String getUserSSOFrom() {
        return this.userSSOFrom;
    }

    public void setUserSSOFrom(String userSSOFrom) {
        this.userSSOFrom = userSSOFrom;
    }

    public BrowserEnum getBrowser() {
        return this.browser;
    }

    public void setBrowser(BrowserEnum browser) {
        this.browser = browser;
    }

    public long getSecurityKey() {
        return this.securityKey;
    }

    public void setSecurityKey(long securityKey) {
        this.securityKey = securityKey;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getEtagRandom() {
        if (this.etagRandom == null) {
            this.etagRandom = String.valueOf(SecurityHelper.randomInt());
        }
        return this.etagRandom;
    }

    public void resetEtagRandom() {
        this.etagRandom = null;
    }

    public boolean equals(Object o) {
        User u;
        return o != null && o instanceof User && this.id.equals((u = (User)o).getId()) && this.getLoginName().equals(u.getLoginName());
    }

    public String toString() {
        return this.id + "\t" + this.loginName + "\t" + this.name + "\t" + this.loginAccount + "\t" + this.userAgentFrom + "\t" + this.remoteAddr;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(String rectangle) {
        this.rectangle = rectangle;
    }

    public static enum login_state_enum {
        logging,
        exceed_max_member,
        exceed_max_member_in_account,
        ok;

    }
}

