/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate;

import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class TrustAddressManager {
    private static final Log log = CtpLogFactory.getLog(TrustAddressManager.class);
    private static TrustAddressManager instance = null;
    private boolean isEnabledTrust = false;
    private List<String> trustIPList = null;
    public static final String Config_A8_base_folder_key = "ctp.base.folder";

    private TrustAddressManager() {
    }

    public static TrustAddressManager getInstance() {
        if (instance == null) {
            instance = new TrustAddressManager();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.readFile();
    }

    public boolean isTrustPass(HttpServletRequest request) {
        if (!this.isEnabledTrust) {
            return true;
        }
        if (this.trustIPList.contains("*.*.*.*")) {
            return true;
        }
        String ip = Strings.getRemoteAddr(request);
        if ("127.0.0.1".equals(ip)) {
            return true;
        }
        if (this.processed(ip)) {
            return true;
        }
        log.info((Object)("remote ip is not available." + ip));
        return false;
    }

    private boolean processed(String clientIp) {
        String[] partclientIp = clientIp.split("\\.");
        if (partclientIp.length != 4) {
            return false;
        }
        boolean isAvailable = false;
        for (String serverIp : this.trustIPList) {
            String[] partserverIp = serverIp.split("\\.");
            if (partserverIp.length != 4) continue;
            isAvailable = true;
            for (int i = 0; i < partserverIp.length; ++i) {
                if ("*".equals(partserverIp[i])) {
                    if (i != 3) continue;
                    isAvailable = true;
                    break;
                }
                if (partserverIp[i].equals(partclientIp[i])) continue;
                isAvailable = false;
                break;
            }
            if (!isAvailable) continue;
            break;
        }
        return isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<String> readFile() {
        InputStream in = null;
        BufferedReader reader = null;
        try {
            this.trustIPList = new ArrayList<String>();
            in = new FileInputStream(this.getTruestAddressPath());
            if (in != null) {
                String line = null;
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ("".equals(line) || line.indexOf("#") != -1) {
                        if (line.indexOf("enable") == -1) continue;
                        this.isEnabledTrust = "1".equals((line = line.substring(line.indexOf("enable"))).split("=")[1].trim());
                        continue;
                    }
                    line = line.trim();
                    this.trustIPList.add(line);
                }
                reader.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return this.trustIPList;
    }

    private String getTruestAddressPath() {
        return this.getA8BaseFolder() + "/conf/iptrust";
    }

    private String getCanonicalPath(String filepath, boolean isCreate) {
        if (filepath == null || "".equals(filepath)) {
            return null;
        }
        File f = new File(filepath);
        try {
            File fc = f.getCanonicalFile();
            if (isCreate) {
                fc.mkdirs();
            }
            return fc.getAbsolutePath();
        }
        catch (Exception exception) {
            return filepath;
        }
    }

    private String getA8BaseFolder() {
        String filepath = SystemProperties.getInstance().getProperty(Config_A8_base_folder_key);
        return this.getCanonicalPath(filepath, true);
    }
}

