/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.config.MessageChannel;
import com.seeyon.ctp.common.config.MessageListener;
import com.seeyon.ctp.common.config.PlatformAppEnum;
import com.seeyon.ctp.common.config.PlatformConfigUtil;
import com.seeyon.ctp.common.config.manager.ConfigManager;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.constants.ServerTypeEnum;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.filemanager.NoSuchPartitionException;
import com.seeyon.ctp.common.filemanager.manager.PartitionManager;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.plugin.PluginDefinition;
import com.seeyon.ctp.common.plugin.Utils;
import com.seeyon.ctp.common.po.config.ConfigItem;
import com.seeyon.ctp.common.po.filemanager.Partition;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.XXEUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.hibernate.dialect.Dialect;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SystemEnvironment {
    private static final Log log = CtpLogFactory.getLog(SystemEnvironment.class);
    public static final String ENV_BASE_FOLDER_KEY = "ctp.base.folder";
    public static final String ENV_TEMPORARY_FOLDER_KEY = "ctp.temporary.folder";
    public static final String ENV_FILESYNC_FOLDER_KEY = "ctp.fileSync.folder";
    public static final String ENV_APPLICATION_CONTEXT_PATH_KEY = "ApplicationContextPath";
    public static final String ENV_ACCESS_PATTERNS_REMOTE = "Remote";
    public static List<String> i18nList = new ArrayList<String>(){
        {
            this.add("dataI18n");
            this.add("timezone");
            this.add("datetimeFormat");
        }
    };
    private static String baseFolder = null;
    private static String systemTempFolder = null;
    private static String systemSyncFolder = null;
    private static String applicationFolder = null;
    private static String pluginCRC = null;
    private static CacheSet<String> pluginIds = null;
    private static CacheMap<String, Boolean> pluginIds4Map = null;
    private static String pluginIdsJsonStr = null;
    private static Long serverStartTime = null;
    private static String dogNo = null;
    private static String customName = null;
    private static Map<String, PluginDefinition> pluginDefinitions = null;
    private static ConfigManager configManager = null;
    private static String publicPartitionPath = null;
    private static String accessPatterns = "Local";
    private static String indexFilePath = null;
    private static Set<String> disabledPlugins = null;
    private static boolean bootFinished = false;
    private static PartitionManager partitionManager = null;
    private static final boolean isX64Edition = "64".equals(System.getProperty("sun.arch.data.model"));
    private static Long lastNodeStartTime = null;
    private static final Class<?> c1;
    private static final Class<?> c2;
    private static Date serviceEndDate;
    private static boolean serviceEndDateInited;
    static String jvmrouteName;

    public static String getContextPath() {
        return Strings.escapeNULL(SystemProperties.getInstance().getProperty(ENV_APPLICATION_CONTEXT_PATH_KEY), "/seeyon");
    }

    public static String getApplicationFolder() {
        if (applicationFolder == null) {
            String filepath = null;
            filepath = accessPatterns.equals(ENV_ACCESS_PATTERNS_REMOTE) ? System.getProperty("user.dir") + "/.." : SystemProperties.getInstance().getProperty(SystemProperties.CONFIG_APPLICATION_ROOT_KEY);
            applicationFolder = SystemEnvironment.getCanonicalPathAndCreate(filepath);
        }
        return applicationFolder;
    }

    private static ConfigManager getConfigManager() {
        if (configManager == null) {
            return (ConfigManager)AppContext.getBean("configManager");
        }
        return configManager;
    }

    public static String getBaseFolder() {
        if (SystemEnvironment.isBlank(baseFolder)) {
            String filepath = null;
            filepath = accessPatterns.equals(ENV_ACCESS_PATTERNS_REMOTE) ? SystemEnvironment.getApplicationFolder() + "/base" : SystemProperties.getInstance().getProperty(ENV_BASE_FOLDER_KEY);
            baseFolder = SystemEnvironment.getCanonicalPathAndCreate(filepath);
        }
        return baseFolder;
    }

    private static PartitionManager getPartitionManager() {
        if (partitionManager == null) {
            partitionManager = (PartitionManager)AppContext.getBean("partitionManager");
        }
        return partitionManager;
    }

    public static File getClusterPublicFolder(String subPath) throws BusinessException {
        String path;
        try {
            path = SystemEnvironment.getPartitionPublicFolder();
        }
        catch (BusinessException e) {
            if (e instanceof NoSuchPartitionException) {
                log.error((Object)"\u7cfb\u7edf\u5206\u533a\u6709\u95ee\u9898\uff0c2007-01-01\u7684\u5206\u533a\u4e0d\u5b58\u5728(\u5e76\u4e14\u65e0\u6709\u6548\u5206\u533a\uff09\uff0c\u5c06\u4f7f\u7528\u672c\u5730\u7684WEB-INF/pub\u76ee\u5f55\u5b58\u50a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\uff01");
            }
            log.error((Object)e.getLocalizedMessage());
            path = SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "pub";
        }
        path = path + File.separator + subPath;
        File file = new File(path);
        boolean mkdir = true;
        if (!file.exists()) {
            mkdir = file.mkdirs();
        }
        if (!mkdir && !(file = new File(SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "pub" + File.separator + subPath)).exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static String getPartitionPublicFolder() throws BusinessException {
        if (publicPartitionPath != null) {
            return publicPartitionPath;
        }
        String pubPartitionDate = "2007-01-01";
        ConfigItem configItem = SystemEnvironment.getConfigManager().getConfigItem("partition_definition", "public_partition_date");
        if (configItem != null) {
            pubPartitionDate = configItem.getConfigValue();
        }
        Date createDate = Datetimes.parse(pubPartitionDate);
        try {
            publicPartitionPath = SystemEnvironment.getPartitionManager().getFolder(createDate, true);
        }
        catch (NoSuchPartitionException e) {
            createDate = SystemEnvironment.getPartionFirstValidDate();
            if (createDate == null) {
                throw e;
            }
            log.error((Object)(pubPartitionDate + "\u7684\u5206\u533a\u4e0d\u5b58\u5728\uff0c\u5c06\u4f7f\u7528\u6700\u65e9\u6709\u6548\u7684\u5206\u533a\u4f5c\u4e3aPublic\u5206\u533a\uff01"));
            publicPartitionPath = SystemEnvironment.getPartitionManager().getFolder(createDate, true);
            pubPartitionDate = DateFormatUtils.ISO_DATE_FORMAT.format(createDate);
        }
        if (pubPartitionDate != null) {
            if (configItem == null) {
                SystemEnvironment.getConfigManager().addConfigItem("partition_definition", "public_partition_date", pubPartitionDate);
            } else if (!pubPartitionDate.equals(configItem.getConfigValue())) {
                configItem.setConfigValue(pubPartitionDate);
                SystemEnvironment.getConfigManager().updateConfigItem(configItem);
            }
        }
        return publicPartitionPath;
    }

    private static Date getPartionFirstValidDate() {
        for (Partition p : SystemEnvironment.getPartitionManager().getAllPartitions()) {
            if (!p.getState().equals(Constants.PARTITION_STATE.used.ordinal())) continue;
            return p.getStartDate();
        }
        return null;
    }

    public static String getSystemTempFolder() {
        if (SystemEnvironment.isBlank(systemTempFolder)) {
            String filepath = null;
            filepath = accessPatterns.equals(ENV_ACCESS_PATTERNS_REMOTE) ? (indexFilePath != null && !indexFilePath.isEmpty() ? indexFilePath + "/temporary" : baseFolder + "/index/temporary") : SystemProperties.getInstance().getProperty(ENV_TEMPORARY_FOLDER_KEY);
            systemTempFolder = SystemEnvironment.getCanonicalPathAndCreate(filepath);
        }
        return systemTempFolder;
    }

    public static String getSystemSyncFolder() {
        if (SystemEnvironment.isBlank(systemSyncFolder)) {
            String filepath = SystemProperties.getInstance().getProperty(ENV_FILESYNC_FOLDER_KEY);
            systemSyncFolder = SystemEnvironment.getCanonicalPathAndCreate(filepath);
        }
        return systemSyncFolder;
    }

    public static String getLogsFolder() {
        return SystemEnvironment.getApplicationFolder() + "/../../logs_sy/";
    }

    public static Collection<String> getPluginIds() {
        if (pluginIds.size() == 0) {
            pluginIds.addAll(SystemEnvironment.getAvailablePluginIds());
        }
        return new HashSet<String>(pluginIds.toSet());
    }

    public static String getPluginCRC() {
        if (pluginCRC == null) {
            CRC32 crc32 = new CRC32();
            crc32.update(new TreeSet<String>(SystemEnvironment.getPluginIds()).toString().getBytes());
            pluginCRC = String.valueOf(crc32.getValue());
        }
        return pluginCRC;
    }

    public static Collection<String> getAvailablePluginIds() {
        HashSet<String> result = new HashSet<String>();
        for (String key : pluginIds4Map.keySet()) {
            result.add(key);
        }
        return result;
    }

    public static Collection<String> getAvailableAndDisabledPluginIds() {
        HashSet<String> result = new HashSet<String>();
        for (String key : pluginIds4Map.keySet()) {
            if (!pluginIds4Map.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public static PluginDefinition getPluginDefinition(String id) {
        if (pluginDefinitions == null) {
            Object obj = MclclzUtil.invoke(c2, (String)"getInstance");
            List defs = (List)MclclzUtil.invoke(c2, (String)"getAllPluginDefinitions", null, (Object)obj, null);
            pluginDefinitions = new HashMap<String, PluginDefinition>();
            for (PluginDefinition pd : defs) {
                pluginDefinitions.put(pd.getId(), pd);
            }
        }
        return pluginDefinitions.get(id);
    }

    public static String getPluginIdsJsonStr() {
        if (pluginIdsJsonStr == null && pluginIds != null) {
            pluginIdsJsonStr = JSONUtil.toJSONString(pluginIds.toSet());
        }
        return pluginIdsJsonStr;
    }

    public static void initPluginIds(Map<String, Boolean> pluginIds4) {
        SystemEnvironment.initCache();
        pluginIds4Map.putAll(pluginIds4);
        for (Map.Entry<String, Boolean> entry : pluginIds4.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            pluginIds.add((String)((Object)((Serializable)((Object)entry.getKey()))));
        }
    }

    private static void initCache() {
        CacheAccessable factory = CacheFactory.getInstance(SystemEnvironment.class);
        pluginIds = factory.createSet("pluginIds");
        pluginIds.loadFromCacheCenter();
        pluginIds4Map = factory.createMap("pluginIds4Map");
        pluginIds4Map.loadFromCacheCenter();
    }

    public static String getClassCacheFolder() {
        return SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "cfgHome" + File.separator + "classes";
    }

    public static String getWebLibFolder() {
        return SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "lib";
    }

    public static String getSpringConfFolder() {
        return SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "cfgHome" + File.separator + "spring";
    }

    public static boolean hasPlugin(String id) {
        if (Strings.isBlank(id)) {
            return false;
        }
        if (accessPatterns.equals(ENV_ACCESS_PATTERNS_REMOTE)) {
            return true;
        }
        Boolean isHas = pluginIds4Map.get(id);
        if (Strings.equals(isHas, true)) {
            return true;
        }
        if ("distributed".equals(id)) {
            return SystemEnvironment.isDistributedMode();
        }
        if (isHas == null || !isHas.booleanValue() && "mm1".equals(id)) {
            isHas = (Boolean)MclclzUtil.invoke(c1, (String)"hasPlugin", (Class[])new Class[]{String.class}, null, (Object[])new Object[]{id});
            if (isHas.booleanValue()) {
                String pluginPath;
                if (!(SystemEnvironment.isDistributedMode() || id.startsWith("v_") || id.startsWith("MDFCN") || "accountbind".equals(id) || "moffice".equals(id) || new File(pluginPath = SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "cfgHome" + File.separator + "plugin" + File.separator + id, "pluginCfg.xml").exists())) {
                    isHas = false;
                }
                if (isHas.booleanValue()) {
                    ConfigManager cm = SystemEnvironment.getConfigManager();
                    if (cm == null) {
                        isHas = !SystemEnvironment.getDisabledPlugins().contains(id);
                    } else {
                        String disabledPluginStr;
                        ConfigItem configItem = cm.getConfigItem("disabled_plugin", "disabled_ids");
                        if (configItem != null && !Strings.isEmpty(disabledPluginStr = String.valueOf(configItem.getConfigValue()))) {
                            HashSet<String> disabledPlugins = new HashSet<String>();
                            for (String s : disabledPluginStr.split(",")) {
                                disabledPlugins.add(s);
                            }
                            if (disabledPlugins.contains(id)) {
                                isHas = false;
                            }
                        }
                    }
                }
            }
            pluginIds4Map.put(id, isHas);
        }
        return isHas;
    }

    public static boolean functionSwitch(String id) {
        boolean flag = false;
        if (!i18nList.contains(id)) {
            flag = SystemEnvironment.hasPlugin(id);
        } else if (i18nList.contains(id) && SystemEnvironment.hasPlugin("international")) {
            if ("timezone".equals(id)) {
                flag = SystemEnvironment.hasPlugin(id);
            } else {
                String itemId = null;
                if ("dataI18n".equals(id)) {
                    itemId = "data_i18n_enable";
                } else if ("datetimeFormat".equals(id)) {
                    itemId = "datetime_format_enable";
                }
                ConfigManager configManager = SystemEnvironment.getConfigManager();
                if (null != configManager && Strings.isNotBlank(itemId)) {
                    String configVal = configManager.getConfigValue("system_switch", itemId);
                    flag = "enable".equals(configVal);
                }
            }
        }
        return flag;
    }

    public static String getDogNo() {
        if (dogNo == null) {
            dogNo = (String)MclclzUtil.invoke(c1, (String)"getDogNo");
        }
        return dogNo;
    }

    public static String getCustomName() {
        if (customName == null) {
            customName = (String)MclclzUtil.invoke(c1, (String)"getCustomName");
        }
        return customName;
    }

    public static boolean isTG() {
        return (Boolean)MclclzUtil.invoke(c1, (String)"isTongDog", null, null, null);
    }

    public static boolean isDev() {
        if (accessPatterns.equals(ENV_ACCESS_PATTERNS_REMOTE)) {
            return false;
        }
        return (Boolean)MclclzUtil.invoke(c1, (String)"isDev", null, null, null);
    }

    public static boolean isDevOrTG() {
        return SystemEnvironment.isTG() || SystemEnvironment.isDev();
    }

    public static String getProductLine() {
        String productLine = null;
        try {
            productLine = (String)MclclzUtil.invoke(c1, (String)"getProductLine", null, null, null);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return productLine;
    }

    public static String getPlugin(String id) {
        String content = (String)MclclzUtil.invoke(c1, (String)"getPlugin", (Class[])new Class[]{String.class}, null, (Object[])new Object[]{id});
        return content;
    }

    public static String getHttpProxyHost() {
        return SystemProperties.getInstance().getProperty("http.proxy.host");
    }

    public static int getHttpProxyPort() {
        String port = SystemProperties.getInstance().getProperty("http.proxy.port");
        if (!SystemEnvironment.isBlank(port)) {
            return Integer.parseInt(port);
        }
        return -1;
    }

    public static String getInternetSiteURL() {
        return SystemProperties.getInstance().getProperty("internet.site.url");
    }

    public static String getDatabaseType() {
        return JDBCAgent.getDBType();
    }

    public static Dialect getDialect() {
        return JDBCAgent.getDialect();
    }

    public static ServerTypeEnum getServerType() {
        return ServerTypeEnum.getCurrentServerType();
    }

    public static boolean isX64Edition() {
        return isX64Edition;
    }

    private static boolean isBlank(String str) {
        return str == null || str.length() == 0;
    }

    private static String getCanonicalPathAndCreate(String filepath) {
        return SystemEnvironment.getCanonicalPath(filepath, true);
    }

    private static String getCanonicalPath(String filepath, boolean isCreate) {
        if (SystemEnvironment.isBlank(filepath)) {
            return null;
        }
        File f = new File(filepath);
        try {
            File fc = f.getCanonicalFile();
            if (isCreate) {
                fc.mkdirs();
            }
            return fc.getAbsolutePath();
        }
        catch (IOException iOException) {
            return filepath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFromClasspath(String filepath) {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filepath);
            if (in != null) {
                props.load(in);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    public static Date getProductUpgrageDate() {
        String d = SystemProperties.getInstance().getProperty("product.upgrage.date");
        return SystemEnvironment.toDate(d);
    }

    public static Date getProductInstallDate() {
        String d = SystemProperties.getInstance().getProperty("product.install.date");
        return SystemEnvironment.toDate(d);
    }

    public static Date getProductBuildDate() {
        String d = SystemProperties.getInstance().getProperty("product.build.date");
        return SystemEnvironment.toDate(d);
    }

    private static Date toDate(String date) {
        try {
            return Datetimes.parse(date, "yyyy-MM-dd");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getProductBuildVersion() {
        String d = SystemProperties.getInstance().getProperty("product.build.version");
        return d == null ? "" : d;
    }

    public static String getProductVersion() {
        String d = SystemProperties.getInstance().getProperty("product.release.version");
        return d == null ? "" : d;
    }

    public static String getCtpProductBuildVersion() {
        String d = SystemProperties.getInstance().getProperty("product.build.ctpversion");
        return d == null ? "" : d;
    }

    public static long getServerStartTime() {
        if (serverStartTime == null) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            serverStartTime = runtimeMXBean.getStartTime();
        }
        return serverStartTime;
    }

    public static long getLastNodeStartTime() {
        if (lastNodeStartTime == null) {
            lastNodeStartTime = SystemEnvironment.getServerStartTime();
        }
        return lastNodeStartTime;
    }

    public static boolean isU8OEM() {
        boolean b = ProductEditionEnum.isU8OEM();
        return b;
    }

    public static boolean isNCOEM() {
        boolean b = ProductEditionEnum.isNCOEM();
        return b;
    }

    public static String checkLicense() {
        return null;
    }

    public static boolean isClusterEnabled() {
        return ClusterConfigBean.getInstance().isClusterEnabled();
    }

    public void setAccessPatterns(String accessPatterns) {
        SystemEnvironment.accessPatterns = accessPatterns;
    }

    public void setIndexFilePath(String indexFilePath) {
        System.out.println("indexFilePath = ======================" + indexFilePath);
        SystemEnvironment.indexFilePath = indexFilePath;
    }

    public static String getMxVersion() {
        String defaultVersion = "M3";
        String mxVersion = (String)MclclzUtil.invoke(c1, (String)"getMxProductLine", null, null, null);
        mxVersion = Strings.isNotBlank(mxVersion) ? mxVersion.toUpperCase() : defaultVersion;
        return mxVersion;
    }

    public static Date getServiceEndDate() {
        if (!serviceEndDateInited) {
            serviceEndDateInited = true;
            serviceEndDate = (Date)MclclzUtil.invoke(c1, (String)"getServiceEndDate");
        }
        return serviceEndDate;
    }

    public static void exit(int status) {
        if (!ServerTypeEnum.Tomcat.equals((Object)ServerTypeEnum.getCurrentServerType())) {
            throw new RuntimeException("system halted!");
        }
        System.exit(status);
    }

    public static String getJvmRoute() {
        String confPath = System.getProperty("catalina.base") + File.separator + "conf" + File.separator + "server.xml";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Engine".equals(qName)) {
                        jvmrouteName = attributes.getValue("jvmRoute");
                    }
                }
            });
            XXEUtil.prevent(reader);
            reader.parse(confPath);
        }
        catch (Exception e) {
            log.error((Object)"\u8bfb\u53d6tomcat\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
        }
        if (StringUtils.isBlank((CharSequence)jvmrouteName)) {
            jvmrouteName = "\u672a\u914d\u7f6e";
        }
        return jvmrouteName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getDisabledPlugins() {
        if (disabledPlugins != null) {
            return disabledPlugins;
        }
        disabledPlugins = new HashSet<String>();
        Connection conn = Utils.getConnection();
        JDBCAgent agent = new JDBCAgent(conn);
        try {
            String disabledPluginStr;
            agent.execute("SELECT CONFIG_VALUE FROM ctp_config WHERE CONFIG_CATEGORY='disabled_plugin' AND CONFIG_ITEM='disabled_ids'");
            List r = agent.resultSetToList();
            if (!r.isEmpty() && !Strings.isEmpty(disabledPluginStr = (String)((Map)r.get(0)).get("config_value"))) {
                for (String s : disabledPluginStr.split(",")) {
                    disabledPlugins.add(s);
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getLocalizedMessage(), e);
        }
        finally {
            agent.close();
            try {
                conn.close();
            }
            catch (Exception r) {}
        }
        return disabledPlugins;
    }

    public static boolean isDistributedMode() {
        return RedisHandler.isRedisEnabled() && !SystemEnvironment.getAppId().equals("4095");
    }

    public static String getAppId() {
        return RedisHandler.APP_ID;
    }

    public static boolean isBaseService() {
        return (Integer.parseInt(SystemEnvironment.getAppId()) & PlatformAppEnum.Base.getType()) > 0;
    }

    public static boolean isCAPService() {
        return (Integer.parseInt(SystemEnvironment.getAppId()) & PlatformAppEnum.Cap.getType()) > 0;
    }

    public static boolean isCIPService() {
        return (Integer.parseInt(SystemEnvironment.getAppId()) & PlatformAppEnum.Other.getType()) > 0;
    }

    public static boolean isMessageService() {
        return (Integer.parseInt(SystemEnvironment.getAppId()) & PlatformAppEnum.Message.getType()) > 0;
    }

    public static void setBootFinished(boolean booted) {
        bootFinished = booted;
    }

    public static boolean isBootFinished() {
        return bootFinished;
    }

    public static boolean isRemoteMode() {
        return accessPatterns.equals(ENV_ACCESS_PATTERNS_REMOTE);
    }

    static {
        if (SystemEnvironment.isDistributedMode()) {
            PlatformConfigUtil.addMessageListener(MessageChannel.SYS_START_TIME, new MessageListener(){

                @Override
                public void onMessage(String message) {
                    if (Strings.isDigits(message)) {
                        lastNodeStartTime = Long.valueOf(message);
                        pluginIdsJsonStr = null;
                    }
                }
            });
        }
        c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.product.ProductInfo");
        c2 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.common.plugin.PluginSystemInit");
        serviceEndDateInited = false;
        jvmrouteName = "";
    }
}

