/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common;

import com.seeyon.ctp.common.BeansOfTypeListener;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.cache.ThreadCacheFactory;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.dubbo.DubboServiceContext;
import com.seeyon.ctp.services.security.ServiceManager;
import com.seeyon.ctp.util.Cookies;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.v3x.common.web.util.ThreadLocalUtil;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

public final class AppContext {
    private static final Log LOGGER = CtpLogFactory.getLog(AppContext.class);
    private static ApplicationContext ac = null;
    private static File cfgHome = null;
    private static User dummyUser = null;
    private static final ThreadLocal userCtx = new ThreadLocal();
    private static final Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> beanCacheMap = new ConcurrentHashMap<String, Object>();
    private static final Map<Class<?>, Map<String, ?>> beanOfTypeCacheMap = new ConcurrentHashMap();
    private static final Map<Class, Set<BeansOfTypeListener>> beanOfTypeListenerMap = new ConcurrentHashMap<Class, Set<BeansOfTypeListener>>();
    private static boolean beanInjectHasFinished = false;

    private AppContext() {
    }

    public static void init(ApplicationContext wac, File hapHome) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ac = wac;
        cfgHome = hapHome;
    }

    public static User getCurrentUser() {
        String token;
        HttpServletRequest request;
        User user = (User)AppContext.getThreadContext("SESSION_CONTEXT_USERINFO_KEY");
        if (user == null) {
            try {
                user = (User)AppContext.getSessionContext("com.seeyon.current_user");
            }
            catch (InfrastructureException infrastructureException) {
                // empty catch block
            }
        }
        if (user == null && (request = AppContext.getRawRequest()) != null && (token = AppContext.getToken(request)) != null) {
            ServiceManager.getInstance().initCurrentUser(request, token);
            user = (User)AppContext.getThreadContext("SESSION_CONTEXT_USERINFO_KEY");
        }
        return user;
    }

    private static String getToken(HttpServletRequest request) {
        String token = request.getHeader("token");
        if (Strings.isEmpty(token)) {
            token = request.getParameter("token");
        }
        if (Strings.isEmpty(token)) {
            token = Cookies.get(request, "token");
        }
        return token;
    }

    public static long currentUserId() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return -1L;
        }
        return currentUser.getId();
    }

    public static String currentUserLoginName() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return "";
        }
        return currentUser.getLoginName();
    }

    public static String currentUserName() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return "Robot";
        }
        return currentUser.getName();
    }

    public static long currentAccountId() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return -1L;
        }
        return currentUser.getLoginAccount();
    }

    public static String currentAccountName() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return "";
        }
        return currentUser.getLoginAccountName();
    }

    public static boolean isGroupAdmin() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return currentUser.isGroupAdmin();
    }

    public static boolean isAdministrator() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return currentUser.isAdministrator();
    }

    public static boolean isAuditAdmin() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return currentUser.isAuditAdmin();
    }

    public static boolean isSystemAdmin() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return currentUser.isSystemAdmin();
    }

    public static boolean isAdmin() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return currentUser.isAdmin();
    }

    public static String getRemoteAddr() {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return "";
        }
        return currentUser.getRemoteAddr();
    }

    public static Object getBean(String beanName) {
        Object bean = beanCacheMap.get(beanName);
        if (bean == null) {
            AppContext.warningMethodInvoke("getBean", beanName);
            if (ac == null) {
                return null;
            }
            try {
                bean = ac.getBean(beanName);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("\u52a0\u8f7dbean[" + beanName + "] \u5931\u8d25 " + e.getMessage()));
            }
            if (beanName != null && bean != null) {
                beanCacheMap.put(beanName, bean);
            }
        }
        if (bean == null && SystemEnvironment.isDistributedMode()) {
            return DubboServiceContext.getBean(beanName);
        }
        return bean;
    }

    public static void setBean(String beanName, Object obj) {
        if (null == beanCacheMap.get(beanName)) {
            beanCacheMap.put(beanName, obj);
        }
    }

    public static Object getBeanWithoutCache(String beanName) {
        AppContext.warningMethodInvoke("getBeanWithoutCache", beanName);
        return ac.getBean(beanName);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        Map result = beanOfTypeCacheMap.get(type);
        if (result == null) {
            AppContext.warningMethodInvoke("getBeansOfType", type);
            result = ac.getBeansOfType(type);
            if (type != null && result != null) {
                beanOfTypeCacheMap.put(type, result);
            }
            if (SystemEnvironment.isDistributedMode()) {
                Map<String, T> dubboBeansOfType = DubboServiceContext.getBeansOfType(type);
                result.putAll(dubboBeansOfType);
            }
        }
        return result;
    }

    public static void addBeansOfTypeListener(Class type, BeansOfTypeListener listener) {
        Set<BeansOfTypeListener> listeners = beanOfTypeListenerMap.get(type);
        if (listeners == null) {
            listeners = new HashSet<BeansOfTypeListener>();
            beanOfTypeListenerMap.put(type, listeners);
        }
        listeners.add(listener);
    }

    public static File getCfgHome() {
        if (cfgHome == null || !cfgHome.exists() || !cfgHome.isDirectory()) {
            throw new InfrastructureException();
        }
        return cfgHome;
    }

    public static String getSystemProperty(String key) {
        return SystemProperties.getInstance().getProperty(key);
    }

    public static void putThreadContext(String ctxKey, Object ctxValue) {
        HashMap<String, Object> ctxMap = (HashMap<String, Object>)userCtx.get();
        if (ctxMap == null) {
            ctxMap = new HashMap<String, Object>();
            userCtx.set(ctxMap);
        }
        ctxMap.put(ctxKey, ctxValue);
    }

    public static Object getThreadContext(String ctxKey) {
        Map ctxMap = (Map)userCtx.get();
        if (ctxMap == null) {
            return null;
        }
        return ctxMap.get(ctxKey);
    }

    public static void removeThreadContext(String ctxKey) {
        Map ctxMap = (Map)userCtx.get();
        if (ctxMap != null) {
            ctxMap.remove(ctxKey);
        }
    }

    public static void clearThreadContext() {
        userCtx.set(null);
        ThreadCacheFactory.reset();
        JDBCAgent.release();
        try {
            ThreadLocalUtil.removeThreadLocal();
        }
        catch (Exception e) {
            LOGGER.error((Object)("ThreadLocalUtil.removeThreadLocal error." + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public static void putCache(String key, Object value) {
        if (key != null && value != null) {
            cacheMap.put(key, value);
        }
    }

    public static Object getCache(String key) {
        return cacheMap.get(key);
    }

    public static void putSessionContext(String ctxKey, Object ctxValue) {
        HttpSession session = (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
        if (session != null) {
            if ("com.seeyon.current_user".equals(ctxKey) && session.getAttribute(ctxKey) != null) {
                LOGGER.debug((Object)("Current User change to:" + JSONUtil.toJSONString(ctxValue)), (Throwable)new Exception());
            }
        } else {
            throw new InfrastructureException("Session isnot in current thread context.");
        }
        session.setAttribute(ctxKey, ctxValue);
    }

    public static void removeSessionArrribute(String key) {
        HttpSession session = (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
        if (session != null) {
            try {
                session.removeAttribute(key);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static Object getSessionContext(String ctxKey) {
        HttpSession session = (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
        if (session != null) {
            return session.getAttribute(ctxKey);
        }
        throw new InfrastructureException("Session isnot in current thread context.");
    }

    public static HttpSession getRawSession() {
        return (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
    }

    public static void putRequestContext(String ctxKey, Object ctxValue) {
        HttpServletRequest request = (HttpServletRequest)AppContext.getThreadContext("THREAD_CONTEXT_REQUEST_KEY");
        if (request == null) {
            throw new InfrastructureException("Request isnot in current thread context.");
        }
        request.setAttribute(ctxKey, ctxValue);
    }

    public static Object getRequestContext(String ctxKey) {
        HttpServletRequest request = (HttpServletRequest)AppContext.getThreadContext("THREAD_CONTEXT_REQUEST_KEY");
        if (request != null) {
            return request.getAttribute(ctxKey);
        }
        throw new InfrastructureException("Request isnot in current thread context.");
    }

    public static HttpServletRequest getRawRequest() {
        return (HttpServletRequest)AppContext.getThreadContext("THREAD_CONTEXT_REQUEST_KEY");
    }

    public static HttpServletResponse getRawResponse() {
        return (HttpServletResponse)AppContext.getThreadContext("THREAD_CONTEXT_RESPONSE_KEY");
    }

    public static boolean hasPlugin(String id) {
        return SystemEnvironment.hasPlugin(id);
    }

    public static String getPlugin(String id) {
        return SystemEnvironment.getPlugin(id);
    }

    public static boolean hasResourceCode(String resourceCode) {
        User currentUser = AppContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return currentUser.hasResourceCode(resourceCode);
    }

    public static Locale getLocale() {
        Locale currentLocale = null;
        try {
            User user = AppContext.getCurrentUser();
            if (user != null) {
                currentLocale = user.getLocale();
                if (currentLocale != null) {
                    String lang = currentLocale.getLanguage();
                    if (Strings.isNotEmpty(lang)) {
                        String country;
                        if (!LocaleContext.getAllLocales().contains(currentLocale) && !Strings.isEmpty(country = currentLocale.getCountry())) {
                            currentLocale = new Locale(currentLocale.getLanguage());
                            if (!LocaleContext.getAllLocales().contains(currentLocale)) {
                                currentLocale = Locale.getDefault();
                            }
                        }
                    } else {
                        currentLocale = Locale.getDefault();
                    }
                } else {
                    currentLocale = Locale.getDefault();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (currentLocale == null && AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY") != null) {
            try {
                currentLocale = (Locale)AppContext.getSessionContext(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        if (currentLocale == null) {
            String localeString = LocaleContext.getSysDefaultLocale();
            currentLocale = I18nUtil.parseLocale(localeString);
        }
        if (currentLocale == null) {
            List<Locale> allLocales = LocaleContext.getAllLocales();
            currentLocale = allLocales != null ? allLocales.get(0) : Locale.getDefault();
        }
        return currentLocale;
    }

    public static boolean isRunningModeDevelop() {
        return "develop".equals(AppContext.getSystemProperty(SystemProperties.CONFIG_RUNNING_MODE));
    }

    public static boolean isRunningModeTest() {
        return "test".equals(AppContext.getSystemProperty(SystemProperties.CONFIG_RUNNING_MODE));
    }

    public static boolean isRunningModeProduction() {
        String rmode = AppContext.getSystemProperty(SystemProperties.CONFIG_RUNNING_MODE);
        return !"develop".equals(rmode) && !"test".equals(rmode);
    }

    public static void initSystemEnvironmentContext(HttpServletRequest request, HttpServletResponse response) {
        AppContext.initSystemEnvironmentContext(request, response, true);
    }

    public static void initSystemEnvironmentContext(HttpServletRequest request, HttpServletResponse response, boolean session) {
        HttpSession httpSession = request.getSession(session);
        AppContext.putThreadContext("THREAD_CONTEXT_SESSION_KEY", httpSession);
        if (httpSession != null) {
            AppContext.putThreadContext("SESSION_CONTEXT_USERINFO_KEY", AppContext.getSessionContext("com.seeyon.current_user"));
        } else {
            AppContext.removeThreadContext("SESSION_CONTEXT_USERINFO_KEY");
        }
        AppContext.putThreadContext("THREAD_CONTEXT_REQUEST_KEY", request);
        AppContext.putThreadContext("THREAD_CONTEXT_RESPONSE_KEY", response);
    }

    private static User initDummyUser() {
        User u = null;
        File userCtxFile = new File(AppContext.getCfgHome(), "base/userCtx_dev.xml");
        if (!userCtxFile.exists() || !userCtxFile.isFile()) {
            LOGGER.error((Object)("User context configuration does not existes: " + userCtxFile.getAbsolutePath()));
            throw new InfrastructureException();
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("userCtx", User.class);
        digester.addSetProperties("userCtx/user");
        try {
            u = (User)digester.parse(userCtxFile);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            throw new InfrastructureException(e);
        }
        return u;
    }

    public static boolean isBizCreator() {
        return true;
    }

    public static boolean isNCOEM() {
        return ProductEditionEnum.isNCOEM();
    }

    public static boolean isU8OEM() {
        return ProductEditionEnum.isU8OEM();
    }

    public static boolean isCworkInner() {
        return ProductEditionEnum.isCworkInner();
    }

    public static boolean isCworkOuter() {
        return ProductEditionEnum.isCworkOuter();
    }

    public static void setBeanInjectFinish() {
        beanInjectHasFinished = true;
    }

    private static void warningMethodInvoke(String methodName, Object ... params) {
    }

    public static void loadBeanDefinitions(String ... locations) throws BeanDefinitionStoreException {
        XmlWebApplicationContext ctx = (XmlWebApplicationContext)ac;
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx.getBeanFactory());
        reader.loadBeanDefinitions(locations);
    }

    public static ApplicationContext getApplicationContext() {
        return ac;
    }

    public static <T> void clearBeansOfType(Class<T> clazz) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("clear BeansOfType : " + clazz.getCanonicalName()));
        }
        beanOfTypeCacheMap.remove(clazz);
        Set<BeansOfTypeListener> listeners = beanOfTypeListenerMap.get(clazz);
        if (listeners != null) {
            for (BeansOfTypeListener listener : listeners) {
                listener.onChange(clazz);
            }
        }
    }
}

