/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster.notification;

import com.seeyon.ctp.cluster.notification.BatchNotification;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.timer.TimerHolder;
import java.util.HashSet;
import java.util.Stack;

public class TimerNotificationSender {
    private Stack<Object[]> current = new Stack();

    public TimerNotificationSender(long period) {
        if (NotificationManager.getInstance().isEnabled()) {
            TimerHolder.newTimer(new Runnable(){

                @Override
                public void run() {
                    Stack queue = TimerNotificationSender.this.current;
                    TimerNotificationSender.this.current = new Stack();
                    BatchNotification notification = new BatchNotification();
                    HashSet<String> keys = new HashSet<String>();
                    while (!queue.isEmpty()) {
                        Object[] o = (Object[])queue.pop();
                        if (o == null) continue;
                        if (o.length == 2 && o[1] instanceof String) {
                            String key = String.valueOf(o[0]) + String.valueOf(o[1]);
                            if (keys.contains(key)) continue;
                            keys.add(key);
                        }
                        notification.add((NotificationType)((Object)o[0]), o[1]);
                    }
                    if (notification.size() > 0) {
                        NotificationManager.getInstance().send(notification);
                    }
                }
            }, period);
        }
    }

    public void add(NotificationType type, Object content) {
        if (NotificationManager.getInstance().isEnabled()) {
            this.current.add(new Object[]{type, content});
        }
    }
}

