/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster.notification;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.adapter.jgroups.CNotification;
import com.seeyon.ctp.cluster.adapter.jgroups.CNotificationServiceFactory;
import com.seeyon.ctp.cluster.adapter.jgroups.ICNotificationHandler;
import com.seeyon.ctp.cluster.adapter.jgroups.ICNotificationService;
import com.seeyon.ctp.cluster.notification.Notification;
import com.seeyon.ctp.common.cache.geode.GeodeService;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PendingNotificationQueue {
    private static final Log log = LogFactory.getLog(PendingNotificationQueue.class);
    private static final PendingNotificationQueue INSTANCE = new PendingNotificationQueue();
    private Queue<CNotification> queue = new ConcurrentLinkedQueue<CNotification>();
    private boolean enabled = true;

    private PendingNotificationQueue() {
    }

    public static final PendingNotificationQueue getInstance() {
        return INSTANCE;
    }

    public void offer(CNotification notification) {
        if (!this.enabled) {
            return;
        }
        log.debug((Object)("\u52a0\u5165\u5ef6\u8fdf\u5904\u7406\u961f\u5217:" + notification));
        this.queue.offer(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        this.enabled = false;
        log.debug((Object)"\u5f00\u59cb\u5904\u7406\u961f\u5217\u4e2d\u7684\u901a\u77e5\u3002");
        if (RedisHandler.isRedisEnabled()) {
            CNotification notification = null;
            do {
                try {
                    notification = this.queue.poll();
                    if (notification == null) {
                        return;
                    }
                    RedisHandler.handleNotify((Notification)notification.getContent());
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                }
            } while (notification != null);
        } else if (ClusterConfigBean.getInstance().isGeodeEnabled()) {
            CNotification notification = null;
            do {
                try {
                    notification = this.queue.poll();
                    if (notification == null) {
                        return;
                    }
                    GeodeService.handleNotify((Notification)notification.getContent());
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                }
            } while (notification != null);
        } else {
            CNotification notification = null;
            ICNotificationService service = CNotificationServiceFactory.getCNotificationService();
            do {
                try {
                    notification = this.queue.poll();
                    if (notification == null) {
                        return;
                    }
                    int type = notification.getType();
                    ICNotificationHandler handler = service.getHandler(type);
                    if (handler != null) {
                        log.debug((Object)("\u5904\u7406:" + notification));
                        try {
                            RedisHandler.stopDispatch();
                            handler.handler(notification);
                            continue;
                        }
                        finally {
                            RedisHandler.continueDispatch();
                        }
                    }
                    log.warn((Object)("\u6ca1\u6709\u6ce8\u518cHandler:" + type));
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                }
            } while (notification != null);
        }
    }
}

