/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster.notification;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.adapter.jgroups.CNotification;
import com.seeyon.ctp.cluster.adapter.jgroups.CNotificationServiceFactory;
import com.seeyon.ctp.cluster.adapter.jgroups.ICNotificationHandler;
import com.seeyon.ctp.cluster.adapter.jgroups.ICNotificationService;
import com.seeyon.ctp.cluster.notification.BatchNotification;
import com.seeyon.ctp.cluster.notification.Notification;
import com.seeyon.ctp.cluster.notification.NotificationFactory;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationTransactionManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.cluster.notification.PendingNotificationQueue;
import com.seeyon.ctp.common.cache.geode.GeodeNotificationManager;
import com.seeyon.ctp.common.cache.geode.GeodeService;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.cache.redis.RedisNotificationManager;
import com.seeyon.ctp.util.Strings;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.JChannel;

public class NotificationManager
implements NotificationFactory {
    private static final Log LOG = LogFactory.getLog(NotificationManager.class);
    private static NotificationFactory INSTANCE;
    private boolean enabled = false;
    private boolean sendEnabled = true;
    private static ThreadLocal<Boolean> enableEvents;
    private String clusterId = "";
    private String clusterIndex = "";
    private String localAddress = "";

    protected NotificationManager() {
        ClusterConfigBean clusterConfig = ClusterConfigBean.getInstance();
        if (clusterConfig.isClusterEnabled()) {
            this.enabled = true;
            if (clusterConfig.isGeodeEnabled()) {
                return;
            }
            LOG.info((Object)"\u542f\u7528\u96c6\u7fa4\uff08\u975eGeode\uff09\u3002");
            this.clusterId = clusterConfig.getClusterName();
            this.clusterIndex = clusterConfig.getClusterHostIndex();
            final ICNotificationService service = CNotificationServiceFactory.getCNotificationService();
            this.localAddress = service.getLocalAddress();
            service.registerCNotificationHandler(NotificationType.BatchNotification.ordinal(), new ICNotificationHandler(){

                @Override
                public void handler(CNotification message) {
                    if (message == null) {
                        LOG.warn((Object)"message is null");
                        return;
                    }
                    Object content = message.getContent();
                    if (content == null) {
                        return;
                    }
                    if (content instanceof List) {
                        List nl = (List)content;
                        for (Notification n : nl) {
                            NotificationType type = n.getType();
                            int ordinal = type.ordinal();
                            ICNotificationHandler handler = service.getHandler(ordinal);
                            if (handler == null) continue;
                            CNotification msg = new CNotification(message);
                            msg.setType(ordinal);
                            msg.setContent(n.getContent());
                            LOG.debug((Object)("\u5904\u7406\u590d\u5408\u901a\u77e5\u7684\u5b50\u901a\u77e5\uff1a" + (Object)((Object)type)));
                            handler.handler(msg);
                        }
                    } else {
                        LOG.warn((Object)("\u4e0d\u53ef\u8bc6\u522b\u7684\u590d\u5408\u901a\u77e5\u6570\u636e\u3002\u671f\u5f85\uff1aBatchNotification\uff1b\u5b9e\u9645\uff1a" + content));
                    }
                }
            });
            service.registerCNotificationHandler(-100, new ICNotificationHandler(){

                @Override
                public void handler(CNotification message) {
                    PendingNotificationQueue.getInstance().offer(message);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NotificationFactory getInstance() {
        Class<NotificationFactory> clazz = NotificationFactory.class;
        synchronized (NotificationFactory.class) {
            if (INSTANCE == null) {
                INSTANCE = RedisHandler.isRedisEnabled() ? new RedisNotificationManager() : (ClusterConfigBean.getInstance().isGeodeEnabled() ? new GeodeNotificationManager(GeodeService.getEventRegion()) : new NotificationManager());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void send(NotificationType type, Object content) {
        this.send(type, content, false);
    }

    @Override
    public void send(NotificationType type, Object content, boolean force) {
        Notification notification = new Notification();
        notification.setType(type);
        notification.setContent(content);
        this.send(notification, force);
    }

    @Override
    public void send(Notification notification) {
        this.send(notification, false);
    }

    @Override
    public void send(Notification notification, boolean force) {
        BatchNotification bn;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isSendEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("send notification disabled,ignore:" + notification));
            }
            return;
        }
        Boolean enable = enableEvents.get();
        enable = enable == null ? true : enable;
        NotificationType type = notification.getType();
        if (NotificationType.BatchNotification == type && (bn = (BatchNotification)notification).size() == 0) {
            return;
        }
        Object content = notification.getContent();
        if (!force && !enable.booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignore,current thread send notification disabled " + (Object)((Object)type)));
            }
            return;
        }
        NotificationTransactionManager transManager = NotificationTransactionManager.getInstance();
        if (transManager.hasTransaction() && !NotificationType.ProductInfo.equals((Object)type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("add notification to batch:" + (Object)((Object)type)));
            }
            transManager.addNotification(type, content);
            return;
        }
        try {
            CNotification n = new CNotification();
            n.setType(type.ordinal());
            n.setContent(content);
            n.setClusterId(this.clusterId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("send notification:" + n));
            }
            CNotificationServiceFactory.getCNotificationService().sendCNotification(n);
            this.statistics(notification);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void statistics(Notification notification) {
        if (LOG.isDebugEnabled()) {
            NotificationType type = notification.getType();
            if (NotificationType.BatchNotification == type) {
                LOG.debug((Object)"send notification: batch");
                BatchNotification bn = (BatchNotification)notification;
                for (Notification nn : bn) {
                    LOG.debug((Object)("send notification:" + nn));
                }
            } else {
                LOG.debug((Object)("send notification:" + (Object)((Object)type)));
            }
        }
    }

    @Override
    public void register(NotificationType type, NotificationListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.isEnabled()) {
            this.logRegister(type, listener, "register ignore:");
            return;
        }
        this.logRegister(type, listener, "register:");
        CNotificationServiceFactory.getCNotificationService().registerCNotificationHandler(type.ordinal(), new NotificationHandlerDecorator(listener));
    }

    private void logRegister(NotificationType type, NotificationListener listener, String action) {
        if (LOG.isDebugEnabled()) {
            if ("AnnotationReflectListener".equals(listener.getClass().getSimpleName())) {
                LOG.debug((Object)(action + (Object)((Object)type) + "(" + type.ordinal() + ")-" + listener));
            } else {
                LOG.debug((Object)(action + (Object)((Object)type) + "(" + type.ordinal() + ")-" + listener.getClass().getSimpleName()));
            }
        }
    }

    @Override
    public void register(NotificationListener listener) {
        this.register(listener.getType(), listener);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getClusterIndex() {
        return this.clusterIndex;
    }

    @Override
    public String getLocalAddress() {
        if (Strings.isEmpty(this.localAddress)) {
            this.localAddress = CNotificationServiceFactory.getCNotificationService().getLocalAddress();
        }
        return this.localAddress;
    }

    public static void removeThreadLocal() {
        enableEvents.remove();
    }

    @Override
    public void enableSend(boolean enable) {
        this.sendEnabled = enable;
    }

    @Override
    public boolean isSendEnabled() {
        return this.sendEnabled;
    }

    @Override
    public void stop() {
        JChannel channel = CNotificationServiceFactory.getCNotificationService().getChannel();
        if (channel != null) {
            channel.close();
        }
    }

    static {
        enableEvents = new ThreadLocal();
    }

    final class NotificationHandlerDecorator
    implements ICNotificationHandler {
        private final NotificationListener listener;

        public String toString() {
            return "NotificationHandlerDecorator [listener=" + this.listener + "]";
        }

        public NotificationHandlerDecorator(NotificationListener handler) {
            this.listener = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handler(CNotification message) {
            String senderClusterId;
            if (message == null) {
                LOG.warn((Object)"message is null");
                return;
            }
            String myClusterId = NotificationManager.this.getClusterId();
            if (!myClusterId.equals(senderClusterId = message.getClusterId())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("\u63a5\u6536\u5230\u5176\u4ed6\u96c6\u7fa4\u7684\u901a\u77e5\uff0c\u5ffd\u7565\uff01" + senderClusterId));
                }
                return;
            }
            try {
                enableEvents.set(false);
                this.listener.handle(message.getContent());
            }
            catch (Throwable t) {
                LOG.error((Object)"\u5904\u7406\u96c6\u7fa4\u901a\u77e5\u51fa\u9519", t);
            }
            finally {
                enableEvents.set(true);
            }
        }
    }
}

