/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.PropertiesReader;
import com.seeyon.ctp.cluster.notification.NotificationFactory;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.BugPatchIndexManagerBean;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;

public final class ClusterConfigValidator {
    private static final NotificationType TYPE_CONFIG_VALIDATE = NotificationType.ConfigValidate;
    private static final ClusterConfigValidator INSTANCE = new ClusterConfigValidator();
    private static final Log LOG = CtpLogFactory.getLog(ClusterConfigValidator.class);
    private static final Log console = CtpLogFactory.getLog("console");
    private static Set<String> parameters = null;
    private static Set<String> paths = null;
    private transient boolean ok = false;

    public static ClusterConfigValidator getInstance() {
        return INSTANCE;
    }

    private ClusterConfigValidator() {
        this.init();
    }

    private void init() {
        final boolean isClusterMain = ClusterConfigBean.getInstance().isClusterMain();
        NotificationManager.getInstance().register(new NotificationListener(){
            private static final String KEY_SENDER = "RequestSender";
            private static final String KEY_SENDER_ADDR = "SenderAddress";

            @Override
            public NotificationType getType() {
                return TYPE_CONFIG_VALIDATE;
            }

            @Override
            public void handle(Object o) {
                if (o instanceof String) {
                    if (!isClusterMain) {
                        LOG.debug((Object)"\u4ece\u670d\u52a1\u5668\u63a5\u6536\u5230\u5176\u5b83\u8282\u70b9\u7684\u914d\u7f6e\u68c0\u67e5\u8bf7\u6c42\uff0c\u5ffd\u7565\u3002");
                        return;
                    }
                    LOG.info((Object)("\u63a5\u6536\u5230\u4ece\u670d\u52a1\u5668\u914d\u7f6e\u68c0\u67e5\u7684\u8bf7\u6c42\u3002" + o));
                    Properties[] data = ClusterConfigValidator.this.collect();
                    data[0].put(KEY_SENDER, o);
                    data[0].put(KEY_SENDER_ADDR, NotificationManager.getInstance().getLocalAddress());
                    data[0].put("currentTimeMillis", (Object)System.currentTimeMillis());
                    data[0].put("BUGS", BugPatchIndexManagerBean.getInstance().getBUGS());
                    data[0].put("PATCHS", BugPatchIndexManagerBean.getInstance().getPATCHS());
                    NotificationFactory manager = NotificationManager.getInstance();
                    boolean isSendEnabled = manager.isSendEnabled();
                    manager.enableSend(true);
                    manager.send(TYPE_CONFIG_VALIDATE, data, true);
                    manager.enableSend(isSendEnabled);
                    LOG.info((Object)"\u63a8\u9001\u914d\u7f6e\u4fe1\u606f\u3002");
                } else {
                    if (ClusterConfigValidator.this.ok) {
                        return;
                    }
                    Properties[] config = (Properties[])o;
                    Properties mainServerConfig = config[0];
                    String mainServerName = mainServerConfig.getProperty(KEY_SENDER_ADDR);
                    LOG.debug((Object)("Main Server:" + mainServerName));
                    if (isClusterMain) {
                        ClusterConfigValidator.this.ok = false;
                        ClusterConfigValidator.this.out("\u5df2\u7ecf\u6709\u4e00\u4e2a\u4e3b\u670d\u52a1\u5668" + mainServerName + "\u5728\u8fd0\u884c\uff0c\u540c\u4e00\u96c6\u7fa4\u53ea\u80fd\u542f\u52a8\u4e00\u4e2a\u4e3b\u670d\u52a1\u5668\u3002\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\uff01");
                        return;
                    }
                    LOG.info((Object)("\u63a5\u6536\u5230\u4e3b\u670d\u52a1\u5668" + mainServerName + "\u7684\u914d\u7f6e\u4fe1\u606f\uff0c\u5f00\u59cb\u68c0\u67e5\u3002"));
                    if (NotificationManager.getInstance().getClusterIndex().equals(mainServerConfig.get(KEY_SENDER))) {
                        List<String> localBUGS;
                        long serverTime = (Long)mainServerConfig.get("currentTimeMillis");
                        long v = serverTime - System.currentTimeMillis();
                        if (Math.abs(v) > 3000L) {
                            String msg = "\u4e3b\u670d\u52a1\u5668\u65f6\u95f4\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u60a8\u7684\u7cfb\u7edf\u65f6\u95f4\uff01 \uff3b\u4e3b\u670d\u52a1\u5668\u65f6\u95f4 - \u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4 = " + v / 1000L + " \u79d2\uff3d \u670d\u52a1\u5668\u65f6\u95f4\u5dee\u5f02\u5fc5\u987b\u5c0f\u4e8e3\u79d2\u3002";
                            ClusterConfigValidator.this.out(msg);
                            return;
                        }
                        LOG.info((Object)("\u4e3b\u670d\u52a1\u5668\u65f6\u95f4:" + new Date(serverTime)));
                        List mainPATCHS = (List)mainServerConfig.get("PATCHS");
                        List<String> localPATCHS = BugPatchIndexManagerBean.getInstance().getPATCHS();
                        if (!CollectionUtils.isEqualCollection((Collection)mainPATCHS, localPATCHS)) {
                            String msg = "\u5f53\u524d\u670d\u52a1\u5668\u4e0e\u4e3b\u670d\u52a1\u5668\u7684\u6708\u4fee\u590d\u5305\u7a0b\u5e8f\u4e0d\u4e00\u81f4\u3002\u4e3b\uff1a" + mainPATCHS + "; \u672c\u673a: " + localPATCHS;
                            ClusterConfigValidator.this.out(msg);
                            return;
                        }
                        List mainBUGS = (List)mainServerConfig.get("BUGS");
                        if (!CollectionUtils.isEqualCollection((Collection)mainBUGS, localBUGS = BugPatchIndexManagerBean.getInstance().getBUGS())) {
                            String msg = "\u5f53\u524d\u670d\u52a1\u5668\u4e0e\u4e3b\u670d\u52a1\u5668\u7684BUG\u8865\u4e01\u5305\u7a0b\u5e8f\u4e0d\u4e00\u81f4\u3002\u4e3b\uff1a" + mainBUGS + "; \u672c\u673a: " + localBUGS;
                            ClusterConfigValidator.this.out(msg);
                            return;
                        }
                        ClusterConfigValidator.this.ok = ClusterConfigValidator.this.validate(config);
                    } else {
                        LOG.debug((Object)"\u672a\u53d1\u68c0\u67e5\u8bf7\u6c42\uff0c\u5ffd\u7565\u68c0\u67e5");
                    }
                }
            }
        });
    }

    public synchronized void validate() {
        boolean isClusterMain = ClusterConfigBean.getInstance().isClusterMain();
        if (isClusterMain) {
            console.info((Object)"\u4e0e\u5176\u4ed6\u96c6\u7fa4\u8282\u70b9\u63e1\u624b\uff0c\u8bf7\u7b49\u5f8520\u79d2...");
        } else {
            console.info((Object)"\u5f53\u524d\u662f\u4ece\u670d\u52a1\u5668\uff0c\u5f00\u59cb\u4ece\u4e3b\u670d\u52a1\u5668\u540c\u6b65\u914d\u7f6e\u4fe1\u606f(\u6700\u957f\u9700\u898120\u79d2)...");
        }
        NotificationFactory manager = NotificationManager.getInstance();
        this.ok = isClusterMain;
        manager.send(TYPE_CONFIG_VALIDATE, manager.getClusterIndex());
        int counter = 0;
        while (!this.ok && counter++ < 10) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!this.ok) {
            if (isClusterMain) {
                this.out("\u4e0d\u80fd\u542f\u52a8\u96c6\u7fa4/\u53cc\u673a\u7684\u4e3b\u670d\u52a1\u5668\uff0c\u8bf7\u786e\u8ba4\u540c\u4e00\u96c6\u7fa4\u6ca1\u6709\u522b\u7684\u4e3b\u670d\u52a1\u5668\u5728\u8fd0\u884c\u3002");
            } else {
                this.out("\u4e0d\u80fd\u542f\u52a8\u96c6\u7fa4/\u53cc\u673a\u7684\u4ece\u670d\u52a1\u5668\uff0c\u8bf7\u786e\u8ba4\u4e3b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u52a8\u5e76\u4e14\u6b63\u786e\u914d\u7f6e\u3002");
            }
        }
    }

    private void out(String msg) {
        LOG.fatal((Object)msg);
        System.out.println("**************************************************************************");
        System.out.println("");
        System.out.println("Exception,Warn : " + msg);
        System.out.println("");
        System.out.println("**************************************************************************");
        try {
            Thread.sleep(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(-1);
    }

    private boolean validate(Properties[] config) {
        if (config == null || config.length < 3) {
            return false;
        }
        SystemProperties.getInstance().init(config[1]);
        CacheAccessable factory = CacheFactory.getInstance(SystemProperties.class);
        CacheObject<Properties> masterProperties = factory.createObject("masterProperties");
        masterProperties.set(config[1]);
        for (Object name : config[2].keySet()) {
            if (this.validatePath(name.toString(), config[2])) continue;
            String msg = "\u96c6\u7fa4\u68c0\u67e5\uff1a\u914d\u7f6e\u7684\u76ee\u5f55\u4e0d\u4e00\u81f4\uff1a" + name;
            console.error((Object)msg);
            LOG.error((Object)msg);
        }
        return true;
    }

    public Properties[] collect() {
        this.refreshConfig();
        Properties[] result = new Properties[3];
        result[0] = new Properties();
        Properties config = new Properties();
        for (String name : parameters) {
            String param = this.collectParameter(name);
            if (param == null) continue;
            config.put(name, param);
        }
        result[1] = config;
        config = new Properties();
        for (String name : paths) {
            String path = this.collectPath(name);
            if (path == null) continue;
            config.put(name, path);
        }
        result[2] = config;
        return result;
    }

    private void refreshConfig() {
        if (parameters != null) {
            return;
        }
        Set<String>[] prop = PropertiesReader.readProperties();
        parameters = prop[0];
        paths = prop[1];
    }

    public boolean validateParameter(String name, Properties config) {
        String localValue = SystemProperties.getInstance().getProperty(name);
        if (localValue != null) {
            return localValue.equals(config.get(name));
        }
        return false;
    }

    public String collectParameter(String name) {
        return SystemProperties.getInstance().getProperty(name);
    }

    public String collectPath(String name) {
        long id = UUID.randomUUID().getMostSignificantBits();
        String path = this.getLocalPath(name, String.valueOf(id));
        try {
            LOG.debug((Object)("Path:" + name + ":" + id + ":" + path));
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
                file.createNewFile();
                LOG.debug((Object)("create new file:" + path));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("\u6536\u96c6\u76ee\u5f55\u914d\u7f6e\u4fe1\u606f\uff0c\u751f\u6210\u6807\u8bc6\u6587\u4ef6\u51fa\u9519\u3002" + path), (Throwable)e);
        }
        return String.valueOf(id);
    }

    public boolean validatePath(String name, Properties config) {
        LOG.debug((Object)("validate path:" + name));
        String localPath = this.getLocalPath(name, config.getProperty(name));
        LOG.debug((Object)("check file:" + localPath));
        File file = new File(localPath);
        boolean exists = file.exists();
        if (exists) {
            file.delete();
        }
        return exists;
    }

    private String getLocalPath(String name, String id) {
        String path = SystemProperties.getInstance().getProperty(name);
        path = path + "/cluster/" + id;
        return path;
    }
}

