/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp.rule;

import com.seeyon.cdp.rule.Context;
import com.seeyon.cdp.rule.Execution;
import com.seeyon.cdp.rule.Rule;
import com.seeyon.cdp.rule.RuleExecuteThread;
import com.seeyon.cdp.rule.Scenario;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.thread.ThreadManager;
import com.seeyon.ctp.thread.ThreadPort;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ScenarioImpl
implements Scenario {
    private static final Log LOG = LogFactory.getLog(ScenarioImpl.class);
    protected final Rule rule;
    protected final String name;
    private List<Execution> executions = new CopyOnWriteArrayList<Execution>();

    public String toString() {
        return "ScenarioImpl [rule=" + this.rule + ", name=" + this.name + ", executions=" + this.executions + "]";
    }

    public ScenarioImpl(String name, Rule rule) {
        this.name = name;
        this.rule = rule;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start(Context ctx) throws BusinessException {
        ThreadPort port = ThreadManager.getInstance().getPort("Rule Execute");
        try {
            RuleExecuteThread thread = new RuleExecuteThread(this.rule, ctx, this.executions);
            thread.setName("Rule-" + port.getId());
            thread.start();
        }
        catch (Throwable e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void bind(Execution execution) {
        this.executions.add(execution);
    }
}

