/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp;

import com.seeyon.cdp.CDPRestClient;
import com.seeyon.cdp.DataSender;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public abstract class AbstractConnector {
    protected static final String FIELD_DATA = "data";
    protected static final String FIELD_OPERATOR = "operator";
    protected static final String FIELD_TYPE = "type";
    protected static final String FIELD_CREATE_DATE = "createDate";
    protected static final Log LOG = CtpLogFactory.getLog(AbstractConnector.class);
    protected boolean isEnabled = false;
    private static Map<Integer, DataSender> dataSenderRegistry = new HashMap<Integer, DataSender>();
    private DataSender defaultDataSender = new DataSender(){
        private CDPRestClient client = new CDPRestClient();

        @Override
        public void send(HashMap<String, ? extends Serializable> data) throws BusinessException {
            if (AbstractConnector.this.isEnabled) {
                StringBuilder path = new StringBuilder("data/actionlog");
                path.append("?type=").append(data.get(AbstractConnector.FIELD_TYPE));
                path.append("&createDate=").append(data.get(AbstractConnector.FIELD_CREATE_DATE));
                path.append("&operator=").append(data.get(AbstractConnector.FIELD_OPERATOR));
                Map result = this.client.post(path.toString(), data.get(AbstractConnector.FIELD_DATA), Map.class);
                if (!Boolean.TRUE.equals(result.get("success"))) {
                    LOG.error((Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\uff1a" + data + "  " + result));
                }
                LOG.debug((Object)("\u6570\u636e\u53d1\u9001\u6210\u529f\uff1a" + data));
            } else {
                LOG.debug((Object)"CDP\u672a\u542f\u7528\uff0c\u5ffd\u7565\u6570\u636e\u53d1\u9001\u3002");
            }
        }
    };

    public void registerSender(int type, DataSender sender) {
        dataSenderRegistry.put(type, sender);
    }

    public DataSender getDataSender(int type) {
        DataSender dataSender = dataSenderRegistry.get(type);
        if (dataSender != null) {
            return dataSender;
        }
        return this.getDefaultDataSender();
    }

    protected DataSender getDefaultDataSender() {
        return this.defaultDataSender;
    }
}

