/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.loadbalancer.AbstractServerListFilter;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAffinityPredicate;
import com.netflix.loadbalancer.ZoneSnapshot;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneAffinityServerListFilter<T extends Server>
extends AbstractServerListFilter<T>
implements IClientConfigAware {
    private volatile boolean zoneAffinity = DefaultClientConfigImpl.DEFAULT_ENABLE_ZONE_AFFINITY;
    private volatile boolean zoneExclusive = DefaultClientConfigImpl.DEFAULT_ENABLE_ZONE_EXCLUSIVITY;
    private DynamicDoubleProperty activeReqeustsPerServerThreshold;
    private DynamicDoubleProperty blackOutServerPercentageThreshold;
    private DynamicIntProperty availableServersThreshold;
    private Counter overrideCounter;
    private ZoneAffinityPredicate zoneAffinityPredicate = new ZoneAffinityPredicate();
    private static Logger logger = LoggerFactory.getLogger(ZoneAffinityServerListFilter.class);
    String zone;

    public ZoneAffinityServerListFilter() {
    }

    public ZoneAffinityServerListFilter(IClientConfig niwsClientConfig) {
        this.initWithNiwsConfig(niwsClientConfig);
    }

    public void initWithNiwsConfig(IClientConfig niwsClientConfig) {
        String sZoneExclusive;
        String sZoneAffinity = "" + niwsClientConfig.getProperty(CommonClientConfigKey.EnableZoneAffinity, (Object)false);
        if (sZoneAffinity != null) {
            this.zoneAffinity = Boolean.parseBoolean(sZoneAffinity);
            logger.debug("ZoneAffinity is set to {}", (Object)this.zoneAffinity);
        }
        if ((sZoneExclusive = "" + niwsClientConfig.getProperty(CommonClientConfigKey.EnableZoneExclusivity, (Object)false)) != null) {
            this.zoneExclusive = Boolean.parseBoolean(sZoneExclusive);
        }
        if (ConfigurationManager.getDeploymentContext() != null) {
            this.zone = ConfigurationManager.getDeploymentContext().getValue(DeploymentContext.ContextKey.zone);
        }
        this.activeReqeustsPerServerThreshold = DynamicPropertyFactory.getInstance().getDoubleProperty(niwsClientConfig.getClientName() + "." + niwsClientConfig.getNameSpace() + ".zoneAffinity.maxLoadPerServer", 0.6);
        logger.debug("activeReqeustsPerServerThreshold: {}", (Object)this.activeReqeustsPerServerThreshold.get());
        this.blackOutServerPercentageThreshold = DynamicPropertyFactory.getInstance().getDoubleProperty(niwsClientConfig.getClientName() + "." + niwsClientConfig.getNameSpace() + ".zoneAffinity.maxBlackOutServesrPercentage", 0.8);
        logger.debug("blackOutServerPercentageThreshold: {}", (Object)this.blackOutServerPercentageThreshold.get());
        this.availableServersThreshold = DynamicPropertyFactory.getInstance().getIntProperty(niwsClientConfig.getClientName() + "." + niwsClientConfig.getNameSpace() + ".zoneAffinity.minAvailableServers", 2);
        logger.debug("availableServersThreshold: {}", (Object)this.availableServersThreshold.get());
        this.overrideCounter = Monitors.newCounter((String)"ZoneAffinity_OverrideCounter");
        Monitors.registerObject((Object)("NIWSServerListFilter_" + niwsClientConfig.getClientName()));
    }

    private boolean shouldEnableZoneAffinity(List<T> filtered) {
        if (!this.zoneAffinity && !this.zoneExclusive) {
            return false;
        }
        if (this.zoneExclusive) {
            return true;
        }
        LoadBalancerStats stats = this.getLoadBalancerStats();
        if (stats == null) {
            return this.zoneAffinity;
        }
        logger.debug("Determining if zone affinity should be enabled with given server list: {}", filtered);
        ZoneSnapshot snapshot = stats.getZoneSnapshot(filtered);
        double loadPerServer = snapshot.getLoadPerServer();
        int instanceCount = snapshot.getInstanceCount();
        int circuitBreakerTrippedCount = snapshot.getCircuitTrippedCount();
        if ((double)circuitBreakerTrippedCount / (double)instanceCount >= this.blackOutServerPercentageThreshold.get() || loadPerServer >= this.activeReqeustsPerServerThreshold.get() || instanceCount - circuitBreakerTrippedCount < this.availableServersThreshold.get()) {
            logger.debug("zoneAffinity is overriden. blackOutServerPercentage: {}, activeReqeustsPerServer: {}, availableServers: {}", new Object[]{(double)circuitBreakerTrippedCount / (double)instanceCount, loadPerServer, instanceCount - circuitBreakerTrippedCount});
            return false;
        }
        return true;
    }

    @Override
    public List<T> getFilteredListOfServers(List<T> servers) {
        if (this.zone != null && (this.zoneAffinity || this.zoneExclusive) && servers != null && servers.size() > 0) {
            ArrayList filteredServers = Lists.newArrayList((Iterable)Iterables.filter(servers, this.zoneAffinityPredicate.getServerOnlyPredicate()));
            if (this.shouldEnableZoneAffinity(filteredServers)) {
                return filteredServers;
            }
            if (this.zoneAffinity) {
                this.overrideCounter.increment();
            }
        }
        return servers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ZoneAffinityServerListFilter:");
        sb.append(", zone: ").append(this.zone).append(", zoneAffinity:").append(this.zoneAffinity);
        sb.append(", zoneExclusivity:").append(this.zoneExclusive);
        return sb.toString();
    }
}

