/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.FloatToLongFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatLongPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.FloatLongProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.FloatLongMap;
import com.gs.collections.api.map.primitive.ImmutableFloatLongMap;
import com.gs.collections.api.map.primitive.MutableFloatLongMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.FloatLongPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedLongCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.FloatLongMaps;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedFloatLongMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableFloatLongMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatLongHashMap
implements MutableFloatLongMap,
Externalizable {
    static final long EMPTY_VALUE = 0L;
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private float[] keys;
    private long[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public FloatLongHashMap() {
        this.allocateTable(16);
    }

    public FloatLongHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public FloatLongHashMap(FloatLongMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static FloatLongHashMap newWithKeysValues(float key1, long value1) {
        return new FloatLongHashMap(1).withKeyValue(key1, value1);
    }

    public static FloatLongHashMap newWithKeysValues(float key1, long value1, float key2, long value2) {
        return new FloatLongHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static FloatLongHashMap newWithKeysValues(float key1, long value1, float key2, long value2, float key3, long value3) {
        return new FloatLongHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static FloatLongHashMap newWithKeysValues(float key1, long value1, float key2, long value2, float key3, long value3, float key4, long value4) {
        return new FloatLongHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatLongMap)) {
            return false;
        }
        FloatLongMap other = (FloatLongMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0f) || other.containsKey(1.0f)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0f) || this.sentinelValues.zeroValue != other.getOrThrow(0.0f))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0f) || this.sentinelValues.oneValue != other.getOrThrow(1.0f))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatLongHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += Float.floatToIntBits(0.0f) ^ (int)(this.sentinelValues.zeroValue ^ this.sentinelValues.zeroValue >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += Float.floatToIntBits(1.0f) ^ (int)(this.sentinelValues.oneValue ^ this.sentinelValues.oneValue >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += Float.floatToIntBits(this.keys[i]) ^ (int)(this.values[i] ^ this.values[i] >>> 32);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0.0f)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1.0f)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatLongHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                float key = this.keys[i];
                if (!FloatLongHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    public long[] toArray() {
        long[] array = new long[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(long value) {
        return this.containsValue(value);
    }

    public boolean containsAll(long ... source) {
        for (long each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        return source.allSatisfy(new LongPredicate(){

            public boolean accept(long value) {
                return FloatLongHashMap.this.contains(value);
            }
        });
    }

    public void forEach(LongProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableLongCollection select(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableLongCollection reject(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public long detectIfNone(LongPredicate predicate, long value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(LongPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0f);
        Arrays.fill(this.values, 0L);
    }

    public void put(float key, long value) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(FloatLongMap map) {
        map.forEachKeyValue(new FloatLongProcedure(){

            public void value(float key, long value) {
                FloatLongHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(float key) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(float key) {
        this.removeKey(key);
    }

    public long removeKeyIfAbsent(float key, long value) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            long oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            long oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            long oldValue = this.values[index];
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public long getIfAbsentPut(float key, long value) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public long getIfAbsentPut(float key, LongFunction0 function) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        long value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> long getIfAbsentPutWith(float key, LongFunction<? super P> function, P parameter) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value = function.longValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value = function.longValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        long value = function.longValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public long getIfAbsentPutWithKey(float key, FloatToLongFunction function) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        long value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public long addToValue(float key, long toBeAdded) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(float key, long value, int index) {
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(long value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = 0L;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(long value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = 0L;
        } else {
            this.sentinelValues = null;
        }
    }

    public long updateValue(float key, long initialValueIfAbsent, LongToLongFunction function) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        long value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public FloatLongHashMap withKeyValue(float key1, long value1) {
        this.put(key1, value1);
        return this;
    }

    public FloatLongHashMap withKeysValues(float key1, long value1, float key2, long value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public FloatLongHashMap withKeysValues(float key1, long value1, float key2, long value2, float key3, long value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public FloatLongHashMap withKeysValues(float key1, long value1, float key2, long value2, float key3, long value3, float key4, long value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public FloatLongHashMap withoutKey(float key) {
        this.removeKey(key);
        return this;
    }

    public FloatLongHashMap withoutAllKeys(FloatIterable keys) {
        keys.forEach(new FloatProcedure(){

            public void value(float key) {
                FloatLongHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableFloatLongMap asUnmodifiable() {
        return new UnmodifiableFloatLongMap(this);
    }

    public MutableFloatLongMap asSynchronized() {
        return new SynchronizedFloatLongMap(this);
    }

    public ImmutableFloatLongMap toImmutable() {
        return FloatLongMaps.immutable.ofAll((FloatLongMap)this);
    }

    public long get(float key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(float key, long ifAbsent) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public long getOrThrow(float key) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatLongHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        if (FloatLongHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (FloatLongHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(long value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f);
            }
        }
        for (float key : this.keys) {
            if (!FloatLongHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(FloatLongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyFloatIterable keysView() {
        return new KeysView();
    }

    public RichIterable<FloatLongPair> keyValuesView() {
        return new KeyValuesView();
    }

    public FloatLongHashMap select(FloatLongPredicate predicate) {
        FloatLongHashMap result = new FloatLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public FloatLongHashMap reject(FloatLongPredicate predicate) {
        FloatLongHashMap result = new FloatLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long max = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long min = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeFloat(0.0f);
                out.writeLong(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeFloat(1.0f);
                out.writeLong(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatLongHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeFloat(this.keys[i]);
            out.writeLong(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readFloat(), in.readLong());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        float[] old = this.keys;
        long[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatLongHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(float element) {
        int index = this.spread(element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Float.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Float.compare(this.keys[nextIndex], 1.0f) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Float.compare(this.keys[nextIndex], 0.0f) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(float element) {
        int code = Float.floatToIntBits(element);
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new float[sizeToAllocate];
        this.values = new long[sizeToAllocate];
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !FloatLongHashMap.isEmptyKey(key) && !FloatLongHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableFloatSet keySet() {
        return new KeySet();
    }

    public MutableLongCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ float[] access$802(FloatLongHashMap x0, float[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ long[] access$1002(FloatLongHashMap x0, long[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<FloatLongPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super FloatLongPair> procedure) {
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0f, FloatLongHashMap.this.sentinelValues.zeroValue));
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0f, FloatLongHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(FloatLongHashMap.this.keys[i], FloatLongHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super FloatLongPair> objectIntProcedure) {
            int index = 0;
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0.0f, FloatLongHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1.0f, FloatLongHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(FloatLongHashMap.this.keys[i], FloatLongHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super FloatLongPair, ? super P> procedure, P parameter) {
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0f, FloatLongHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0f, FloatLongHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(FloatLongHashMap.this.keys[i], FloatLongHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<FloatLongPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<FloatLongPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public FloatLongPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (FloatLongHashMap.this.containsKey(0.0f)) {
                        return PrimitiveTuples.pair(0.0f, FloatLongHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (FloatLongHashMap.this.containsKey(1.0f)) {
                        return PrimitiveTuples.pair(1.0f, FloatLongHashMap.this.sentinelValues.oneValue);
                    }
                }
                float[] keys = FloatLongHashMap.this.keys;
                while (!FloatLongHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                FloatLongPair result = PrimitiveTuples.pair(keys[this.position], FloatLongHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != FloatLongHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableLongCollection {
        private ValuesCollection() {
        }

        public void clear() {
            FloatLongHashMap.this.clear();
        }

        public MutableLongCollection select(LongPredicate predicate) {
            return FloatLongHashMap.this.select(predicate);
        }

        public MutableLongCollection reject(LongPredicate predicate) {
            return FloatLongHashMap.this.reject(predicate);
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            return FloatLongHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
            return FloatLongHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            return FloatLongHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return FloatLongHashMap.this.sum();
        }

        public long max() {
            return FloatLongHashMap.this.max();
        }

        public long maxIfEmpty(long defaultValue) {
            return FloatLongHashMap.this.maxIfEmpty(defaultValue);
        }

        public long min() {
            return FloatLongHashMap.this.min();
        }

        public long minIfEmpty(long defaultValue) {
            return FloatLongHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return FloatLongHashMap.this.average();
        }

        public double median() {
            return FloatLongHashMap.this.median();
        }

        public long[] toSortedArray() {
            return FloatLongHashMap.this.toSortedArray();
        }

        public MutableLongList toSortedList() {
            return FloatLongHashMap.this.toSortedList();
        }

        public MutableLongCollection with(long element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection without(long element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection withAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection asUnmodifiable() {
            return UnmodifiableLongCollection.of(this);
        }

        public MutableLongCollection asSynchronized() {
            return SynchronizedLongCollection.of(this);
        }

        public ImmutableLongCollection toImmutable() {
            return LongLists.immutable.withAll((LongIterable)this);
        }

        public boolean contains(long value) {
            return FloatLongHashMap.this.containsValue(value);
        }

        public boolean containsAll(long ... source) {
            return FloatLongHashMap.this.containsAll(source);
        }

        public boolean containsAll(LongIterable source) {
            return FloatLongHashMap.this.containsAll(source);
        }

        public MutableLongList toList() {
            return FloatLongHashMap.this.toList();
        }

        public MutableLongSet toSet() {
            return FloatLongHashMap.this.toSet();
        }

        public MutableLongBag toBag() {
            return FloatLongHashMap.this.toBag();
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public boolean isEmpty() {
            return FloatLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatLongHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatLongHashMap.this.sentinelValues != null) {
                    if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(FloatLongHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(FloatLongHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                    float key = FloatLongHashMap.this.keys[i];
                    if (!FloatLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(FloatLongHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public LongIterator longIterator() {
            return FloatLongHashMap.this.longIterator();
        }

        public void forEach(LongProcedure procedure) {
            FloatLongHashMap.this.forEach(procedure);
        }

        public int count(LongPredicate predicate) {
            return FloatLongHashMap.this.count(predicate);
        }

        public boolean anySatisfy(LongPredicate predicate) {
            return FloatLongHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(LongPredicate predicate) {
            return FloatLongHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            return FloatLongHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(long item) {
            int oldSize = FloatLongHashMap.this.size();
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && item == FloatLongHashMap.this.sentinelValues.zeroValue) {
                    FloatLongHashMap.this.removeKey(0.0f);
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && item == FloatLongHashMap.this.sentinelValues.oneValue) {
                    FloatLongHashMap.this.removeKey(1.0f);
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i]) || item != FloatLongHashMap.this.values[i]) continue;
                FloatLongHashMap.this.removeKey(FloatLongHashMap.this.keys[i]);
            }
            return oldSize != FloatLongHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = FloatLongHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != FloatLongHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = FloatLongHashMap.this.size();
            for (long item : source) {
                this.remove(item);
            }
            return oldSize != FloatLongHashMap.this.size();
        }

        public boolean retainAll(LongIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            FloatLongHashMap retained = FloatLongHashMap.this.select(new FloatLongPredicate((LongSet)sourceSet){
                final /* synthetic */ LongSet val$sourceSet;
                {
                    this.val$sourceSet = longSet;
                }

                public boolean accept(float key, long value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                FloatLongHashMap.access$802(FloatLongHashMap.this, retained.keys);
                FloatLongHashMap.access$1002(FloatLongHashMap.this, retained.values);
                FloatLongHashMap.this.sentinelValues = retained.sentinelValues;
                FloatLongHashMap.this.occupiedWithData = retained.occupiedWithData;
                FloatLongHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(long ... source) {
            return this.retainAll((LongIterable)LongHashSet.newSetWith(source));
        }

        public int size() {
            return FloatLongHashMap.this.size();
        }

        public long[] toArray() {
            return FloatLongHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableFloatSet {
        private KeySet() {
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatLongHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(float key) {
            int oldSize = FloatLongHashMap.this.size();
            FloatLongHashMap.this.removeKey(key);
            return oldSize != FloatLongHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = FloatLongHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                FloatLongHashMap.this.removeKey(iterator.next());
            }
            return oldSize != FloatLongHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = FloatLongHashMap.this.size();
            for (float item : source) {
                FloatLongHashMap.this.removeKey(item);
            }
            return oldSize != FloatLongHashMap.this.size();
        }

        public boolean retainAll(FloatIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
            FloatLongHashMap retained = FloatLongHashMap.this.select(new FloatLongPredicate((FloatSet)sourceSet){
                final /* synthetic */ FloatSet val$sourceSet;
                {
                    this.val$sourceSet = floatSet;
                }

                public boolean accept(float key, long value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                FloatLongHashMap.access$802(FloatLongHashMap.this, retained.keys);
                FloatLongHashMap.access$1002(FloatLongHashMap.this, retained.values);
                FloatLongHashMap.this.sentinelValues = retained.sentinelValues;
                FloatLongHashMap.this.occupiedWithData = retained.occupiedWithData;
                FloatLongHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(float ... source) {
            return this.retainAll((FloatIterable)FloatHashSet.newSetWith(source));
        }

        public void clear() {
            FloatLongHashMap.this.clear();
        }

        public MutableFloatSet select(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet reject(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet with(float element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableFloatSet without(float element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableFloatSet withAll(FloatIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableFloatSet withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0f));
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0f));
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableFloatSet asUnmodifiable() {
            return UnmodifiableFloatSet.of(this);
        }

        public MutableFloatSet asSynchronized() {
            return SynchronizedFloatSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (float key : FloatLongHashMap.this.keys) {
                if (!FloatLongHashMap.isNonSentinel(key)) continue;
                sum += (double)key;
            }
            return sum;
        }

        public float max() {
            if (FloatLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float max = 0.0f;
            boolean isMaxSet = false;
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0f;
                    isMaxSet = true;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Float.compare(max, 1.0f) < 0)) {
                    max = 1.0f;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i]) || isMaxSet && Float.compare(max, FloatLongHashMap.this.keys[i]) >= 0) continue;
                max = FloatLongHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public float maxIfEmpty(float defaultValue) {
            if (FloatLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public float min() {
            if (FloatLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float min = 0.0f;
            boolean isMinSet = false;
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0f;
                    isMinSet = true;
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Float.compare(1.0f, min) < 0)) {
                    min = 1.0f;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i]) || isMinSet && Float.compare(FloatLongHashMap.this.keys[i], min) >= 0) continue;
                min = FloatLongHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (FloatLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public float[] toArray() {
            int size = FloatLongHashMap.this.size();
            final float[] result = new float[size];
            FloatLongHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(float value) {
            return FloatLongHashMap.this.containsKey(value);
        }

        public boolean containsAll(float ... source) {
            for (float item : source) {
                if (FloatLongHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                if (FloatLongHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0f);
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0f);
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i])) continue;
                result = function.valueOf(result, FloatLongHashMap.this.keys[i]);
            }
            return result;
        }

        public FloatSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableFloatSet toImmutable() {
            return FloatSets.immutable.withAll((FloatIterable)this);
        }

        public int size() {
            return FloatLongHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatLongHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatSet)) {
                return false;
            }
            FloatSet other = (FloatSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (FloatLongHashMap.this.sentinelValues != null) {
                if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                    result += Float.floatToIntBits(0.0f);
                }
                if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                    result += Float.floatToIntBits(1.0f);
                }
            }
            for (int i = 0; i < FloatLongHashMap.this.keys.length; ++i) {
                if (!FloatLongHashMap.isNonSentinel(FloatLongHashMap.this.keys[i])) continue;
                result += Float.floatToIntBits(FloatLongHashMap.this.keys[i]);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatLongHashMap.this.sentinelValues != null) {
                    if (FloatLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatLongHashMap.this.keys) {
                    if (!FloatLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatLongHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatLongHashMap.this.containsKey(0.0f)) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatLongHashMap.this.containsKey(1.0f)) {
                    return 1.0f;
                }
            }
            float[] keys = FloatLongHashMap.this.keys;
            while (!FloatLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyFloatIterable {
        private KeysView() {
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatLongHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalLongIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatLongHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatLongHashMap.this.containsKey(0.0f)) {
                    return FloatLongHashMap.this.get(0.0f);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatLongHashMap.this.containsKey(1.0f)) {
                    return FloatLongHashMap.this.get(1.0f);
                }
            }
            float[] keys = FloatLongHashMap.this.keys;
            while (!FloatLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = FloatLongHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private long zeroValue;
        private long oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(long value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

