/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleToBooleanFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleBooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.DoubleBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleBooleanMap;
import com.gs.collections.api.map.primitive.MutableDoubleBooleanMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.DoubleBooleanPair;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.block.factory.primitive.DoublePredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedBooleanCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.DoubleBooleanMaps;
import com.gs.collections.impl.factory.primitive.DoubleSets;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.CollectDoubleToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectDoubleIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedDoubleBooleanMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableDoubleBooleanMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleBooleanHashMap
implements MutableDoubleBooleanMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int occupied;
    private int maxSize;
    private double[] keys;
    private BitSet values;
    private float loadFactor = 0.5f;
    private SentinelValues sentinelValues;

    public DoubleBooleanHashMap() {
        this.allocate(16);
    }

    public DoubleBooleanHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public DoubleBooleanHashMap(DoubleBooleanMap map) {
        this(Math.max(map.size(), 8), 0.5f);
        this.putAll(map);
    }

    public DoubleBooleanHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.loadFactor = loadFactor;
        this.init(this.fastCeil((float)initialCapacity / loadFactor));
    }

    public MutableDoubleBooleanMap asUnmodifiable() {
        return new UnmodifiableDoubleBooleanMap(this);
    }

    public MutableDoubleBooleanMap asSynchronized() {
        return new SynchronizedDoubleBooleanMap(this);
    }

    public ImmutableDoubleBooleanMap toImmutable() {
        return DoubleBooleanMaps.immutable.withAll((DoubleBooleanMap)this);
    }

    public static DoubleBooleanHashMap newWithKeysValues(double key1, boolean value1) {
        return new DoubleBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleBooleanHashMap newWithKeysValues(double key1, boolean value1, double key2, boolean value2) {
        return new DoubleBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleBooleanHashMap newWithKeysValues(double key1, boolean value1, double key2, boolean value2, double key3, boolean value3) {
        return new DoubleBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleBooleanHashMap newWithKeysValues(double key1, boolean value1, double key2, boolean value2, double key3, boolean value3, double key4, boolean value4) {
        return new DoubleBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public DoubleBooleanHashMap withKeyValue(double key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleBooleanHashMap withKeysValues(double key1, boolean value1, double key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleBooleanHashMap withKeysValues(double key1, boolean value1, double key2, boolean value2, double key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleBooleanHashMap withKeysValues(double key1, boolean value1, double key2, boolean value2, double key3, boolean value3, double key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public DoubleBooleanHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    public DoubleBooleanHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(new DoubleProcedure(){

            public void value(double key) {
                DoubleBooleanHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    private int init(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        return this.allocate(capacity);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleBooleanHashMap.isEmptyKey(key) && !DoubleBooleanHashMap.isRemovedKey(key);
    }

    private int allocate(int capacity) {
        this.allocateTable(capacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    private void computeMaxSize(int capacity) {
        this.maxSize = Math.min(capacity - 1, (int)((float)capacity * this.loadFactor));
    }

    public int size() {
        return this.occupied + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupied == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupied != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    private void rehash() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocate(newCapacity);
        this.occupied = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(double element) {
        int index = this.spread(element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Double.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Double.compare(this.keys[nextIndex], 1.0) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Double.compare(this.keys[nextIndex], 0.0) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(double element) {
        long code = Double.doubleToLongBits(element);
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupied = 0;
        Arrays.fill(this.keys, 0.0);
        this.values.clear();
    }

    public void put(double key, boolean value) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values.set(index, value);
            return;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupied;
        if (this.occupied > this.maxSize) {
            this.rehash();
        }
    }

    public void putAll(DoubleBooleanMap map) {
        map.forEachKeyValue(new DoubleBooleanProcedure(){

            public void value(double key, boolean value) {
                DoubleBooleanHashMap.this.put(key, value);
            }
        });
    }

    public boolean containsKey(double key) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(boolean value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || this.values.get(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean contains(boolean value) {
        return this.containsValue(value);
    }

    public boolean containsAll(boolean ... source) {
        for (boolean each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.allSatisfy(new BooleanPredicate(){

            public boolean accept(boolean value) {
                return DoubleBooleanHashMap.this.contains(value);
            }
        });
    }

    public boolean get(double key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getIfAbsent(double key, boolean ifAbsent) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(double key) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(double key, boolean value) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        this.values.set(index, value);
        return value;
    }

    public boolean getIfAbsentPut(double key, BooleanFunction0 function) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.value();
        this.values.set(index, value);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(double key, BooleanFunction<? super P> function, P parameter) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.booleanValueOf(parameter);
        this.values.set(index, value);
        return value;
    }

    public boolean getIfAbsentPutWithKey(double key, DoubleToBooleanFunction function) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.valueOf(key);
        this.values.set(index, value);
        return value;
    }

    public boolean updateValue(double key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values.set(index, function.valueOf(this.values.get(index)));
        } else {
            this.keys[index] = key;
            ++this.occupied;
            this.values.set(index, function.valueOf(initialValueIfAbsent));
        }
        return this.values.get(index);
    }

    public void removeKey(double key) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            --this.occupied;
            this.values.set(index, false);
        }
    }

    public void remove(double key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(double key, boolean value) {
        if (DoubleBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (DoubleBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            --this.occupied;
            boolean oldValue = this.values.get(index);
            this.values.set(index, false);
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleBooleanMap)) {
            return false;
        }
        DoubleBooleanMap other = (DoubleBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || this.sentinelValues.zeroValue != other.getOrThrow(0.0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || this.sentinelValues.oneValue != other.getOrThrow(1.0))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleBooleanHashMap.isNonSentinel(key) || other.containsKey(key) && this.values.get(i) == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ (this.sentinelValues.zeroValue ? 1231 : 1237);
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ (this.sentinelValues.oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ (this.values.get(i) ? 1231 : 1237);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0.0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1.0)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values.get(i)));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public BooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(BooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values.get(i));
        }
    }

    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (double key : this.keys) {
            if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(DoubleBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values.get(i));
        }
    }

    public DoubleBooleanHashMap select(DoubleBooleanPredicate predicate) {
        DoubleBooleanHashMap result = new DoubleBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public DoubleBooleanHashMap reject(DoubleBooleanPredicate predicate) {
        DoubleBooleanHashMap result = new DoubleBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values.get(i));
        }
        return result;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                double key = this.keys[i];
                if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values.get(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return this.values.get(i);
        }
        return value;
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values.get(i)));
        }
        return target;
    }

    public int count(BooleanPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values.get(i);
            ++index;
        }
        return array;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    public RichIterable<DoubleBooleanPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(this.loadFactor);
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeBoolean(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeBoolean(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeBoolean(this.values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.loadFactor = in.readFloat();
        this.init(Math.max((int)((float)size / this.loadFactor) + 1, 8));
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readBoolean());
        }
    }

    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ double[] access$902(DoubleBooleanHashMap x0, double[] x1) {
        x0.keys = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<DoubleBooleanPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super DoubleBooleanPair> procedure) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, DoubleBooleanHashMap.this.sentinelValues.zeroValue));
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, DoubleBooleanHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleBooleanHashMap.this.keys[i], DoubleBooleanHashMap.this.values.get(i)));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super DoubleBooleanPair> objectIntProcedure) {
            int index = 0;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0.0, DoubleBooleanHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1.0, DoubleBooleanHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(DoubleBooleanHashMap.this.keys[i], DoubleBooleanHashMap.this.values.get(i)), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super DoubleBooleanPair, ? super P> procedure, P parameter) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, DoubleBooleanHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, DoubleBooleanHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleBooleanHashMap.this.keys[i], DoubleBooleanHashMap.this.values.get(i)), parameter);
            }
        }

        public Iterator<DoubleBooleanPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<DoubleBooleanPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public DoubleBooleanPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (DoubleBooleanHashMap.this.containsKey(0.0)) {
                        return PrimitiveTuples.pair(0.0, DoubleBooleanHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (DoubleBooleanHashMap.this.containsKey(1.0)) {
                        return PrimitiveTuples.pair(1.0, DoubleBooleanHashMap.this.sentinelValues.oneValue);
                    }
                }
                double[] keys = DoubleBooleanHashMap.this.keys;
                while (!DoubleBooleanHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                DoubleBooleanPair result = PrimitiveTuples.pair(keys[this.position], DoubleBooleanHashMap.this.values.get(this.position));
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != DoubleBooleanHashMap.this.size();
            }
        }
    }

    private class KeySetIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleBooleanHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleBooleanHashMap.this.containsKey(0.0)) {
                    return 0.0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleBooleanHashMap.this.containsKey(1.0)) {
                    return 1.0;
                }
            }
            double[] keys = DoubleBooleanHashMap.this.keys;
            while (!DoubleBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableBooleanCollection {
        private ValuesCollection() {
        }

        public void clear() {
            DoubleBooleanHashMap.this.clear();
        }

        public MutableBooleanCollection select(BooleanPredicate predicate) {
            return DoubleBooleanHashMap.this.select(predicate);
        }

        public MutableBooleanCollection reject(BooleanPredicate predicate) {
            return DoubleBooleanHashMap.this.reject(predicate);
        }

        public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
            return DoubleBooleanHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
            return DoubleBooleanHashMap.this.collect(function);
        }

        public MutableBooleanCollection with(boolean element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection without(boolean element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection withAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection withoutAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection asSynchronized() {
            return SynchronizedBooleanCollection.of(this);
        }

        public MutableBooleanCollection asUnmodifiable() {
            return UnmodifiableBooleanCollection.of(this);
        }

        public ImmutableBooleanCollection toImmutable() {
            return BooleanLists.immutable.withAll((BooleanIterable)this);
        }

        public boolean contains(boolean value) {
            return DoubleBooleanHashMap.this.containsValue(value);
        }

        public boolean containsAll(boolean ... source) {
            return DoubleBooleanHashMap.this.containsAll(source);
        }

        public boolean containsAll(BooleanIterable source) {
            return DoubleBooleanHashMap.this.containsAll(source);
        }

        public MutableBooleanList toList() {
            return DoubleBooleanHashMap.this.toList();
        }

        public MutableBooleanSet toSet() {
            return DoubleBooleanHashMap.this.toSet();
        }

        public MutableBooleanBag toBag() {
            return DoubleBooleanHashMap.this.toBag();
        }

        public LazyBooleanIterable asLazy() {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }

        public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
            return DoubleBooleanHashMap.this.injectInto(injectedValue, function);
        }

        public boolean isEmpty() {
            return DoubleBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleBooleanHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleBooleanHashMap.this.sentinelValues != null) {
                    if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(DoubleBooleanHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(DoubleBooleanHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                    double key = DoubleBooleanHashMap.this.keys[i];
                    if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(DoubleBooleanHashMap.this.values.get(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public BooleanIterator booleanIterator() {
            return DoubleBooleanHashMap.this.booleanIterator();
        }

        public void forEach(BooleanProcedure procedure) {
            DoubleBooleanHashMap.this.forEach(procedure);
        }

        public int count(BooleanPredicate predicate) {
            return DoubleBooleanHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BooleanPredicate predicate) {
            return DoubleBooleanHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BooleanPredicate predicate) {
            return DoubleBooleanHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BooleanPredicate predicate) {
            return DoubleBooleanHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(boolean element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(boolean ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(BooleanIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(boolean item) {
            int oldSize = DoubleBooleanHashMap.this.size();
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && item == DoubleBooleanHashMap.this.sentinelValues.zeroValue) {
                    DoubleBooleanHashMap.this.removeKey(0.0);
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && item == DoubleBooleanHashMap.this.sentinelValues.oneValue) {
                    DoubleBooleanHashMap.this.removeKey(1.0);
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i]) || item != DoubleBooleanHashMap.this.values.get(i)) continue;
                DoubleBooleanHashMap.this.removeKey(DoubleBooleanHashMap.this.keys[i]);
            }
            return oldSize != DoubleBooleanHashMap.this.size();
        }

        public boolean removeAll(BooleanIterable source) {
            int oldSize = DoubleBooleanHashMap.this.size();
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != DoubleBooleanHashMap.this.size();
        }

        public boolean removeAll(boolean ... source) {
            int oldSize = DoubleBooleanHashMap.this.size();
            for (boolean item : source) {
                this.remove(item);
            }
            return oldSize != DoubleBooleanHashMap.this.size();
        }

        public boolean retainAll(BooleanIterable source) {
            int oldSize = DoubleBooleanHashMap.this.size();
            Object sourceSet = source instanceof BooleanSet ? (BooleanSet)source : source.toSet();
            DoubleBooleanHashMap retained = DoubleBooleanHashMap.this.select(new DoubleBooleanPredicate((BooleanSet)sourceSet){
                final /* synthetic */ BooleanSet val$sourceSet;
                {
                    this.val$sourceSet = booleanSet;
                }

                public boolean accept(double key, boolean value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                DoubleBooleanHashMap.access$902(DoubleBooleanHashMap.this, retained.keys);
                DoubleBooleanHashMap.this.values = retained.values;
                DoubleBooleanHashMap.this.maxSize = retained.maxSize;
                DoubleBooleanHashMap.this.occupied = retained.occupied;
                DoubleBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(boolean ... source) {
            return this.retainAll((BooleanIterable)BooleanHashSet.newSetWith(source));
        }

        public int size() {
            return DoubleBooleanHashMap.this.size();
        }

        public boolean[] toArray() {
            return DoubleBooleanHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableDoubleSet {
        private KeySet() {
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleBooleanHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(double key) {
            int oldSize = DoubleBooleanHashMap.this.size();
            DoubleBooleanHashMap.this.removeKey(key);
            return oldSize != DoubleBooleanHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = DoubleBooleanHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                DoubleBooleanHashMap.this.removeKey(iterator.next());
            }
            return oldSize != DoubleBooleanHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = DoubleBooleanHashMap.this.size();
            for (double item : source) {
                DoubleBooleanHashMap.this.removeKey(item);
            }
            return oldSize != DoubleBooleanHashMap.this.size();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = DoubleBooleanHashMap.this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            DoubleBooleanHashMap retained = DoubleBooleanHashMap.this.select(new DoubleBooleanPredicate((DoubleSet)sourceSet){
                final /* synthetic */ DoubleSet val$sourceSet;
                {
                    this.val$sourceSet = doubleSet;
                }

                public boolean accept(double key, boolean value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                DoubleBooleanHashMap.access$902(DoubleBooleanHashMap.this, retained.keys);
                DoubleBooleanHashMap.this.values = retained.values;
                DoubleBooleanHashMap.this.maxSize = retained.maxSize;
                DoubleBooleanHashMap.this.occupied = retained.occupied;
                DoubleBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(double ... source) {
            return this.retainAll((DoubleIterable)DoubleHashSet.newSetWith(source));
        }

        public void clear() {
            DoubleBooleanHashMap.this.clear();
        }

        public MutableDoubleSet select(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet reject(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet with(double element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleSet without(double element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleSet withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleSet withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0));
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0));
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableDoubleSet asUnmodifiable() {
            return UnmodifiableDoubleSet.of(this);
        }

        public MutableDoubleSet asSynchronized() {
            return SynchronizedDoubleSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public double max() {
            if (DoubleBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double max = 0.0;
            boolean isMaxSet = false;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0;
                    isMaxSet = true;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Double.compare(max, 1.0) < 0)) {
                    max = 1.0;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i]) || isMaxSet && Double.compare(max, DoubleBooleanHashMap.this.keys[i]) >= 0) continue;
                max = DoubleBooleanHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public double maxIfEmpty(double defaultValue) {
            if (DoubleBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double min() {
            if (DoubleBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double min = 0.0;
            boolean isMinSet = false;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0;
                    isMinSet = true;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Double.compare(1.0, min) < 0)) {
                    min = 1.0;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i]) || isMinSet && Double.compare(DoubleBooleanHashMap.this.keys[i], min) >= 0) continue;
                min = DoubleBooleanHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (DoubleBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public double[] toArray() {
            int size = DoubleBooleanHashMap.this.size();
            final double[] result = new double[size];
            DoubleBooleanHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(double value) {
            return DoubleBooleanHashMap.this.containsKey(value);
        }

        public boolean containsAll(double ... source) {
            for (double item : source) {
                if (DoubleBooleanHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                if (DoubleBooleanHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0);
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0);
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, DoubleBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public DoubleSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableDoubleSet toImmutable() {
            return DoubleSets.immutable.withAll((DoubleIterable)this);
        }

        public int size() {
            return DoubleBooleanHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleBooleanHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DoubleSet)) {
                return false;
            }
            DoubleSet other = (DoubleSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i])) continue;
                result += (int)(Double.doubleToLongBits(DoubleBooleanHashMap.this.keys[i]) ^ Double.doubleToLongBits(DoubleBooleanHashMap.this.keys[i]) >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleBooleanHashMap.this.sentinelValues != null) {
                    if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleBooleanHashMap.this.keys) {
                    if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyDoubleIterable {
        private KeysView() {
        }

        public boolean isEmpty() {
            return DoubleBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleBooleanHashMap.this.notEmpty();
        }

        public int size() {
            return DoubleBooleanHashMap.this.size();
        }

        public boolean contains(double key) {
            return DoubleBooleanHashMap.this.containsKey(key);
        }

        public boolean containsAll(double ... keys) {
            for (double key : keys) {
                if (DoubleBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            return source.allSatisfy(new DoublePredicate(){

                public boolean accept(double key) {
                    return DoubleBooleanHashMap.this.containsKey(key);
                }
            });
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleBooleanHashMap.this.forEachKey(procedure);
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleBooleanHashMap.this.sentinelValues != null) {
                    if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleBooleanHashMap.this.keys) {
                    if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        public LazyDoubleIterable select(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, predicate);
        }

        public LazyDoubleIterable reject(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, DoublePredicates.not(predicate));
        }

        public double detectIfNone(DoublePredicate predicate, double value) {
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(DoubleToObjectFunction<? extends V> function) {
            return new CollectDoubleToObjectIterable<V>((DoubleIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (double key : DoubleBooleanHashMap.this.keys) {
                if (!DoubleBooleanHashMap.isNonSentinel(key)) continue;
                result += key;
            }
            return result;
        }

        public double max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double max = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public double min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double min = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double maxIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public double[] toArray() {
            int size = DoubleBooleanHashMap.this.size();
            final double[] result = new double[size];
            DoubleBooleanHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (DoubleBooleanHashMap.this.sentinelValues != null) {
                if (DoubleBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0);
                }
                if (DoubleBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0);
                }
            }
            for (int i = 0; i < DoubleBooleanHashMap.this.keys.length; ++i) {
                if (!DoubleBooleanHashMap.isNonSentinel(DoubleBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, DoubleBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return this;
        }
    }

    private class InternalBooleanIterator
    implements BooleanIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleBooleanHashMap.this.containsKey(0.0)) {
                    return DoubleBooleanHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleBooleanHashMap.this.containsKey(1.0)) {
                    return DoubleBooleanHashMap.this.sentinelValues.oneValue;
                }
            }
            double[] keys = DoubleBooleanHashMap.this.keys;
            while (!DoubleBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            boolean result = DoubleBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private boolean zeroValue;
        private boolean oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(boolean value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

