/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SynchronizedMapIterable<K, V>
implements MapIterable<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Object lock;
    private final MapIterable<K, V> mapIterable;

    protected SynchronizedMapIterable(MapIterable<K, V> newMap) {
        this(newMap, null);
    }

    protected SynchronizedMapIterable(MapIterable<K, V> newMap, Object newLock) {
        if (newMap == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedMapIterable on a null map");
        }
        this.mapIterable = newMap;
        this.lock = newLock == null ? this : newLock;
    }

    protected MapIterable<K, V> getMap() {
        return this.mapIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKey(Procedure<? super K> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure2) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.forEachKeyValue(procedure2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsent(K key, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.getIfAbsent(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentValue(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.getIfAbsentValue(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V getIfAbsentWith(K key, Function<? super P, ? extends V> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.getIfAbsentWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A ifPresentApply(K key, Function<? super V, ? extends A> function) {
        Object object = this.lock;
        synchronized (object) {
            return (A)this.mapIterable.ifPresentApply(key, function);
        }
    }

    public abstract RichIterable<K> keysView();

    public abstract RichIterable<V> valuesView();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.detect(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getLast() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.mapIterable.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllIterable(Iterable<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.containsAllIterable(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllArguments(Object ... elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.containsAllArguments(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.select(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> RichIterable<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.selectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.reject(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> RichIterable<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.rejectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V detect(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.detect(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.detectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.detectIfNone(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.detectWithIfNone(predicate, parameter, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.countWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.anySatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.allSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.noneSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        Object object = this.lock;
        synchronized (object) {
            return (IV)this.mapIterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfInt(IntFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.sumOfInt(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfFloat(FloatFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.sumOfFloat(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfLong(LongFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.sumOfLong(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfDouble(DoubleFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.sumOfDouble(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedList(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<V> toSortedSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedSet(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<V> toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedMap(comparator, keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIterable<V> asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toArray((Object[])a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V min(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.min(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V max(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.max(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V min() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V max() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.zip(that, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.zipWithIndex(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<RichIterable<V>> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.chunk(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KK, R extends MutableMultimap<KK, V>> R groupBy(Function<? super V, ? extends KK> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.groupBy(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KK, R extends MutableMultimap<KK, V>> R groupByEach(Function<? super V, ? extends Iterable<KK>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.groupByEach(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Comparable<? super A>> V minBy(Function<? super V, ? extends A> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.minBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Comparable<? super A>> V maxBy(Function<? super V, ? extends A> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.mapIterable.maxBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Comparable<? super A>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends A> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedSetBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Comparable<? super A>> MutableList<V> toSortedListBy(Function<? super V, ? extends A> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.toSortedListBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, R extends Collection<A>> R flatCollect(Function<? super V, ? extends Iterable<A>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.flatCollect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, A> RichIterable<A> collectWith(Function2<? super V, ? super P, ? extends A> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.mapIterable.collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, R extends Collection<A>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends A> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectIf(predicate, function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, A, R extends Collection<A>> R collectWith(Function2<? super V, ? super P, ? extends A> function, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectWith(function, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, R extends Collection<A>> R collect(Function<? super V, ? extends A> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectBoolean(booleanFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectByte(byteFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectChar(charFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectDouble(doubleFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectFloat(floatFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectInt(intFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectLong(longFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.mapIterable.collectShort(shortFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.forEachWithIndex(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure2, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            this.mapIterable.forEachWith(procedure2, parameter);
        }
    }

    public Iterator<V> iterator() {
        return this.mapIterable.iterator();
    }
}

