/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.property;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;

public class SpringValue {
    private MethodParameter methodParameter;
    private Field field;
    private Object bean;
    private String beanName;
    private String key;
    private String placeholder;
    private Class<?> targetType;
    private Type genericType;
    private boolean isJson;

    public SpringValue(String key, String placeholder, Object bean, String beanName, Field field, boolean isJson) {
        this.bean = bean;
        this.beanName = beanName;
        this.field = field;
        this.key = key;
        this.placeholder = placeholder;
        this.targetType = field.getType();
        this.isJson = isJson;
        if (isJson) {
            this.genericType = field.getGenericType();
        }
    }

    public SpringValue(String key, String placeholder, Object bean, String beanName, Method method, boolean isJson) {
        this.bean = bean;
        this.beanName = beanName;
        this.methodParameter = new MethodParameter(method, 0);
        this.key = key;
        this.placeholder = placeholder;
        Class<?>[] paramTps = method.getParameterTypes();
        this.targetType = paramTps[0];
        this.isJson = isJson;
        if (isJson) {
            this.genericType = method.getGenericParameterTypes()[0];
        }
    }

    public void update(Object newVal) throws IllegalAccessException, InvocationTargetException {
        if (this.isField()) {
            this.injectField(newVal);
        } else {
            this.injectMethod(newVal);
        }
    }

    private void injectField(Object newVal) throws IllegalAccessException {
        boolean accessible = this.field.isAccessible();
        this.field.setAccessible(true);
        this.field.set(this.bean, newVal);
        this.field.setAccessible(accessible);
    }

    private void injectMethod(Object newVal) throws InvocationTargetException, IllegalAccessException {
        this.methodParameter.getMethod().invoke(this.bean, newVal);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public boolean isField() {
        return this.field != null;
    }

    public Field getField() {
        return this.field;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public boolean isJson() {
        return this.isJson;
    }

    public String toString() {
        if (this.isField()) {
            return String.format("key: %s, beanName: %s, field: %s.%s", this.key, this.beanName, this.bean.getClass().getName(), this.field.getName());
        }
        return String.format("key: %s, beanName: %s, method: %s.%s", this.key, this.beanName, this.bean.getClass().getName(), this.methodParameter.getMethod().getName());
    }
}

