/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.security.Md5Encoder;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlOptUtils {
    protected static final Logger logger = LoggerFactory.getLogger(UrlOptUtils.class);

    private UrlOptUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static final String getUrlParamter(String szUrl) {
        String sQuery;
        try {
            URL url = new URL(szUrl);
            sQuery = url.getQuery();
        }
        catch (MalformedURLException e) {
            int n = szUrl.indexOf(63);
            int nM = szUrl.lastIndexOf(35);
            if (nM > 0 && nM > n) {
                sQuery = n > 0 ? szUrl.substring(n + 1, nM) : szUrl.substring(0, nM);
            }
            sQuery = n > 0 ? szUrl.substring(n + 1) : "";
        }
        return sQuery;
    }

    public static final Map<String, String> splitUrlParamter(String szUrlParameter) {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        int bpos = 0;
        while ((n = szUrlParameter.indexOf(61, bpos)) >= 0) {
            String value;
            String name = szUrlParameter.substring(bpos, n);
            int n2 = szUrlParameter.indexOf(38, n + 1);
            if (n2 < 0) {
                value = szUrlParameter.substring(n + 1);
                try {
                    value = URLDecoder.decode(value, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                params.put(name, value);
                break;
            }
            value = szUrlParameter.substring(n + 1, n2);
            try {
                value = URLDecoder.decode(value, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            params.put(name, value);
            bpos = n2 + 1;
        }
        return params;
    }

    public static String getUrlDomain(String curl) {
        try {
            return new URL(curl).getHost();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String appendParamsToUrl(String uri, Map<String, Object> queryParam) {
        StringBuilder urlBuilder = new StringBuilder(uri);
        if (queryParam != null) {
            if (!uri.endsWith("?") && !uri.endsWith("&")) {
                if (uri.indexOf(63) == -1) {
                    urlBuilder.append('?');
                } else {
                    urlBuilder.append('&');
                }
            }
            int n = 0;
            for (Map.Entry<String, Object> ent : queryParam.entrySet()) {
                if (n > 0) {
                    urlBuilder.append('&');
                }
                ++n;
                urlBuilder.append(ent.getKey()).append('=').append(StringEscapeUtils.escapeHtml4((String)StringBaseOpt.objectToString(ent.getValue())));
            }
        }
        return urlBuilder.toString();
    }

    public static String appendParamToUrl(String uri, String queryUrl) {
        if (queryUrl == null || "".equals(queryUrl)) {
            return uri;
        }
        return uri.endsWith("?") || uri.endsWith("&") ? uri + queryUrl : (uri.indexOf(63) == -1 ? uri + '?' + queryUrl : uri + '&' + queryUrl);
    }

    public static String appendParamToUrl(String uri, String paramName, Object paramValue) {
        return uri.endsWith("?") || uri.endsWith("&") ? uri + paramName + "=" + StringBaseOpt.objectToString(paramValue) : uri + (uri.indexOf(63) == -1 ? (char)'?' : '&') + paramName + "=" + StringEscapeUtils.escapeHtml4((String)StringBaseOpt.objectToString(paramValue));
    }

    public static String shortenCodeUrl(String longUrl, int urlLength) {
        if (urlLength < 4) {
            urlLength = 8;
        }
        StringBuilder sbBuilder = new StringBuilder(urlLength + 2);
        String md5Hex = "";
        int nLen = 0;
        block0: while (nLen < urlLength) {
            md5Hex = Md5Encoder.encodeBase64(md5Hex + longUrl);
            for (int i = 0; i < md5Hex.length(); ++i) {
                char c = md5Hex.charAt(i);
                if (c != '/' && c != '+') {
                    sbBuilder.append(c);
                    ++nLen;
                }
                if (nLen == urlLength) continue block0;
            }
        }
        return sbBuilder.toString();
    }
}

