/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.RandomUidGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutlookMeetingUtils {
    protected static final Logger logger = LoggerFactory.getLogger(OutlookMeetingUtils.class);
    public static String mailHost = "mail.centit.com";
    public static String mailUser = "accounts@centit.com";
    public static String mailPassword = "yhs@yhs1";
    public static int smtpPort = 25;

    private OutlookMeetingUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void setOutlookServer(String mailHost, String mailUser, String mailPassword) {
        OutlookMeetingUtils.mailHost = mailHost;
        OutlookMeetingUtils.mailUser = mailUser;
        OutlookMeetingUtils.mailPassword = mailPassword;
    }

    public static void setOutlookServer(String mailHost, String mailUser, String mailPassword, int smtpPort) {
        OutlookMeetingUtils.mailHost = mailHost;
        OutlookMeetingUtils.mailUser = mailUser;
        OutlookMeetingUtils.mailPassword = mailPassword;
        OutlookMeetingUtils.smtpPort = smtpPort;
    }

    public static void sendTextEmail(String content, String subject, final String sendMail, final String password, List<String> receiveMail, String mailHost, int port) throws MessagingException, IOException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.host", mailHost);
        props.setProperty("mail.smtp.port", String.valueOf(port));
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(sendMail, password);
            }
        });
        session.setDebug(true);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(sendMail));
        msg.setSubject(subject);
        if (receiveMail != null) {
            for (int i = 0; i < receiveMail.size(); ++i) {
                InternetAddress toAddr = new InternetAddress(receiveMail.get(i));
                msg.addRecipient(Message.RecipientType.TO, (Address)toAddr);
            }
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(content, "text/calendar;method=REQUEST;charset=\"UTF-8\"")));
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }

    public static void sendTextEmail(String content, String subject, List<String> receiveMail) throws AddressException, MessagingException, IOException {
        OutlookMeetingUtils.sendTextEmail(content, subject, mailUser, mailPassword, receiveMail, mailHost, smtpPort);
    }

    public static DateTime utilDateToIcalDatetime(java.util.Date date) {
        return new DateTime(date);
    }

    private static String makeICalMeetingText(Uid uid, java.util.Date startTime, java.util.Date endTime, String title, String organizerName, String organizerEmail, String location, String description, List<Pair<String, String>> participators) throws IOException {
        DateTime start = OutlookMeetingUtils.utilDateToIcalDatetime(startTime);
        DateTime end = OutlookMeetingUtils.utilDateToIcalDatetime(endTime);
        String eventTitle = "";
        if (StringUtils.isNotBlank((CharSequence)title)) {
            eventTitle = title;
        }
        VEvent meeting = new VEvent((Date)start, (Date)end, eventTitle);
        Calendar icsCalendar = new Calendar();
        icsCalendar.getProperties().add((Property)new ProdId("-//Events Calendar//iCal4j 1.0//EN"));
        icsCalendar.getProperties().add((Property)Version.VERSION_2_0);
        icsCalendar.getProperties().add((Property)CalScale.GREGORIAN);
        icsCalendar.getProperties().add((Property)Method.REQUEST);
        meeting.getProperties().add((Property)uid);
        Organizer organizer = new Organizer(URI.create("mailto:" + organizerEmail));
        organizer.getParameters().add((Parameter)new Cn(organizerName));
        meeting.getProperties().add((Property)organizer);
        if (StringUtils.isNotBlank((CharSequence)location)) {
            meeting.getProperties().add((Property)new Location(location));
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            meeting.getProperties().add((Property)new Description(description));
        }
        for (Pair<String, String> p : participators) {
            Attendee dev = new Attendee(URI.create("mailto:" + (String)p.getRight()));
            dev.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
            dev.getParameters().add((Parameter)new Cn((String)p.getLeft()));
            meeting.getProperties().add((Property)dev);
        }
        icsCalendar.getComponents().add((Object)meeting);
        CalendarOutputter outputter = new CalendarOutputter();
        StringWriter writer = new StringWriter();
        outputter.output(icsCalendar, (Writer)writer);
        return ((Object)writer).toString();
    }

    private static String makeICalCancelMeetingText(Uid uid, java.util.Date startTime, java.util.Date endTime, String title, String organizerName, String organizerEmail, String location, String description) throws IOException {
        DateTime start = OutlookMeetingUtils.utilDateToIcalDatetime(startTime);
        DateTime end = OutlookMeetingUtils.utilDateToIcalDatetime(endTime);
        VEvent meeting = new VEvent((Date)start, (Date)end, "delete");
        Calendar icsCalendar = new Calendar();
        icsCalendar.getProperties().add((Property)new ProdId("-//Events Calendar//iCal4j 1.0//EN"));
        icsCalendar.getProperties().add((Property)Version.VERSION_2_0);
        icsCalendar.getProperties().add((Property)CalScale.GREGORIAN);
        icsCalendar.getProperties().add((Property)Method.CANCEL);
        meeting.getProperties().add((Property)new Sequence());
        meeting.getProperties().add((Property)uid);
        Organizer organizer = new Organizer(URI.create("mailto:" + organizerEmail));
        organizer.getParameters().add((Parameter)new Cn(organizerName));
        meeting.getProperties().add((Property)organizer);
        if (StringUtils.isNotBlank((CharSequence)location)) {
            meeting.getProperties().add((Property)new Location(location));
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            meeting.getProperties().add((Property)new Description(description));
        }
        icsCalendar.getComponents().add((Object)meeting);
        CalendarOutputter outputter = new CalendarOutputter();
        StringWriter writer = new StringWriter();
        outputter.output(icsCalendar, (Writer)writer);
        return ((Object)writer).toString();
    }

    public static String createMeeting(java.util.Date startTime, java.util.Date endTime, String title, String organizerName, String organizerEmail, String location, String description, List<Pair<String, String>> participators) throws MessagingException, IOException {
        RandomUidGenerator ug = new RandomUidGenerator();
        Uid uid = ug.generateUid();
        String content = OutlookMeetingUtils.makeICalMeetingText(uid, startTime, endTime, title, organizerName, organizerEmail, location, description, participators);
        ArrayList<String> receiveMail = new ArrayList<String>();
        for (Pair<String, String> p : participators) {
            receiveMail.add((String)p.getRight());
        }
        OutlookMeetingUtils.sendTextEmail(content, title, receiveMail);
        return uid.toString();
    }

    public static void updateMeeting(String uidStr, java.util.Date startTime, java.util.Date endTime, String title, String organizerName, String organizerEmail, String location, String description, List<Pair<String, String>> participators) throws MessagingException, IOException {
        Uid uid = new Uid(uidStr);
        String content = OutlookMeetingUtils.makeICalMeetingText(uid, startTime, endTime, title, organizerName, organizerEmail, location, description, participators);
        ArrayList<String> receiveMail = new ArrayList<String>();
        for (Pair<String, String> p : participators) {
            receiveMail.add((String)p.getRight());
        }
        OutlookMeetingUtils.sendTextEmail(content, title, receiveMail);
    }

    public static void deleteMeeting(String uidStr, java.util.Date startTime, java.util.Date endTime, String title, String organizerName, String organizerEmail, String location, String description, List<Pair<String, String>> participators) throws MessagingException, IOException {
        Uid uid = new Uid(uidStr);
        String content = OutlookMeetingUtils.makeICalCancelMeetingText(uid, startTime, endTime, title, organizerName, organizerEmail, location, description);
        ArrayList<String> receiveMail = new ArrayList<String>();
        for (Pair<String, String> p : participators) {
            receiveMail.add((String)p.getRight());
        }
        OutlookMeetingUtils.sendTextEmail(content, title, receiveMail);
    }
}

