/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.ByteBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBeanField {
    private static final Logger logger = LoggerFactory.getLogger(JavaBeanField.class);
    private String fieldJavaType;
    private Class<?> fieldType;
    private Method setFieldValueFunc;
    private Method getFieldValueFunc;
    private Field objectField;

    public JavaBeanField() {
    }

    public JavaBeanField(Field objectField) {
        this.setObjectField(objectField);
    }

    public Method getSetFieldValueFunc() {
        return this.setFieldValueFunc;
    }

    public void setSetFieldValueFunc(Method setFieldValueFunc) {
        this.setFieldValueFunc = setFieldValueFunc;
    }

    public Method getGetFieldValueFunc() {
        return this.getFieldValueFunc;
    }

    public void setGetFieldValueFunc(Method getFieldValueFunc) {
        this.getFieldValueFunc = getFieldValueFunc;
    }

    public Field getObjectField() {
        return this.objectField;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Class<?> fieldType) {
        this.fieldType = fieldType;
        this.fieldJavaType = ReflectionOpt.getJavaTypeName(fieldType);
    }

    public void setObjectField(Field objectField) {
        this.objectField = objectField;
        this.setFieldType(objectField.getType());
    }

    public String getFieldJavaType() {
        return this.fieldJavaType;
    }

    public boolean isAssignableFrom(Class<?> valueType) {
        return this.fieldType.isAssignableFrom(valueType);
    }

    private void innerSetObjectFieldValue(Object obj, Object fieldValue) {
        try {
            if (this.setFieldValueFunc != null) {
                this.setFieldValueFunc.invoke(obj, fieldValue);
            } else {
                boolean accessible = this.objectField.isAccessible();
                if (!accessible) {
                    this.objectField.setAccessible(true);
                }
                this.objectField.set(obj, fieldValue);
                if (!accessible) {
                    this.objectField.setAccessible(accessible);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setObjectFieldValue(Object object, Object newValue) {
        if (newValue == null) {
            this.innerSetObjectFieldValue(object, null);
            return;
        }
        switch (this.getFieldJavaType()) {
            case "int": 
            case "Integer": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToInteger(newValue));
                break;
            }
            case "long": 
            case "Long": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToLong(newValue));
                break;
            }
            case "float": 
            case "Float": 
            case "double": 
            case "Double": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToDouble(newValue));
                break;
            }
            case "byte[]": {
                this.innerSetObjectFieldValue(object, ByteBaseOpt.castObjectToBytes(newValue));
                break;
            }
            case "BigDecimal": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToBigDecimal(newValue));
                break;
            }
            case "BigInteger": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToBigInteger(newValue));
                break;
            }
            case "String": {
                this.innerSetObjectFieldValue(object, StringBaseOpt.objectToString(newValue));
                break;
            }
            case "Date": {
                this.innerSetObjectFieldValue(object, DatetimeOpt.castObjectToDate(newValue));
                break;
            }
            case "sqlDate": {
                this.innerSetObjectFieldValue(object, DatetimeOpt.castObjectToSqlDate(newValue));
                break;
            }
            case "sqlTimestamp": {
                this.innerSetObjectFieldValue(object, DatetimeOpt.castObjectToSqlTimestamp(newValue));
            }
            case "boolean": 
            case "Boolean": {
                this.innerSetObjectFieldValue(object, StringRegularOpt.isTrue(StringBaseOpt.objectToString(newValue)));
                break;
            }
            default: {
                this.innerSetObjectFieldValue(object, newValue);
            }
        }
    }

    public Object getObjectFieldValue(Object obj) {
        try {
            if (this.getFieldValueFunc != null) {
                return this.getFieldValueFunc.invoke(obj, new Object[0]);
            }
            return this.objectField.get(obj);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

