/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.ByteBaseOpt;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

public abstract class UuidOpt {
    private UuidOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static String uuidToString32(UUID uuid) {
        long leastSigBits = uuid.getLeastSignificantBits();
        long mostSigBits = uuid.getMostSignificantBits();
        return UuidOpt.digits(mostSigBits >> 32, 8) + UuidOpt.digits(mostSigBits, 8) + UuidOpt.digits(leastSigBits >> 32, 8) + UuidOpt.digits(leastSigBits, 8);
    }

    public static String uuidToString36(UUID uuid) {
        long leastSigBits = uuid.getLeastSignificantBits();
        long mostSigBits = uuid.getMostSignificantBits();
        return UuidOpt.digits(mostSigBits >> 32, 8) + "-" + UuidOpt.digits(mostSigBits >> 16, 4) + "-" + UuidOpt.digits(mostSigBits, 4) + "-" + UuidOpt.digits(leastSigBits >> 48, 4) + "-" + UuidOpt.digits(leastSigBits, 12);
    }

    public static String uuidToBase64String(UUID uuid) {
        byte[] buf = new byte[16];
        ByteBaseOpt.writeInt64(buf, uuid.getMostSignificantBits(), 0);
        ByteBaseOpt.writeInt64(buf, uuid.getLeastSignificantBits(), 8);
        return new String(Base64.encodeBase64((byte[])buf), 0, 22);
    }

    public static String getUuidAsString36() {
        return UuidOpt.uuidToString36(UUID.randomUUID());
    }

    public static String getUuidAsString32() {
        return UuidOpt.uuidToString32(UUID.randomUUID());
    }

    public static String getUuidAsBase64String() {
        return UuidOpt.uuidToBase64String(UUID.randomUUID());
    }

    public static String getUuidAsString22() {
        return UuidOpt.uuidToBase64String(UUID.randomUUID());
    }

    public static String getUuidAsString() {
        return UuidOpt.uuidToString32(UUID.randomUUID());
    }
}

