/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectionOpt {
    protected static final Log logger = LogFactory.getLog(ReflectionOpt.class);

    private ReflectionOpt() {
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        return ReflectionOpt.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class clazz, String propertyName) throws NoSuchFieldException {
        assert (clazz != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Class superClass = clazz;
        while (superClass != Object.class) {
            try {
                Field f = superClass.getDeclaredField(propertyName);
                if (f != null) {
                    return f;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            superClass = superClass.getSuperclass();
        }
        throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
    }

    public static Object forceGetProperty(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.info((Object)"error wont' happen");
        }
        field.setAccessible(accessible);
        return result;
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            logger.info((Object)"Error won't happen");
        }
        field.setAccessible(accessible);
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object ... params) throws NoSuchMethodException {
        assert (object != null);
        assert (methodName != null && !methodName.isEmpty());
        Class[] types = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            types[i] = params[i].getClass();
            ++i;
        }
        Class<?> clazz = object.getClass();
        AccessibleObject method = null;
        Class<?> superClass = clazz;
        while (superClass != Object.class) {
            try {
                method = superClass.getDeclaredMethod(methodName, types);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                superClass = superClass.getSuperclass();
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("No Such Method:" + clazz.getSimpleName() + methodName);
        }
        boolean accessible = method.isAccessible();
        ((Method)method).setAccessible(true);
        Object result = null;
        try {
            result = ((Method)method).invoke(object, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((Method)method).setAccessible(accessible);
        return result;
    }

    public static List<Field> getFieldsByType(Object object, Class type) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        Field[] fieldArray = fields = object.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType().isAssignableFrom(type)) {
                list.add(field);
            }
            ++n2;
        }
        return list;
    }

    public static Class getPropertyType(Class type, String name) throws NoSuchFieldException {
        return ReflectionOpt.getDeclaredField(type, name).getType();
    }

    public static String getGetterName(Class type, String fieldName) {
        assert (type != null);
        assert (fieldName != null && !fieldName.isEmpty());
        if (type.getName().equals("boolean")) {
            return "is" + StringUtils.capitalize((String)fieldName);
        }
        return "get" + StringUtils.capitalize((String)fieldName);
    }

    public static Method getGetterMethod(Class<?> type, String fieldName) {
        try {
            return type.getMethod(ReflectionOpt.getGetterName(type, fieldName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> void InvokeBinaryOpt(T demander, String smethod, T param) {
        try {
            Method setV = demander.getClass().getMethod(smethod, demander.getClass());
            if (setV == null) {
                return;
            }
            setV.invoke(demander, param);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return ReflectionOpt.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn((Object)(String.valueOf(clazz.getSimpleName()) + "'s superclass not ParameterizedType"));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn((Object)("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn((Object)(String.valueOf(clazz.getSimpleName()) + " not set the actual class on superclass generic parameter"));
            return Object.class;
        }
        return (Class)params[index];
    }
}

