/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service;

import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.Indexer;
import com.centit.search.service.Searcher;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.file.PropertiesReader;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class IndexerSearcherFactory {
    private static ConcurrentHashMap<String, Indexer> indexerMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Searcher> searcherMap = new ConcurrentHashMap();

    public static Indexer obtainIndexer(ESServerConfig config, Class<?> ... objTypes) {
        Indexer index = indexerMap.get(config.getIndexName());
        if (index != null) {
            return index;
        }
        ESIndexer indexer = new ESIndexer(config);
        if (indexer.createIndexIfNotExist()) {
            indexer.initMappingType(objTypes);
        }
        indexerMap.put(config.getIndexName(), indexer);
        return indexer;
    }

    public static Searcher obtainSearcher(ESServerConfig config, Class<?> ... objTypes) {
        Searcher search = searcherMap.get(config.getIndexName());
        if (search != null) {
            return search;
        }
        ESSearcher searcher = new ESSearcher(config);
        searcher.initTypeFields(objTypes);
        searcher.setHightPreTags(new String[]{"<H1>"});
        searcher.setHightPostTags(new String[]{"</H1>"});
        searcherMap.put(config.getIndexName(), searcher);
        return searcher;
    }

    public static ESServerConfig loadESServerConfigFormProperties(Properties properties) {
        ESServerConfig config = new ESServerConfig();
        config.setServerHostIp(properties.getProperty("elasticsearch.server.ip"));
        config.setServerHostPort(NumberBaseOpt.castObjectToInteger((Object)properties.getProperty("elasticsearch.server.port")));
        config.setClusterName(properties.getProperty("elasticsearch.server.cluster"));
        config.setIndexName(StringUtils.lowerCase((String)properties.getProperty("elasticsearch.index")));
        config.setOsId(properties.getProperty("elasticsearch.osId"));
        config.setMinScore(NumberBaseOpt.parseFloat((String)properties.getProperty("elasticsearch.filter.minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return config;
    }

    public static ESServerConfig loadESServerConfigFormProperties(String propertiesFile) {
        Properties properties = PropertiesReader.getClassPathProperties((String)propertiesFile);
        return IndexerSearcherFactory.loadESServerConfigFormProperties(properties);
    }
}

