/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.service.ESServerConfig;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class PooledTransportClientTactory
implements PooledObjectFactory<TransportClient> {
    private ESServerConfig conifg;

    public PooledTransportClientTactory(ESServerConfig conifg) {
        this.conifg = conifg;
    }

    public PooledObject<TransportClient> makeObject() throws Exception {
        Settings esSettings = Settings.builder().put("cluster.name", this.conifg.getClusterName()).put("client.transport.sniff", true).build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(esSettings, new Class[0]);
        InetSocketTransportAddress transportAddress = new InetSocketTransportAddress(InetAddresses.forString((String)this.conifg.getServerHostIp()), this.conifg.getServerHostPort());
        client.addTransportAddresses(new TransportAddress[]{transportAddress});
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<TransportClient> p) throws Exception {
        ((TransportClient)p.getObject()).close();
    }

    public boolean validateObject(PooledObject<TransportClient> p) {
        return true;
    }

    public void activateObject(PooledObject<TransportClient> p) throws Exception {
    }

    public void passivateObject(PooledObject<TransportClient> p) throws Exception {
    }

    public void setConifg(ESServerConfig conifg) {
        this.conifg = conifg;
    }
}

