/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.centit.search.annotation.ESType;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.PooledTransportClientTactory;
import com.centit.search.service.Searcher;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.json.JSONOpt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSearcher
implements Searcher {
    private static Logger logger = LoggerFactory.getLogger(ESSearcher.class);
    private ESServerConfig config;
    private GenericObjectPool<TransportClient> clientPool;
    private String[] hightPreTags;
    private String[] hightPostTags;
    private String[] queryFields;
    private Set<String> highlightFields = new HashSet<String>();
    private String[] revertFields;

    public ESSearcher(ESServerConfig config) {
        this.config = config;
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        this.clientPool = new GenericObjectPool((PooledObjectFactory)new PooledTransportClientTactory(config), poolConfig);
    }

    public void initTypeFields(Class<?> ... objTypes) {
        if (objTypes != null) {
            HashSet<String> rf = new HashSet<String>();
            HashSet<String> qf = new HashSet<String>();
            for (Class<?> objType : objTypes) {
                Field[] objFields;
                for (Field field : objFields = objType.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(ESType.class)) continue;
                    ESType esType = field.getAnnotation(ESType.class);
                    if (esType.query()) {
                        qf.add(field.getName());
                    }
                    if (esType.highlight()) {
                        this.highlightFields.add(field.getName());
                    }
                    if (!esType.revert()) continue;
                    rf.add(field.getName());
                }
            }
            if (rf.size() > 0) {
                this.revertFields = new String[rf.size()];
                int i = 0;
                Iterator iterator = rf.iterator();
                while (iterator.hasNext()) {
                    String fn;
                    this.revertFields[i] = fn = (String)iterator.next();
                    ++i;
                }
            }
            if (qf.size() > 0) {
                this.queryFields = new String[qf.size()];
                int i = 0;
                Iterator iterator = qf.iterator();
                while (iterator.hasNext()) {
                    String fn;
                    this.queryFields[i] = fn = (String)iterator.next();
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> esSearch(QueryBuilder queryBuilder, int pageNo, int pageSize) {
        TransportClient client = null;
        try {
            client = (TransportClient)this.clientPool.borrowObject();
            ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            for (String hf : this.highlightFields) {
                highlightBuilder.field(hf);
            }
            ((HighlightBuilder)highlightBuilder.preTags(this.hightPreTags)).postTags(this.hightPostTags);
            SearchResponse actionGet = (SearchResponse)client.prepareSearch(new String[]{this.config.getIndexName()}).setQuery(queryBuilder).highlighter(highlightBuilder).setExplain(true).setMinScore(this.config.getMinScore()).setFrom(pageNo > 1 ? (pageNo - 1) * pageSize : 0).setSize(pageSize).storedFields(this.revertFields).execute().actionGet();
            SearchHits hits = actionGet.getHits();
            for (SearchHit hit : hits.getHits()) {
                JSONObject json = new JSONObject();
                for (Map.Entry field : hit.getFields().entrySet()) {
                    List objValues = ((SearchHitField)field.getValue()).getValues();
                    if (objValues == null || objValues.size() <= 0) continue;
                    if (objValues.size() == 1) {
                        json.put((String)field.getKey(), objValues.get(0));
                        continue;
                    }
                    json.put((String)field.getKey(), (Object)objValues);
                }
                if (hit.getHighlightFields() != null) {
                    StringBuilder content = new StringBuilder("");
                    for (Map.Entry highlight : hit.getHighlightFields().entrySet()) {
                        HighlightField highlightField = (HighlightField)highlight.getValue();
                        if (highlightField != null) {
                            for (Text t : highlightField.fragments()) {
                                content.append(t.string());
                            }
                        }
                        content.append("\n");
                    }
                    json.put("highlight", (Object)content);
                }
                json.put("_score", (Object)Float.valueOf(hit.getScore()));
                String hitType = hit.getType();
                if (hitType != null) {
                    json.put("_type", (Object)hitType);
                }
                retList.add((Map<String, Object>)json);
            }
            ArrayList<Map<String, Object>> arrayList = retList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            List<Map<String, Object>> list = null;
            return list;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    @Override
    public List<Map<String, Object>> search(Map<String, Object> fieldFilter, String queryWord, int pageNo, int pageSize) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (fieldFilter != null) {
            for (Map.Entry<String, Object> ent : fieldFilter.entrySet()) {
                if (ent.getValue().getClass().isArray()) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ent.getKey(), (String[])((String[])ent.getValue())));
                    continue;
                }
                if (ent.getValue() instanceof Collection) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ent.getKey(), (Object[])ListOpt.listToArray((Collection)((Collection)ent.getValue()))));
                    continue;
                }
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)ent.getKey(), (Object)ent.getValue()));
            }
        }
        queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)queryWord, (String[])this.queryFields));
        return this.esSearch((QueryBuilder)queryBuilder, pageNo, pageSize);
    }

    @Override
    public List<Map<String, Object>> search(String queryWord, int pageNo, int pageSize) {
        return this.search(null, queryWord, pageNo, pageSize);
    }

    @Override
    public List<Map<String, Object>> searchOpt(String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(JSONOpt.createHashMap((Object[])new Object[]{"optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public List<Map<String, Object>> searchOwner(String owner, String queryWord, int pageNo, int pageSize) {
        return this.search(JSONOpt.createHashMap((Object[])new Object[]{"userCode", owner}), queryWord, pageNo, pageSize);
    }

    @Override
    public List<Map<String, Object>> searchOwner(String owner, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(JSONOpt.createHashMap((Object[])new Object[]{"userCode", owner, "optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public List<Map<String, Object>> searchUnits(String[] units, String queryWord, int pageNo, int pageSize) {
        return this.search(JSONOpt.createHashMap((Object[])new Object[]{"unitCode", units}), queryWord, pageNo, pageSize);
    }

    @Override
    public List<Map<String, Object>> searchUnits(String[] units, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(JSONOpt.createHashMap((Object[])new Object[]{"optId", optId, "unitCode", units}), queryWord, pageNo, pageSize);
    }

    public ESSearcher setHightPreTags(String[] hightPreTags) {
        this.hightPreTags = hightPreTags;
        return this;
    }

    public ESSearcher setHightPostTags(String[] hightPostTags) {
        this.hightPostTags = hightPostTags;
        return this;
    }
}

