/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.document;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.search.annotation.ESType;
import com.centit.search.document.ESDocument;
import com.centit.support.security.Md5Encoder;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@ESType(type="object")
public class ObjectDocument
implements ESDocument,
Serializable {
    public static final String ES_DOCUMENT_TYPE = "object";
    private static final long serialVersionUID = 1L;
    @ESType(type="text")
    private String osId;
    @ESType(type="text")
    private String optId;
    @ESType(type="text")
    private String optTag;
    @ESType(type="text")
    private String optMethod;
    @ESType(type="text")
    private String optUrl;
    @ESType(type="text")
    private String userCode;
    @ESType(type="text")
    private String unitCode;
    @ESType(type="text", index="analyzed", query=true, analyzer="ik_smart")
    private String title;
    @ESType(type="text", index="analyzed", query=true, revert=false, analyzer="ik_smart")
    private String[] keywords;
    @ESType(type="text", index="analyzed", query=true, revert=false, highlight=true, analyzer="ik_smart")
    private String content;
    @ESType(type="date")
    private Date createTime;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectDocument)) {
            return false;
        }
        ObjectDocument that = (ObjectDocument)o;
        if (!this.getOsId().equals(that.getOsId())) {
            return false;
        }
        if (!this.getOptId().equals(that.getOptId())) {
            return false;
        }
        if (!this.getOptTag().equals(that.getOptTag())) {
            return false;
        }
        return this.getOptMethod() != null ? this.getOptMethod().equals(that.getOptMethod()) : that.getOptMethod() == null;
    }

    public int hashCode() {
        int result = this.getOsId().hashCode();
        result = 31 * result + this.getOptId().hashCode();
        result = 31 * result + this.getOptTag().hashCode();
        result = 31 * result + (this.getOptMethod() != null ? this.getOptMethod().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public String getOptId() {
        return this.optId;
    }

    public void setOptId(String optId) {
        this.optId = optId;
    }

    public String getOptMethod() {
        return this.optMethod;
    }

    public void setOptMethod(String optMethod) {
        this.optMethod = optMethod;
    }

    public String getOptTag() {
        return this.optTag;
    }

    public void setOptTag(String optTag) {
        this.optTag = optTag;
    }

    public String getOptUrl() {
        return this.optUrl;
    }

    public void setOptUrl(String optUrl) {
        this.optUrl = optUrl;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String obtainDocumentId() {
        String docId = this.optId + ":";
        if (StringUtils.length((CharSequence)(this.optTag + this.optMethod)) > 36) {
            docId = docId + Md5Encoder.encode((String)(this.optTag + ":" + this.optMethod));
        } else {
            docId = docId + this.optTag;
            if (StringUtils.isNotBlank((CharSequence)this.optMethod)) {
                docId = docId + ":" + this.optMethod;
            }
        }
        return docId;
    }

    @Override
    public String obtainDocumentType() {
        return ES_DOCUMENT_TYPE;
    }

    @Override
    public JSONObject toJSONObject() {
        return (JSONObject)JSON.toJSON((Object)this);
    }
}

