/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.msgpusher.websocket;

import com.alibaba.fastjson.JSON;
import com.centit.msgpusher.msgpusher.PushResult;
import com.centit.msgpusher.msgpusher.po.IPushMessage;
import com.centit.msgpusher.msgpusher.po.IPushMsgPoint;
import com.centit.msgpusher.msgpusher.websocket.SocketMsgPusher;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="socketMsgPusher")
public class SocketMsgPusherImpl
implements SocketMsgPusher {
    private static final Logger logger = LoggerFactory.getLogger(SocketMsgPusherImpl.class);
    private static ConcurrentHashMap<String, Session> userCodeToSession = new ConcurrentHashMap();
    private static ConcurrentHashMap<Session, String> sessionToUserCode = new ConcurrentHashMap();

    private static boolean webSockectPushMessage(Session session, String message) {
        if (session == null) {
            return false;
        }
        session.getAsyncRemote().sendText(message);
        return true;
    }

    @Override
    public PushResult pushMessage(IPushMessage msg, IPushMsgPoint receiver) throws Exception {
        PushResult pushResult = new PushResult();
        HashMap<String, String> pcMap = new HashMap<String, String>();
        String osId = msg.getOsId();
        String userCode = receiver.getUserCode();
        String user = osId + "_" + userCode;
        String contentText = msg.getMsgContent();
        logger.debug("\u7ed9" + userCode + "\u53d1\u9001\u6d88\u606f" + contentText);
        Session socketIOClient = userCodeToSession.get(user);
        if (SocketMsgPusherImpl.webSockectPushMessage(socketIOClient, JSON.toJSONString((Object)msg))) {
            pcMap.put("pc", "OK");
            pushResult.setMap(pcMap);
            pushResult.setPushState("1");
        } else {
            pcMap.put("pc", "\u7528\u6237\u4e0d\u5b58\u5728");
            pushResult.setMap(pcMap);
            pushResult.setPushState("2");
        }
        return pushResult;
    }

    @Override
    public PushResult pushMsgToAll(IPushMessage msg) throws Exception {
        PushResult pushResult = new PushResult();
        HashMap<String, String> pcMap = new HashMap<String, String>();
        for (Map.Entry<String, Session> ent : userCodeToSession.entrySet()) {
            SocketMsgPusherImpl.webSockectPushMessage(ent.getValue(), JSON.toJSONString((Object)msg));
        }
        int socNo = userCodeToSession.size();
        pcMap.put("pc", "OK\uff0c\u8fde\u63a5\u6570\uff1a" + socNo);
        pushResult.setPushState("0");
        pushResult.setMap(pcMap);
        return pushResult;
    }

    private static Session getSessionByUserCode(String userCode) {
        if (userCode == null) {
            return null;
        }
        return userCodeToSession.get(userCode);
    }

    private static String getUserCodeBySession(Session session) {
        if (session == null) {
            return null;
        }
        return sessionToUserCode.get(session);
    }

    @Override
    public void signInUser(String osId, String userCode, Session session) {
        userCodeToSession.put(osId + "_" + userCode, session);
        sessionToUserCode.put(session, osId + "_" + userCode);
    }

    @Override
    public void signOutUser(Session session) {
        String userCode = SocketMsgPusherImpl.getUserCodeBySession(session);
        userCodeToSession.remove(userCode);
        sessionToUserCode.remove(session);
    }

    @Override
    public void recvMessage(Session session, String jsonMessage) {
        String userCode = SocketMsgPusherImpl.getUserCodeBySession(session);
        logger.info(userCode + " push " + jsonMessage);
    }
}

