/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.po.ApplicationTemplate;
import com.centit.locode.platform.service.ApplicationTemplateManager;
import com.centit.locode.platform.service.ModelExportManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.file.FileSystemOpt;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"applicationTemplate"})
@Api(value="\u5e94\u7528\u6a21\u677f\u7ba1\u7406", tags={"\u5e94\u7528\u6a21\u677f\u7ba1\u7406"})
public class ApplicationTemplateController
extends BaseController {
    private static final String TEMPLATE_ID = "templateId";
    private static final String IS_USED = "isUsed";
    @Autowired
    private ApplicationTemplateManager applicationTemplateManager;
    @Autowired
    private ModelExportManager modelExportManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4fdd\u5b58\u5e94\u7528\u6a21\u677f")
    @PostMapping(value={"/saveApp"})
    public void createApplicationInfo(HttpServletRequest request, HttpServletResponse response) {
        if ("system".equals(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request))) {
            ApplicationTemplate applicationTemplate = new ApplicationTemplate();
            if (!StringBaseOpt.isNvl((String)request.getParameter(TEMPLATE_ID))) {
                applicationTemplate.setTemplateId(request.getParameter(TEMPLATE_ID));
            }
            applicationTemplate.setTemplateName(request.getParameter("templateName"));
            applicationTemplate.setTemplateType(request.getParameter("templateType"));
            applicationTemplate.setPicId(request.getParameter("picId"));
            applicationTemplate.setTemplateMemo(request.getParameter("templateMemo"));
            if (request.getParameter(IS_USED) == null || "".equals(request.getParameter(IS_USED))) {
                applicationTemplate.setIsUsed("T");
            } else {
                applicationTemplate.setIsUsed(request.getParameter(IS_USED));
            }
            FileSystemOpt.createDirect((String)SystemTempFileUtils.getTempDirectory());
            String tempFilePath = SystemTempFileUtils.getRandomTempFilePath();
            try {
                InputStream inputStream = (InputStream)UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request).getRight();
                File file = new File(tempFilePath);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
                if (file.length() != 0L) {
                    applicationTemplate.setTemplateContent(this.modelExportManager.uploadModel(file));
                }
                this.applicationTemplateManager.mergeApplicationTemplate(applicationTemplate);
                JsonResultUtils.writeSingleDataJson((Object)applicationTemplate, (HttpServletResponse)response);
            }
            catch (Exception e) {
                JsonResultUtils.writeErrorMessageJson((String)e.getLocalizedMessage(), (HttpServletResponse)response);
            }
            finally {
                FileSystemOpt.deleteFile((String)tempFilePath);
            }
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u53ea\u6709\u5e73\u53f0\u7ba1\u7406\u5458\u6709\u6743\u9650", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u6a21\u677f")
    @ApiImplicitParam(name="templateId", value="\u6a21\u677fID")
    @DeleteMapping(value={"/{templateId}"})
    @WrapUpResponseBody
    public void deleteApplicationTemplate(@PathVariable String templateId, HttpServletRequest request, HttpServletResponse response) {
        if ("system".equals(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request))) {
            this.applicationTemplateManager.deleteApplicationTemplate(templateId);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u53ea\u6709\u5e73\u53f0\u7ba1\u7406\u5458\u6709\u6743\u9650", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u6a21\u677f")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<ApplicationTemplate> listApplicationTemplate(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = ApplicationTemplateController.collectRequestParameters((HttpServletRequest)request);
        if (!"system".equals(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request))) {
            searchColumn.put(IS_USED, "T");
        }
        List<ApplicationTemplate> list = this.applicationTemplateManager.listApplicationTemplate(searchColumn, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5e94\u7528\u6a21\u677f")
    @GetMapping(value={"/{templateId}"})
    @WrapUpResponseBody
    public ApplicationTemplate getApplicationTemplate(@PathVariable String templateId) {
        return this.applicationTemplateManager.getApplicationTemplate(templateId);
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u521b\u5efa\u5e94\u7528")
    @RequestMapping(value={"/createApp"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public Integer createApp(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails == null) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        if (jsonObject == null) {
            throw new ObjectException(400, "\u5bfc\u5165\u5185\u5bb9\u6ca1\u6709\u586b\u5199");
        }
        return this.modelExportManager.createApp(jsonObject, "", userDetails);
    }

    @ApiOperation(value="\u5bfc\u5165\u8986\u76d6\u5e94\u7528")
    @RequestMapping(value={"/updateApp/{osId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public Integer createApp(@RequestBody JSONObject jsonObject, HttpServletRequest request, @PathVariable String osId) {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails == null) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        if (jsonObject == null) {
            throw new ObjectException(400, "\u5bfc\u5165\u5185\u5bb9\u6ca1\u6709\u586b\u5199");
        }
        return this.modelExportManager.createApp(jsonObject, osId, userDetails);
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u5bfc\u5165\u5e94\u7528\u8fd4\u56de\u9884\u5904\u7406\u7ed3\u679c")
    @RequestMapping(value={"/prepareTemplateApp"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONObject prepareTemplateApp(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails == null) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        if (jsonObject == null) {
            throw new ObjectException(400, "\u5bfc\u5165\u5185\u5bb9\u6ca1\u6709\u586b\u5199");
        }
        return this.modelExportManager.prepareApp(jsonObject, "", userDetails);
    }

    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528\u8fd4\u56de\u9884\u5904\u7406\u7ed3\u679c")
    @RequestMapping(value={"/prepareUpdateApp/{osId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONObject prepareApp(@RequestBody JSONObject jsonObject, HttpServletRequest request, @PathVariable String osId) {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails == null) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        if (jsonObject == null) {
            throw new ObjectException(400, "\u5bfc\u5165\u5185\u5bb9\u6ca1\u6709\u586b\u5199");
        }
        return this.modelExportManager.prepareApp(jsonObject, osId, WebOptUtils.getCurrentUserDetails((HttpServletRequest)request));
    }

    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528\u8fd4\u56de\u9884\u5904\u7406\u7ed3\u679c")
    @RequestMapping(value={"/importApp"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public Integer importApp(@RequestBody JSONObject jsonObject, HttpServletRequest request) throws Exception {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails == null) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        if (jsonObject == null) {
            throw new ObjectException(400, "\u5bfc\u5165\u5185\u5bb9\u6ca1\u6709\u586b\u5199");
        }
        return this.modelExportManager.importApp(jsonObject, userDetails);
    }
}

