/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.service.OptMethodManager;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUnitRoleManager;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.support.common.ObjectException;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/roleinfo"})
@Api(value="\u7cfb\u7edf\u89d2\u8272\u64cd\u4f5c\u63a5\u53e3", tags={"\u7cfb\u7edf\u89d2\u8272\u64cd\u4f5c\u63a5\u53e3"})
public class RoleInfoController
extends BaseController {
    @Autowired
    @NotNull
    private SysRoleManager sysRoleManager;
    @Autowired
    @NotNull
    private OptMethodManager optMethodManager;
    @Autowired
    private SysUserRoleManager sysUserRoleManager;
    @Autowired
    private SysUnitRoleManager sysUnitRoleManager;

    public String getOptId() {
        return "ROLEMAG";
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7cfb\u7edf\u89d2\u8272", notes="\u67e5\u8be2\u6240\u6709\u7cfb\u7edf\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<RoleInfo> listAllRole(PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("NP_ALL", "true");
        List list = this.sysRoleManager.listObjects(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5b50\u7cfb\u7edf\u89d2\u8272", notes="\u67e5\u8be2\u5b50\u7cfb\u7edf\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="topOptId", value="\u5b50\u7cfb\u7edf\u4ee3\u7801", allowMultiple=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/subSysRole/{topOptId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<RoleInfo> listSubSystemRole(@PathVariable String topOptId, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("subSystemROLE", topOptId);
        List list = this.sysRoleManager.listObjects(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u53ef\u7528\u7684\u7cfb\u7edf\u89d2\u8272", notes="\u67e5\u8be2\u6240\u6709\u53ef\u7528\u7684\u7cfb\u7edf\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="String"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/global"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<RoleInfo> listGlobalAndPublicRole(String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("NP_GLOBAL", "true");
        filterMap.put("isValid", "T");
        List roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)roleInfos, (PageDesc)pageDesc, (String[])field);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709 \u5f53\u524d\u90e8\u95e8\u89d2\u8272", notes="\u67e5\u8be2\u6240\u6709 \u5f53\u524d\u90e8\u95e8\u89d2\u8272\u3002")
    @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)
    @GetMapping(value={"/currentunit"})
    @WrapUpResponseBody
    public PageQueryResult<RoleInfo> listUnitAndPublicRole(PageDesc pageDesc, HttpServletRequest request) {
        String currentUnit = WebOptUtils.getCurrentUnitCode((HttpServletRequest)request);
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("publicUnitRole", currentUnit);
        List roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)roleInfos, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u67d0\u90e8\u95e8\u7684\u90e8\u95e8\u89d2\u8272", notes="\u67e5\u8be2\u6240\u6709\u67d0\u90e8\u95e8\u7684\u90e8\u95e8\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="String"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/item"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<RoleInfo> listItemRole(String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("ROLETYPE", "I");
        List roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)roleInfos, (PageDesc)pageDesc, (String[])field);
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u89d2\u8272\u64cd\u4f5c\u5b9a\u4e49\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u89d2\u8272\u64cd\u4f5c\u5b9a\u4e49\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/power/role/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<RolePower> getRolePowerByRoleCode(@PathVariable String roleCode) {
        return this.sysRoleManager.getRolePowers(roleCode);
    }

    @ApiOperation(value="\u6839\u636e\u64cd\u4f5c\u5b9a\u4e49\u4ee3\u7801\u83b7\u53d6\u89d2\u8272\u4fe1\u606f", notes="\u6839\u636e\u64cd\u4f5c\u5b9a\u4e49\u4ee3\u7801\u83b7\u53d6\u89d2\u8272\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="defCode", value="\u64cd\u4f5c\u5b9a\u4e49\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/power/defCode/{defCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<RolePower> getRolePowerByOptCode(@PathVariable String defCode) {
        return this.sysRoleManager.getRolePowersByDefCode(defCode);
    }

    @ApiOperation(value="\u6839\u636e\u64cd\u4f5c\u5b9a\u4e49\u4ee3\u7801\u83b7\u53d6\u89d2\u8272\u4fe1\u606f", notes="\u6839\u636e\u64cd\u4f5c\u5b9a\u4e49\u4ee3\u7801\u83b7\u53d6\u89d2\u8272\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u83dc\u5355\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/power/optCode/{optId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<Map<String, Object>> getRolePowerByOptId(@PathVariable String optId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List optDefs = this.optMethodManager.listOptMethodByOptID(optId);
        for (OptMethod def : optDefs) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            List rolePowers = this.sysRoleManager.getRolePowersByDefCode(def.getOptCode());
            temp.put("optDef", def);
            temp.put("rolePowers", rolePowers);
            result.add(temp);
        }
        return result;
    }

    @ApiOperation(value="\u521b\u5efa\u7cfb\u7edf\u89d2\u8272", notes="\u521b\u5efa\u7cfb\u7edf\u89d2\u8272\u3002")
    @ApiImplicitParam(name="roleInfo", value="json\u683c\u5f0f\uff0c\u7cfb\u7edf\u89d2\u8272\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=RoleInfo.class)
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u89d2\u8272", tag="{ri.roleCode}")
    @WrapUpResponseBody
    public void createRole(@ParamName(value="ri") @Valid RoleInfo roleInfo, HttpServletRequest request) {
        String roleType = roleInfo.getRoleType();
        if (StringUtils.isBlank((CharSequence)roleType)) {
            throw new ObjectException((Object)roleInfo, "\u65b0\u5efa\u89d2\u8272\u5fc5\u987b\u6307\u5b9a\u89d2\u8272\u7c7b\u522b\u3002");
        }
        if ("D".equals(roleType) || "S".equals(roleType)) {
            throw new ObjectException((Object)roleInfo, "\u4e0d\u80fd\u7528\u8fd9\u4e2a\u63a5\u53e3\u521b\u5efa \u5b50\u7cfb\u7edf\u89d2\u8272\u6216\u8005\u673a\u6784\u89d2\u8272");
        }
        roleInfo.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        roleInfo.setCreateDate(new Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @ApiOperation(value="\u521b\u5efa\u90e8\u95e8\u89d2\u8272", notes="\u521b\u5efa\u90e8\u95e8\u89d2\u8272\u3002")
    @ApiImplicitParam(name="roleInfo", value="json\u683c\u5f0f\uff0c\u7cfb\u7edf\u89d2\u8272\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=RoleInfo.class)
    @RequestMapping(value={"/departmentRole"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u89d2\u8272", tag="{ri.roleCode}")
    @WrapUpResponseBody
    public void createDepartmentRole(@ParamName(value="ri") @Valid RoleInfo roleInfo, HttpServletRequest request) {
        roleInfo.setRoleType("D");
        if (StringUtils.isBlank((CharSequence)roleInfo.getUnitCode())) {
            roleInfo.setRoleOwner(WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
        }
        roleInfo.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        roleInfo.setCreateDate(new Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @ApiOperation(value="\u521b\u5efa\u5b50\u7cfb\u7edf\u89d2\u8272", notes="\u521b\u5efa\u5b50\u7cfb\u7edf\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleInfo", value="json\u683c\u5f0f\uff0c\u7cfb\u7edf\u89d2\u8272\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=RoleInfo.class), @ApiImplicitParam(name="topOptId", value="\u5b50\u7cfb\u7edf\u4ee3\u7801\uff0c\u4e3a\u7cfb\u7edf\u9876\u7ea7\u83dc\u5355\u7f16\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/subSysRole/{topOptId}"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u89d2\u8272", tag="{topOptId}:{ri.roleCode}")
    @WrapUpResponseBody
    public void createSubSystemRole(@ParamName(value="topOptId") @PathVariable String topOptId, @ParamName(value="ri") @Valid RoleInfo roleInfo, HttpServletRequest request) {
        roleInfo.setRoleType("S");
        roleInfo.setRoleOwner(topOptId);
        roleInfo.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        roleInfo.setCreateDate(new Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @ApiOperation(value="\u4ece\u64cd\u4f5c\u5b9a\u4e49\u53cd\u5411\u6dfb\u52a0\u89d2\u8272\u4ee3\u7801", notes="\u4ece\u64cd\u4f5c\u5b9a\u4e49\u53cd\u5411\u6dfb\u52a0\u89d2\u8272\u4ee3\u7801\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optCode", value="\u64cd\u4f5c\u5b9a\u4e49", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/addopt/{roleCode}/{optCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u7ed9\u89d2\u8272\u6dfb\u52a0\u6743\u9650", tag="{roleCode}:{optCode}")
    @WrapUpResponseBody
    public void addOptToRole(@ParamName(value="roleCode") @PathVariable String roleCode, @ParamName(value="optCode") @PathVariable String optCode) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            throw new ObjectException((Object)(roleCode + ":" + optCode), "\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RolePower rolePower = new RolePower(new RolePowerId(roleCode, optCode));
        if (dbRoleInfo.getRolePowers().contains(rolePower)) {
            return;
        }
        dbRoleInfo.getRolePowers().add(rolePower);
        this.sysRoleManager.updateRoleInfo(dbRoleInfo);
        CodeRepositoryCache.evictCache((String)"RolePower");
    }

    @ApiOperation(value="\u4ece\u64cd\u4f5c\u5b9a\u4e49\u53cd\u5411\u5220\u9664\u89d2\u8272\u4ee3\u7801", notes="\u4ece\u64cd\u4f5c\u5b9a\u4e49\u53cd\u5411\u5220\u9664\u89d2\u8272\u4ee3\u7801\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optCode", value="\u64cd\u4f5c\u5b9a\u4e49", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/delopt/{roleCode}/{optCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u89d2\u8272\u6743\u9650", tag="{roleCode}:{optCode}")
    @WrapUpResponseBody
    public void deleteOptFormRole(@ParamName(value="roleCode") @PathVariable String roleCode, @ParamName(value="optCode") @PathVariable String optCode) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            throw new ObjectException((Object)(roleCode + ":" + optCode), "\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RolePower rolePower = new RolePower(new RolePowerId(roleCode, optCode));
        if (!dbRoleInfo.getRolePowers().contains(rolePower)) {
            return;
        }
        dbRoleInfo.getRolePowers().remove(rolePower);
        this.sysRoleManager.updateRoleInfo(dbRoleInfo);
        CodeRepositoryCache.evictCache((String)"RolePower");
    }

    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u89d2\u8272", notes="\u66f4\u65b0\u7cfb\u7edf\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleInfo", value="json\u683c\u5f0f\uff0c\u89d2\u8272\u4fee\u6539\u7684\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="path", dataTypeClass=RoleInfo.class)})
    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u89d2\u8272", tag="{roleCode}")
    @WrapUpResponseBody
    public void updateRole(@ParamName(value="roleCode") @PathVariable String roleCode, @Valid RoleInfo roleInfo) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            throw new ObjectException((Object)roleInfo, "\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        roleInfo.setRoleCode(roleCode);
        this.sysRoleManager.updateRoleInfo(roleInfo);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @ApiOperation(value="\u66f4\u65b0\u673a\u6784\u89d2\u8272", notes="\u66f4\u65b0\u673a\u6784\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleInfo", value="json\u683c\u5f0f\uff0c\u89d2\u8272\u4fee\u6539\u7684\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="path", dataTypeClass=RoleInfo.class)})
    @RequestMapping(value={"/departmentRole/{roleCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u89d2\u8272", tag="{roleCode}")
    @WrapUpResponseBody
    public void updateDepartmentRole(@ParamName(value="roleCode") @PathVariable String roleCode, @Valid RoleInfo roleInfo, HttpServletRequest request) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            throw new ObjectException((Object)roleInfo, "\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        roleInfo.setRoleType("D");
        roleInfo.setRoleOwner(WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
        if (!StringUtils.equals((CharSequence)dbRoleInfo.getRoleOwner(), (CharSequence)roleInfo.getRoleOwner())) {
            throw new ObjectException((Object)roleInfo, "\u4e0d\u80fd\u4fee\u6539\u90e8\u95e8\u89d2\u8272\u7684\u6240\u5c5e\u673a\u6784");
        }
        roleInfo.setRoleCode(roleCode);
        this.sysRoleManager.updateRoleInfo(roleInfo);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u89d2\u8272", notes="\u66f4\u65b0\u7cfb\u7edf\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="topOptId", value="\u5b50\u7cfb\u7edf\u4ee3\u7801\uff0c\u4e3a\u7cfb\u7edf\u9876\u7ea7\u83dc\u5355\u7f16\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleInfo", value="json\u683c\u5f0f\uff0c\u89d2\u8272\u4fee\u6539\u7684\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="path", dataTypeClass=RoleInfo.class)})
    @RequestMapping(value={"/subSysRole/{topOptId}/{roleCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u89d2\u8272", tag="{topOptId}:{roleCode}")
    @WrapUpResponseBody
    public void updateSubSystemRole(@ParamName(value="topOptId") @PathVariable String topOptId, @ParamName(value="roleCode") @PathVariable String roleCode, @Valid RoleInfo roleInfo) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            throw new ObjectException((Object)roleInfo, "\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        roleInfo.setRoleType("S");
        roleInfo.setRoleOwner(topOptId);
        if (!StringUtils.equals((CharSequence)dbRoleInfo.getRoleOwner(), (CharSequence)topOptId)) {
            throw new ObjectException((Object)roleInfo, "\u4e0d\u80fd\u4fee\u6539\u5b50\u7cfb\u7edf\u89d2\u8272\u7684\u5f52\u5c5e\u7cfb\u7edf");
        }
        roleInfo.setRoleCode(roleCode);
        this.sysRoleManager.updateRoleInfo(roleInfo);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u89d2\u8272\u6743\u9650", notes="\u66f4\u65b0\u7cfb\u7edf\u89d2\u8272\u6743\u9650\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleInfo", value="json\u683c\u5f0f\uff0c\u542b\u6709\u7cfb\u7edf\u89d2\u8272\u6743\u9650\u7684\u89d2\u8272\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="path", dataTypeClass=RoleInfo.class)})
    @RequestMapping(value={"/power/{roleCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u89d2\u8272\u6743\u9650", tag="{roleCode}")
    @WrapUpResponseBody
    public void updateRolePower(@ParamName(value="roleCode") @PathVariable String roleCode, RoleInfo roleInfo) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            throw new ObjectException((Object)roleInfo, "\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        this.sysRoleManager.updateRolePower(roleInfo);
        CodeRepositoryCache.evictCache((String)"RolePower");
    }

    @ApiOperation(value="\u65b0\u589e\u5224\u65ad\u89d2\u8272\u540d\u79f0\u662f\u5426\u5b58\u5728", notes="\u65b0\u589e\u7cfb\u7edf\u89d2\u8272 \u5224\u65ad\u540d\u79f0\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=true, paramType="path", dataType="String")
    @GetMapping(value={"/issysroleunique/{roleName}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isSysRoleNotExist(@PathVariable String roleName) {
        return this.sysRoleManager.judgeSysRoleNameCanBeUsed(roleName, null, null);
    }

    @ApiOperation(value="\u66f4\u65b0\u5224\u65ad\u89d2\u8272\u540d\u79f0\u662f\u5426\u5b58\u5728", notes="\u66f4\u65b0\u7cfb\u7edf\u89d2\u8272 \u5224\u65ad\u540d\u79f0\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @GetMapping(value={"/issysroleunique/{roleName}/{roleCode}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isSysRoleUnique(@PathVariable String roleName, @PathVariable String roleCode) {
        return this.sysRoleManager.judgeSysRoleNameCanBeUsed(roleName, roleCode, null);
    }

    @ApiOperation(value="\u65b0\u589e\u90e8\u95e8\u89d2\u8272 \u5224\u65ad\u540d\u79f0\u662f\u5426\u5b58\u5728", notes="\u65b0\u589e\u90e8\u95e8\u89d2\u8272 \u5224\u65ad\u540d\u79f0\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=true, paramType="path", dataType="String")})
    @GetMapping(value={"/isunitroleunique/{unitCode}/{roleName}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isUnitRoleNotExist(@PathVariable String unitCode, @PathVariable String roleName) {
        return this.sysRoleManager.judgeSysRoleNameCanBeUsed(roleName, null, unitCode);
    }

    @ApiOperation(value="\u66f4\u65b0\u90e8\u95e8\u89d2\u8272 \u5224\u65ad\u540d\u79f0\u662f\u5426\u5b58\u5728", notes="\u66f4\u65b0\u90e8\u95e8\u89d2\u8272 \u5224\u65ad\u540d\u79f0\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @GetMapping(value={"/isunitroleunique/{unitCode}/{roleName}/{roleCode}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isUnitRoleUnique(@PathVariable String unitCode, @PathVariable String roleName, @PathVariable String roleCode) {
        return this.sysRoleManager.judgeSysRoleNameCanBeUsed(roleName, roleCode, unitCode);
    }

    @ApiOperation(value="\u4ece\u64cd\u4f5c\u5b9a\u4e49\u53cd\u5411\u5220\u9664\u89d2\u8272\u4ee3\u7801", notes="\u4ece\u64cd\u4f5c\u5b9a\u4e49\u53cd\u5411\u5220\u9664\u89d2\u8272\u4ee3\u7801\u3002")
    @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u89d2\u8272", tag="{roleCode}")
    @WrapUpResponseBody
    public ResponseData deleteRole(@ParamName(value="roleCode") @PathVariable String roleCode) {
        if (StringUtils.equalsAny((CharSequence)roleCode, (CharSequence[])new CharSequence[]{"public", "anonymous", "forbidden"})) {
            return ResponseData.makeErrorMessage((String)"\u7cfb\u7edf\u5185\u7f6e\u89d2\u8272\u4e0d\u80fd\u5220\u9664\u3002");
        }
        List users = this.sysUserRoleManager.listUsersByRole(roleCode);
        boolean isValid = true;
        for (UserInfo u : users) {
            if ("T".equals(u.getIsValid())) {
                return ResponseData.makeErrorMessage((String)"\u6709\u7528\u6237\u5f15\u7528\u8fd9\u4e2a\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
            }
            isValid = false;
        }
        if (!isValid) {
            return ResponseData.makeErrorMessage((String)"\u6709\u7981\u7528\u7528\u6237\u5f15\u7528\u8fd9\u4e2a\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
        JSONArray roleUnts = this.sysUnitRoleManager.listRoleUnits(roleCode, new PageDesc(1, 2));
        if (roleUnts != null && roleUnts.size() > 0) {
            return ResponseData.makeErrorMessage((String)"\u6709\u673a\u6784\u5f15\u7528\u8fd9\u4e2a\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
        this.sysRoleManager.deleteRoleInfo(roleCode);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u89d2\u8272\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272\u4ee3\u7801\u83b7\u53d6\u5355\u4e2a\u89d2\u8272\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public RoleInfo findRoleInfo(@PathVariable String roleCode) {
        return this.sysRoleManager.getRoleInfo(roleCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u6743\u9650", notes="\u6839\u636e\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u673a\u6784\u6743\u9650\u3002")
    @ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/power/unit/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUnitInfoPower(@PathVariable String unitCode) {
        List rolePowers = this.sysRoleManager.getRolePowers("G$" + unitCode);
        return ResponseData.makeResponseData((Object)rolePowers);
    }

    @ApiOperation(value="\u5bf9\u89d2\u8272\u4fe1\u606f\u8fdb\u884c\u6a21\u7cca\u641c\u7d22", notes="\u5bf9\u89d2\u8272\u4fe1\u606f\u8fdb\u884c\u6a21\u7cca\u641c\u7d22\uff0c\u9002\u7528\u4e8e\u5e26\u641c\u7d22\u6761\u4ef6\u7684\u4e0b\u62c9\u6846\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u641c\u7d22\u6761\u4ef6", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="field", value="\u9700\u8981\u641c\u7d22\u7684\u5b57\u6bb5\uff0c\u5982\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\uff0croleCode,roleName", allowMultiple=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/listRoles/{type}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONArray listRoles(@PathVariable String type, String owner, String[] field, HttpServletRequest request) {
        IUserUnit unit;
        if (ArrayUtils.isEmpty((Object[])field)) {
            field = new String[]{"roleCode", "roleName"};
        }
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("isValid", "T");
        filterMap.put("roleType", type);
        if ("D".equals(type) && StringUtils.isBlank((CharSequence)owner) && (unit = CodeRepositoryUtil.getUserPrimaryUnit((String)WebOptUtils.getCurrentUserCode((HttpServletRequest)request))) != null) {
            owner = unit.getUnitCode();
        }
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            filterMap.put("unitCode", owner);
        }
        List listObjects = this.sysRoleManager.listObjects(filterMap);
        return DictionaryMapUtils.objectsToJSONArray((Collection)listObjects, (String[])field);
    }
}

