/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.support.algorithm.DatetimeOpt;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CheckFailLogs {
    private static int checkTimeTnterval = 3;
    private static int maxTryTimes = -1;
    private static char checkType = (char)76;
    private static int lockMinites = 5;
    private static Map<String, CheckFailLog> failLogs = new HashMap<String, CheckFailLog>();

    public static void setMaxTryTimes(int maxTryTimes) {
        CheckFailLogs.maxTryTimes = maxTryTimes;
    }

    public static int getMaxTryTimes() {
        return maxTryTimes;
    }

    public static void setCheckType(String checkType) {
        CheckFailLogs.checkType = (char)("H".equalsIgnoreCase(checkType) || "hostIp".equalsIgnoreCase(checkType) || "ip".equalsIgnoreCase(checkType) || "host".equalsIgnoreCase(checkType) ? 72 : 76);
    }

    public static char getCheckType() {
        return checkType;
    }

    public static void setLockMinites(int lockMinites) {
        CheckFailLogs.lockMinites = lockMinites;
    }

    public static void setCheckTimeTnterval(int checkTimeTnterval) {
        CheckFailLogs.checkTimeTnterval = checkTimeTnterval;
    }

    public static String getCheckKey(HttpServletRequest request) {
        String checkKey = CheckFailLogs.getCheckType() == 'L' ? request.getParameter("username") : request.getRemoteHost() + ":" + request.getRemotePort();
        return checkKey;
    }

    public static void removeCheckFail(HttpServletRequest request) {
        failLogs.remove(CheckFailLogs.getCheckKey(request));
    }

    public static void plusCheckFail(HttpServletRequest request) {
        String checkKey = CheckFailLogs.getCheckKey(request);
        CheckFailLog failLog = failLogs.get(checkKey);
        if (failLog != null) {
            failLog.plusCheckFail();
        } else {
            failLog = new CheckFailLog();
        }
        failLogs.put(checkKey, failLog);
    }

    public static boolean isLocked(HttpServletRequest request) {
        CheckFailLog failLog = failLogs.get(CheckFailLogs.getCheckKey(request));
        return failLog != null && failLog.isLocked();
    }

    public static int getHasTriedTimes(HttpServletRequest request) {
        CheckFailLog failLog = failLogs.get(CheckFailLogs.getCheckKey(request));
        return failLog == null ? 0 : failLog.fetchTryTimes();
    }

    public static class CheckFailLog {
        private int tryTimes = 1;
        private Date lastCheckTime = DatetimeOpt.currentUtilDate();

        public int fetchTryTimes() {
            Date currentDate = DatetimeOpt.currentUtilDate();
            if (DatetimeOpt.addMinutes((Date)this.lastCheckTime, (int)checkTimeTnterval).before(currentDate)) {
                this.tryTimes = 0;
            }
            return this.tryTimes;
        }

        public Date getLastCheckTime() {
            return this.lastCheckTime;
        }

        public void plusCheckFail() {
            Date currentDate = DatetimeOpt.currentUtilDate();
            this.tryTimes = DatetimeOpt.addMinutes((Date)this.lastCheckTime, (int)checkTimeTnterval).before(currentDate) ? 1 : ++this.tryTimes;
            this.lastCheckTime = currentDate;
        }

        public boolean isLocked() {
            Date currentDate = DatetimeOpt.currentUtilDate();
            if (DatetimeOpt.addMinutes((Date)this.lastCheckTime, (int)lockMinites).before(currentDate)) {
                return false;
            }
            return this.tryTimes >= maxTryTimes;
        }
    }
}

