/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.framework.common.WebOptUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class AjaxAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private AuthenticationEntryPoint browse;
    private AuthenticationEntryPoint api = new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED);

    public AjaxAuthenticationEntryPoint(String loginFormUrl) {
        this.browse = new LoginUrlAuthenticationEntryPoint(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (WebOptUtils.isAjax((HttpServletRequest)request)) {
            if (WebOptUtils.exceptionNotAsHttpError) {
                ResponseSingleData responseData = new ResponseSingleData(401, "\u672a\u767b\u5f55\uff01");
                JsonResultUtils.writeResponseDataAsJson((ResponseData)responseData, (HttpServletResponse)response);
            } else {
                this.api.commence(request, response, authException);
            }
        } else {
            this.browse.commence(request, response, authException);
        }
    }
}

