/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IDataCatalog;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.model.basedata.IOptInfo;
import com.centit.framework.model.basedata.IRoleInfo;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUnitRole;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserRole;
import com.centit.framework.model.basedata.IUserSetting;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.framework.security.model.CentitSecurityMetadata;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.OptDataScope;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.OsInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.service.OptInfoManager;
import com.centit.framework.system.service.OsInfoManager;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/platform"})
@Api(tags={"\u7cfb\u7edf\u6570\u636e\u670d\u52a1\u63a5\u53e3"}, value="\u7cfb\u7edf\u6570\u636e\u670d\u52a1\u63a5\u53e3")
public class PlatformDataController
extends BaseController {
    @Autowired
    private UserSettingManager userSettingManager;
    @Autowired
    private SysRoleManager sysRoleManager;
    @Autowired
    protected PlatformEnvironment platformEnvironment;
    @Autowired
    private SysUserManager sysUserManager;
    @Autowired
    protected OsInfoManager osInfoManager;
    @Autowired
    protected OptInfoManager optInfoManager;

    @RequestMapping
    @WrapUpResponseBody
    public String apiInfo() {
        return "This the apis for platform data.";
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f", notes="\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userInfo", value="json\u683c\u5f0f\uff0c\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=UserInfo.class)
    @RequestMapping(value={"/userinfo"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public void updateUserInfo(@RequestBody UserInfo userInfo) {
        UserInfo dbUserInfo = this.sysUserManager.getObjectById(userInfo.getUserCode());
        if (null == dbUserInfo) {
            throw new ObjectException((Object)userInfo, 404, "\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String primaryUnit = dbUserInfo.getPrimaryUnit();
        userInfo.setPrimaryUnit(primaryUnit);
        this.sysUserManager.updateUserInfo(userInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u67d0\u4e2a\u4e1a\u52a1\u76f8\u5173\u7684\u6240\u4ee5\u7528\u6237\u8bbe\u7f6e", notes="\u83b7\u53d6\u7528\u6237\u67d0\u4e2a\u4e1a\u52a1\u76f8\u5173\u7684\u6240\u4ee5\u7528\u6237\u8bbe\u7f6e\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optID", value="\u4e1a\u52a1ID", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/usersettings/{userCode}/{optID}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<UserSetting> getUserAllSettings(@PathVariable String optID, @PathVariable String userCode) {
        return this.userSettingManager.getUserSettings(userCode, optID);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8bbe\u7f6e", notes="\u6839\u636e\u7528\u6237\u4ee3\u7801\u548c\u53c2\u6570\u4ee3\u7801\u83b7\u53d6\u7528\u6237\u8bbe\u7f6e\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="paramCode", value="\u8bbe\u7f6e\u7f16\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/usersetting/{userCode}/{paramCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public UserSetting getUserSetting(@PathVariable String userCode, @PathVariable String paramCode) {
        return this.userSettingManager.getUserSetting(userCode, paramCode);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7528\u6237\u8bbe\u7f6e", notes="\u8bbe\u7f6e\u7528\u6237\u8bbe\u7f6e\u3002")
    @ApiImplicitParam(name="settingJson", value="json\u683c\u5f0f\uff0c\u7528\u6237\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataType="String")
    @RequestMapping(value={"/usersetting"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public void setUserSetting(@RequestBody String settingJson) {
        UserSetting us = (UserSetting)JSON.parseObject((String)settingJson, UserSetting.class);
        if (us == null) {
            throw new ObjectException(302, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff01");
        }
        this.platformEnvironment.saveUserSetting((IUserSetting)us);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u4e1a\u52a1\u83dc\u5355\u91cc\u7684\u6240\u6709\u64cd\u4f5c\u65b9\u6cd5", notes="\u83b7\u53d6\u7528\u6237\u7684\u4e1a\u52a1\u83dc\u5355\u91cc\u7684\u6240\u6709\u64cd\u4f5c\u65b9\u6cd5\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optid", value="\u4e1a\u52a1\u83dc\u5355ID", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="asAdmin", value="\u662f\u5426\u4e3a\u7ba1\u7406\u5458", paramType="query", dataType="Boolean")})
    @RequestMapping(value={"/usermenu/{optid}/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IOptInfo> listUserMenuOptInfos(@PathVariable String optid, @PathVariable String userCode, boolean asAdmin) {
        if (StringUtils.isBlank((CharSequence)optid) || "null".equals(optid)) {
            return this.platformEnvironment.listUserMenuOptInfos(userCode, asAdmin);
        }
        return this.platformEnvironment.listUserMenuOptInfosUnderSuperOptId(userCode, optid, asAdmin);
    }

    @ApiOperation(value="\u6821\u9a8c\u7528\u6237\u5bc6\u7801", notes="\u6821\u9a8c\u7528\u6237\u5bc6\u7801\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="jsonData", value="json\u5b57\u7b26\u4e32 \u91cc\u9762\u7684key\u5fc5\u987b\u6709password", required=true, paramType="body", dataType="String")})
    @RequestMapping(value={"/checkpassword/{userCode}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public boolean checkUserPassword(@PathVariable String userCode, @RequestBody String jsonData) {
        JSONObject json = (JSONObject)JSON.parse((String)jsonData);
        String password = StringBaseOpt.objectToString((Object)json.get((Object)"password"));
        return this.platformEnvironment.checkUserPassword(userCode, password);
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801", notes="\u4fee\u6539\u7528\u6237\u5bc6\u7801\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="jsonData", value="json\u5b57\u7b26\u4e32 \u91cc\u9762\u7684key\u5fc5\u987b\u6709newPassword", required=true, paramType="body", dataType="String")})
    @RequestMapping(value={"/changepassword/{userCode}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public void changeUserPassword(@PathVariable String userCode, @RequestBody String jsonData) {
        JSONObject json = (JSONObject)JSON.parse((String)jsonData);
        String newPassword = StringBaseOpt.objectToString((Object)json.get((Object)"newPassword"));
        this.platformEnvironment.changeUserPassword(userCode, newPassword);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u7528\u6237", notes="\u83b7\u53d6\u6240\u6709\u7684\u7528\u6237\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/allusers/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserInfo> listAllUsers(@PathVariable String appName) {
        return this.platformEnvironment.listAllUsers();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u673a\u6784", notes="\u83b7\u53d6\u6240\u6709\u7684\u673a\u6784\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/allunits/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUnitInfo> listAllUnits(@PathVariable String appName) {
        return this.platformEnvironment.listAllUnits();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u7528\u6237\u673a\u6784\u5173\u7cfb", notes="\u83b7\u53d6\u6240\u6709\u7684\u7528\u6237\u673a\u6784\u5173\u7cfb\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/alluserunits/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserUnit> listAllUserUnits(@PathVariable String appName) {
        return this.platformEnvironment.listAllUserUnits();
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u4ee5\u5728\u7684\u673a\u6784", notes="\u83b7\u53d6\u7528\u6237\u6240\u4ee5\u5728\u7684\u673a\u6784\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/userunits/{appName}/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserUnit> listUserUnits(@PathVariable String appName, @PathVariable String userCode) {
        return this.platformEnvironment.listUserUnits(userCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u4e0b\u7684\u6240\u6709\u7528\u6237", notes="\u83b7\u53d6\u673a\u6784\u4e0b\u7684\u6240\u6709\u7528\u6237\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/unitusers/{appName}/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserUnit> listUnitUsers(@PathVariable String appName, @PathVariable String unitCode) {
        return this.platformEnvironment.listUnitUsers(unitCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u673a\u6784", notes="\u83b7\u53d6\u6240\u6709\u7684\u673a\u6784\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/unitrepo/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUnitInfo> getUnitRepo(@PathVariable String appName) {
        return this.platformEnvironment.listAllUnits();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u7528\u6237", notes="\u83b7\u53d6\u6240\u6709\u7684\u7528\u6237\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/userrepo/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserInfo> getUserRepo(@PathVariable String appName) {
        return this.platformEnvironment.listAllUsers();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u89d2\u8272", notes="\u83b7\u53d6\u6240\u6709\u7684\u89d2\u8272\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/rolerepo/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IRoleInfo> getRoleRepo(@PathVariable String appName) {
        return this.platformEnvironment.listAllRoleInfo();
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e0b\u7684\u6240\u6709\u89d2\u8272", notes="\u83b7\u53d6\u7528\u6237\u4e0b\u7684\u6240\u6709\u89d2\u8272\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/userroles/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserRole> listUserRoles(@PathVariable String userCode) {
        return this.platformEnvironment.listUserRoles(userCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e0b\u7684\u6240\u6709\u89d2\u8272", notes="\u83b7\u53d6\u7528\u6237\u4e0b\u7684\u6240\u6709\u89d2\u8272\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="accessUrl", value="\u7528\u6237\u8bbf\u95eeUrl", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/checkuserpower/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public boolean checkUserAccessPower(@PathVariable String userCode, String accessUrl, HttpServletRequest request) {
        List userRoles = this.platformEnvironment.listUserRoles(userCode);
        List needRoles = CentitSecurityMetadata.matchUrlToRole((String)accessUrl, (HttpServletRequest)request);
        if (userRoles == null || needRoles == null) {
            return false;
        }
        for (ConfigAttribute attr : needRoles) {
            for (IUserRole role : userRoles) {
                if (!StringUtils.equals((CharSequence)("R_" + role.getRoleCode()), (CharSequence)attr.getAttribute())) continue;
                return true;
            }
        }
        return false;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u6240\u6709\u7528\u6237", notes="\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u6240\u6709\u7528\u6237\u3002")
    @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/roleusers/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserRole> listRoleUsers(@PathVariable String roleCode) {
        return this.platformEnvironment.listRoleUsers(roleCode);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u83b7\u53d6\u7528\u6237\u548c\u89d2\u8272\u7684\u5173\u8054\u5173\u7cfb", notes="\u6839\u636e\u7528\u6237\u83b7\u53d6\u7528\u6237\u548c\u89d2\u8272\u7684\u5173\u8054\u5173\u7cfb\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/userroleinfos/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUserRole> listUserRoleInfos(@PathVariable String userCode) {
        return this.platformEnvironment.listUserRoles(userCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u4e0b\u7684\u6240\u6709\u89d2\u8272", notes="\u83b7\u53d6\u673a\u6784\u4e0b\u7684\u6240\u6709\u89d2\u8272\u3002")
    @ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/unitroles/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUnitRole> listUnitRoles(@PathVariable String unitCode) {
        return this.platformEnvironment.listUnitRoles(unitCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u6240\u6709\u673a\u6784", notes="\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u6240\u6709\u673a\u6784\u3002")
    @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/roleunits/{roleCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUnitRole> listRoleUnits(@PathVariable String roleCode) {
        return this.platformEnvironment.listRoleUnits(roleCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u83dc\u5355", notes="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u83dc\u5355\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/optinforepo/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IOptInfo> getOptInfoRepo(@PathVariable String appName) {
        return this.platformEnvironment.listAllOptInfo();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u5b57\u5178\u7c7b\u578b", notes="\u83b7\u53d6\u6240\u6709\u7684\u5b57\u5178\u7c7b\u578b\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/catalogs/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IDataCatalog> listAllDataCatalogs(@PathVariable String appName) {
        return this.platformEnvironment.listAllDataCatalogs();
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u4ee3\u7801\u4e0b\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6", notes="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u4ee3\u7801\u4e0b\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="catalogCode", value="\u5b57\u5178\u7c7b\u578b\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/dictionary/{appName}/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IDataDictionary> listDataDictionaries(@PathVariable String appName, @PathVariable String catalogCode) {
        return this.platformEnvironment.listDataDictionaries(catalogCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u89d2\u8272\u6743\u9650", notes="\u83b7\u53d6\u6240\u6709\u89d2\u8272\u6743\u9650\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/allrolepowers/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<RolePower> listAllRolePower(@PathVariable String appName) {
        return this.sysRoleManager.listAllRolePowers();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u64cd\u4f5c\u65b9\u6cd5", notes="\u83b7\u53d6\u6240\u6709\u64cd\u4f5c\u65b9\u6cd5\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/alloptmethods/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<OptMethod> listAllOptMethod(@PathVariable String appName) {
        return this.sysRoleManager.listAllOptMethods();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u64cd\u4f5c\u6570\u636e\u8303\u56f4\u8bbe\u5b9a", notes="\u83b7\u53d6\u6240\u6709\u64cd\u4f5c\u6570\u636e\u8303\u56f4\u8bbe\u5b9a\u3002")
    @ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/alloptdatascopes/{appName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<OptDataScope> listAllOptDataScopes(@PathVariable String appName) {
        return this.optInfoManager.listAllDataScope();
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u4ee3\u7801\u4e0b\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6", notes="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u4ee3\u7801\u4e0b\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appName", value="\u5ba2\u6237\u7aef\u540d\u79f0\uff08\u6682\u65f6\u672a\u7528\u5230\u53ef\u968f\u610f\u4f20\u503c\uff09", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="queryParam", value="\u67e5\u8be2\u7c7b\u578b\u5bf9\u5e94\u7684\u503c", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="qtype", value="\u67e5\u8be2\u7c7b\u578b:loginName\u3001userCode\u3001regEmail\u3001regCellPhone \u4e0d\u4f20\u4e3a:loginName", paramType="query", dataType="String")})
    @RequestMapping(value={"/userdetails/{appName}/{queryParam}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseMapData loadUserDetails(@PathVariable String appName, @PathVariable String queryParam, String qtype) {
        if (qtype == null) {
            qtype = "loginName";
        }
        CentitUserDetails userDetails = null;
        switch (qtype) {
            case "loginName": {
                userDetails = this.platformEnvironment.loadUserDetailsByLoginName(queryParam);
                break;
            }
            case "userCode": {
                userDetails = this.platformEnvironment.loadUserDetailsByUserCode(queryParam);
                break;
            }
            case "regEmail": {
                userDetails = this.platformEnvironment.loadUserDetailsByRegEmail(queryParam);
                break;
            }
            case "regCellPhone": {
                userDetails = this.platformEnvironment.loadUserDetailsByRegCellPhone(queryParam);
                break;
            }
            default: {
                userDetails = this.platformEnvironment.loadUserDetailsByLoginName(queryParam);
            }
        }
        if (userDetails == null) {
            throw new ObjectException(101, "\u6ca1\u6709\u6307\u5b9a\u7684\u7528\u6237\uff1a" + qtype + "=" + queryParam);
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("userDetails", (Object)userDetails);
        resData.addResponseData("userUnits", (Object)userDetails.getUserUnits());
        return resData;
    }

    @ApiOperation(value="\u6240\u6709\u7684\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", notes="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u3002")
    @RequestMapping(value={"/ipenvironment/osinfo"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<OsInfo> listAllOS() {
        return this.osInfoManager.listObjects();
    }

    @ApiOperation(value="\u65b0\u589e\u83dc\u5355\u548c\u64cd\u4f5c", notes="\u65b0\u589e\u83dc\u5355\u548c\u64cd\u4f5c\u3002")
    @RequestMapping(value={"/insertopt"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void insertOpt(HttpServletRequest request) throws IOException {
        Map param = (Map)JSON.parseObject((InputStream)request.getInputStream(), Map.class, (Feature[])new Feature[0]);
        List optInfos = JSON.parseArray((String)param.get("optInfos").toString(), OptInfo.class);
        List optMethods = JSON.parseArray((String)param.get("optMethods").toString(), OptMethod.class);
        this.platformEnvironment.insertOrUpdateMenu(optInfos, optMethods);
    }
}

