/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.protocol.router;

import com.centit.cmip.sdk.protocol.handler.BaseHandler;
import com.centit.cmip.sdk.protocol.handler.DownloadHandler;
import com.centit.cmip.sdk.protocol.handler.GeneralHandler;
import com.centit.cmip.sdk.protocol.handler.UploadHandler;
import com.centit.cmip.sdk.protocol.router.RequestModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;

public class RequestRouter {
    private List<BaseHandler> baseHandlers = new ArrayList<BaseHandler>();
    private Map<String, BaseHandler> request2Handlers = new ConcurrentHashMap<String, BaseHandler>();
    private static RequestRouter requestRouter;

    public static RequestRouter getInstance() {
        if (null == requestRouter) {
            requestRouter = new RequestRouter();
        }
        return requestRouter;
    }

    public RequestRouter() {
        this.baseHandlers.add(new GeneralHandler());
        this.baseHandlers.add(new DownloadHandler());
        this.baseHandlers.add(new UploadHandler());
    }

    public void route(RequestModel model) throws ServletException, IOException {
        String requestType = model.getJsonObj().getString("requestType");
        BaseHandler handler = this.getHandler(requestType);
        if (null != handler) {
            handler.process(model.getRequest(), model.getResponse());
        }
    }

    private BaseHandler getHandler(String requestType) {
        BaseHandler handler = this.request2Handlers.get(requestType);
        if (handler == null) {
            for (BaseHandler handlerCandidate : this.baseHandlers) {
                if (!requestType.equalsIgnoreCase(handlerCandidate.getRequestType())) continue;
                handler = handlerCandidate;
                this.request2Handlers.put(requestType, handler);
                break;
            }
        }
        return handler;
    }
}

