/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.velocity;

import com.baomidou.framework.common.SwConstants;
import com.baomidou.framework.exception.SpringWindException;
import com.baomidou.framework.velocity.RunEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;

public class VelocityPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private String charset = SwConstants.UTF_8;
    private static VelocityContext velocityContext = null;
    private Resource[] locations;
    private RunEnvironment runEnvironment;

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource ... locations) {
        this.locations = locations;
    }

    public void fillMergeProperties(Properties prop, InputStream input) {
        try {
            StringWriter writer = new StringWriter();
            BufferedReader br = new BufferedReader(new InputStreamReader(input, this.getCharset()));
            if (velocityContext == null) {
                HashMap<Object, Object> context = new HashMap<Object, Object>();
                context.put("env", this.getRunEnvironment());
                context.putAll(System.getProperties());
                velocityContext = new VelocityContext(context);
            }
            Velocity.evaluate((Context)velocityContext, (Writer)writer, (String)"VelocityPropertyPlaceholderConfigurer", (Reader)br);
            prop.load(new StringReader(writer.toString()));
        }
        catch (Exception e) {
            throw new SpringWindException(e);
        }
    }

    protected void loadProperties(Properties props) throws IOException {
        if (this.locations != null && props != null) {
            for (Resource location : this.locations) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading properties file from " + location));
                }
                this.fillMergeProperties(props, location.getInputStream());
            }
        }
    }

    public RunEnvironment getRunEnvironment() {
        if (this.runEnvironment == null) {
            return new RunEnvironment();
        }
        return this.runEnvironment;
    }

    public void setRunEnvironment(RunEnvironment runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

