/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.quartz;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class QuartzJobManager {
    private static final String JOB_GROUP_NAME = "job_group";
    private static final String TRIGGER_GROUP_NAME = "trigger_group";
    private Logger logger = LoggerFactory.getLogger(QuartzJobManager.class);
    @Autowired
    private SchedulerFactoryBean schedulerFactory;

    public void addJob(String jobName, Class<? extends Job> jobClass, String cronExpression) throws ParseException, SchedulerException {
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass);
        jobBuilder.withIdentity(jobName, JOB_GROUP_NAME);
        JobDetail jobDetail = jobBuilder.build();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withIdentity(jobName, TRIGGER_GROUP_NAME);
        triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
        Trigger trigger = triggerBuilder.build();
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        scheduler.scheduleJob(jobDetail, trigger);
        if (!scheduler.isShutdown()) {
            scheduler.start();
        }
    }

    public void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String cronExpression) throws SchedulerException, ParseException {
        this.addJob(jobName, jobGroupName, triggerName, triggerGroupName, jobClass, cronExpression, null);
    }

    public void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String cronExpression, Map<String, Object> dataMap) throws SchedulerException, ParseException {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass);
        jobBuilder.withIdentity(jobName, jobGroupName);
        JobDetail jobDetail = jobBuilder.build();
        if (dataMap != null) {
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                jobDetail.getJobDataMap().put(entry.getKey(), entry.getValue());
            }
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withIdentity(triggerName, triggerGroupName);
        triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
        Trigger trigger = triggerBuilder.build();
        scheduler.scheduleJob(jobDetail, trigger);
        if (!scheduler.isShutdown()) {
            scheduler.start();
        }
    }

    public void modifyJobTime(String jobName, String cronExpression) throws SchedulerException, ParseException {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        Trigger trigger = scheduler.getTrigger(TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME));
        if (trigger != null) {
            CronTriggerImpl ct = (CronTriggerImpl)trigger;
            ct.setCronExpression(cronExpression);
            scheduler.resumeTrigger(TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME));
        }
    }

    public void modifyJobTime(String triggerName, String triggerGroupName, String cronExpression) throws SchedulerException, ParseException {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        Trigger trigger = scheduler.getTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName));
        if (trigger != null) {
            CronTriggerImpl ct = (CronTriggerImpl)trigger;
            ct.setCronExpression(cronExpression);
            scheduler.rescheduleJob(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName), (Trigger)ct);
        }
    }

    public void modifyJobTime(String triggerName, String triggerGroupName, Date startTime, Date endTime) throws SchedulerException {
        Trigger trigger = null;
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        try {
            trigger = scheduler.getTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName));
            scheduler.pauseTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName));
        }
        catch (SchedulerException e) {
            this.logger.error("scheduler.getTrigger(triggerName, triggerGroupName) Exception: ", (Throwable)e);
        }
        if (trigger != null) {
            CronTriggerImpl ct = (CronTriggerImpl)trigger;
            ct.setStartTime(startTime);
            ct.setEndTime(endTime);
            try {
                scheduler.resumeTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName));
                scheduler.rescheduleJob(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName), (Trigger)ct);
            }
            catch (SchedulerException e) {
                this.logger.error("scheduler.resumeTrigger(triggerName, triggerGroupName) Exception: ", (Throwable)e);
                throw new SchedulerException();
            }
        }
    }

    public void removeJob(String jobName) throws SchedulerException {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        scheduler.pauseTrigger(TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME));
        scheduler.unscheduleJob(TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME));
        scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)JOB_GROUP_NAME));
    }

    public void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) throws SchedulerException {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        scheduler.pauseTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName));
        scheduler.unscheduleJob(TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName));
        scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
    }

    public boolean isJobAdded(String jobName, String jobGroupName) throws SchedulerException, ParseException {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(JobKey.jobKey((String)jobName, (String)jobGroupName));
        return jobDetail != null;
    }
}

