/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.mail;

import com.baomidou.framework.common.SwConstants;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.Model;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class MailHelper {
    protected Logger logger = LoggerFactory.getLogger(MailHelper.class);
    private VelocityEngine velocityEngine;
    private JavaMailSender mailSender;
    private String charset = SwConstants.UTF_8;
    private String mailTitle;
    private String mailFrom;

    public boolean sendMail(String to, String subject, String tplName, Model model) {
        return this.sendMail(to, subject, tplName, (Map<String, Object>)model.asMap());
    }

    public boolean sendMail(String[] to, String subject, String tplName, Model model) {
        return this.sendMail(to, subject, tplName, (Map<String, Object>)model.asMap());
    }

    public boolean sendMail(String to, String subject, String tplName, Map<String, Object> data) {
        return this.sendMail(new String[]{to}, subject, tplName, data);
    }

    public boolean sendMail(String[] to, String subject, String tplName, Map<String, Object> data) {
        return this.sendMail(this.mailTitle, this.mailFrom, to, subject, tplName, data);
    }

    public boolean sendMail(String personal, String from, String to, String subject, String tplName, Model model) {
        return this.sendMail(personal, from, new String[]{to}, subject, tplName, model.asMap());
    }

    public boolean sendMail(String personal, String from, String[] to, String subject, String tplName, Model model) {
        return this.sendMail(personal, from, to, subject, tplName, model.asMap());
    }

    public boolean sendMail(String personal, String from, String[] to, String subject, String tplName, Map<String, Object> data) {
        try {
            MimeMessage msg = this.mailSender.createMimeMessage();
            MimeMessageHelper msgHelper = new MimeMessageHelper(msg, this.getCharset());
            msgHelper.setFrom(from, personal);
            msgHelper.setTo(to);
            msgHelper.setSubject(subject);
            msgHelper.setText(this.getHtmltext(tplName, data), true);
            this.mailSender.send(msg);
            return true;
        }
        catch (Exception e) {
            this.logger.error("send mail error.", (Throwable)e);
            return false;
        }
    }

    public String getHtmltext(String tplName, Map<String, Object> data) {
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)tplName, (String)this.getCharset(), data);
    }

    public String getHtmltext(String tplName, Model model) {
        return this.getHtmltext(tplName, model.asMap());
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getMailTitle() {
        return this.mailTitle;
    }

    public void setMailTitle(String mailTitle) {
        this.mailTitle = mailTitle;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }
}

