/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil
extends DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final long MS = 1L;
    public static final long SECOND_MS = 1000L;
    public static final long MINUTE_MS = 60000L;
    public static final long HOUR_MS = 3600000L;
    public static final long DAY_MS = 86400000L;
    private static final SimpleDateFormat NORM_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat NORM_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat HTTP_DATETIME_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public static String now() {
        return DateUtil.formatDateTime(new Date());
    }

    public static String today() {
        return DateUtil.formatDate(new Date());
    }

    public static String format(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatDateTime(Date date) {
        return NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        return HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        return NORM_DATE_FORMAT.format(date);
    }

    public static Date parse(String dateString, String format) {
        try {
            return new SimpleDateFormat(format).parse(dateString);
        }
        catch (ParseException e) {
            logger.error("Parse " + dateString + " with format " + format + " error!", (Throwable)e);
            return null;
        }
    }

    public static Date parseDateTime(String dateString) {
        try {
            return NORM_DATETIME_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            logger.error("Parse " + dateString + " with format " + NORM_DATETIME_FORMAT.toPattern() + " error!", (Throwable)e);
            return null;
        }
    }

    public static Date parseDate(String dateString) {
        try {
            return NORM_DATE_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            logger.error("Parse " + dateString + " with format " + NORM_DATE_FORMAT.toPattern() + " error!", (Throwable)e);
            return null;
        }
    }

    public static Date getOffsiteDate(Date date, int calendarField, int offsite) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(calendarField, offsite);
        return cal.getTime();
    }

    public static long dateDiff(Date subtrahend, Date minuend, long diffField) {
        long diff = minuend.getTime() - subtrahend.getTime();
        return diff / diffField;
    }
}

