/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common;

import com.baomidou.framework.common.util.DateUtil;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScheduler
extends Timer {
    private static Logger logger = LoggerFactory.getLogger(TaskScheduler.class);

    public TaskScheduler(boolean isDeamon) {
        super(true);
    }

    public static TaskScheduler newInstance(boolean isDaemon) {
        return new TaskScheduler(isDaemon);
    }

    public void schedule(TimerTask timerTask, String startTime, long period) {
        String firstDate = DateUtil.formatDate(new Date()) + " " + startTime;
        super.scheduleAtFixedRate(timerTask, DateUtil.parseDateTime(firstDate), period);
        logger.info("\u4efb\u52a1\u5c06\u4e8e " + firstDate + " \u542f\u52a8\uff0c\u542f\u52a8\u95f4\u9694\u65f6\u95f4\u4e3a " + period / 1000L + " \u79d2");
    }

    @Override
    public void schedule(TimerTask timerTask, long delay, long period) {
        super.scheduleAtFixedRate(timerTask, delay, period);
        logger.info("\u4efb\u52a1\u5c06\u4e8e " + delay / 1000L + " \u79d2\u540e\u542f\u52a8\uff0c\u542f\u52a8\u95f4\u9694\u65f6\u95f4\u4e3a " + period / 1000L + " \u79d2");
    }
}

