/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common;

import com.baomidou.kisso.common.util.EnvUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwfToolsHelper {
    protected static Logger logger = LoggerFactory.getLogger(SwfToolsHelper.class);
    private static final String CMD_WIN = "C:/Program Files (x86)/SWFTools/pdf2swf.exe -s flashversion=9 %s -o %s";
    private static final String CMD_LINUX = "pdf2swf -s languagedir=/usr/local/xpdf-chinese-simplified -T 9 -s poly2bitmap -s zoom=150 -s flashversion=9 %s -o %s";

    public static int convertPDF2SWF(String sourcePath, String destFile) throws IOException {
        File source = new File(sourcePath);
        if (!source.exists()) {
            return -1;
        }
        String execCmd = String.format(EnvUtil.isLinux() ? CMD_LINUX : CMD_WIN, sourcePath, destFile);
        logger.debug("exec pdf2swf: %s", (Object)execCmd);
        Process pro = Runtime.getRuntime().exec(execCmd);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(pro.getInputStream()));
        while (bufferedReader.readLine() != null) {
        }
        try {
            pro.waitFor();
        }
        catch (InterruptedException e) {
            logger.error("SwfToolsHelper.convertPDF2SWF error.", (Throwable)e);
            return -1;
        }
        return pro.exitValue();
    }
}

