/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.aop;

import com.baomidou.framework.annotations.Log;
import com.baomidou.framework.aop.LogPoint;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;

public class LogAspect {
    private LogPoint logPoint;

    @Around(value="@annotation(com.baomidou.framework.annotations.Log)")
    public Object saveLog(ProceedingJoinPoint joinPoint) throws Throwable {
        String methodName = joinPoint.getSignature().getName();
        Method method = this.currentMethod(joinPoint, methodName);
        Log log = method.getAnnotation(Log.class);
        if (log != null) {
            this.logPoint.saveLog(joinPoint, methodName, log.value());
        }
        return joinPoint.proceed();
    }

    private Method currentMethod(ProceedingJoinPoint joinPoint, String methodName) {
        Method[] methods = joinPoint.getTarget().getClass().getMethods();
        Method resultMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            resultMethod = method;
            break;
        }
        return resultMethod;
    }

    public LogPoint getLogPoint() {
        return this.logPoint;
    }

    public void setLogPoint(LogPoint logPoint) {
        this.logPoint = logPoint;
    }
}

