/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.aop;

import com.baomidou.framework.annotations.DataSourceManage;
import com.baomidou.framework.datasource.DynamicDataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class DataSourceAop {
    @Around(value="@annotation(dataSourceManage)")
    public Object doAround(ProceedingJoinPoint joinPoint, DataSourceManage dataSourceManage) throws Throwable {
        Object retVal = null;
        boolean selectedDataSource = false;
        try {
            if (null != dataSourceManage) {
                String dbName = dataSourceManage.name();
                int dbSize = dataSourceManage.dbSize();
                DynamicDataSource.use(dbName, dbSize);
                selectedDataSource = true;
            }
            retVal = joinPoint.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (selectedDataSource) {
                DynamicDataSource.reset();
            }
        }
        return retVal;
    }
}

