/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.web.filter;

import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.common.util.HttpUtil;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSOFilter
implements Filter {
    private static final Logger logger = Logger.getLogger("SSOFilter");
    private static String OVERURL = null;

    public void init(FilterConfig config) throws ServletException {
        OVERURL = config.getInitParameter("over.url");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        boolean isOver = HttpUtil.inContainURL(req, OVERURL);
        if (!isOver) {
            Object token = SSOHelper.getToken(req);
            if (token == null) {
                logger.fine("logout. request url:" + req.getRequestURL());
                SSOHelper.clearRedirectLogin(req, res);
                return;
            }
            req.setAttribute("SSOTokenAttr", token);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        OVERURL = null;
    }
}

