/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.web;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.exception.KissoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class WebKissoConfigurer
extends SSOConfig {
    protected static final Logger logger = Logger.getLogger("WebKissoConfigurer");
    public static final String CONFIG_LOCATION_PARAM = "kissoConfigLocation";
    private String ssoPropPath = "sso.properties";

    public WebKissoConfigurer() {
    }

    public WebKissoConfigurer(String ssoPropPath) {
        this.ssoPropPath = ssoPropPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initKisso(ServletContext servletContext) {
        String location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (location != null) {
            if (location.indexOf("classpath") >= 0) {
                String[] cfg = location.split(":");
                if (cfg.length != 2) return;
                this.initProperties(this.getInputStream(cfg[1]));
                return;
            } else {
                File file = new File(location);
                if (!file.isFile()) throw new KissoException(location);
                try {
                    this.initProperties(this.getInputStream(new FileInputStream(file)));
                    return;
                }
                catch (FileNotFoundException e) {
                    throw new KissoException(location, e);
                }
            }
        } else {
            servletContext.log("Initializing is not available kissoConfigLocation on the classpath");
        }
    }

    public void initKisso() {
        Properties prop = null;
        File file = new File(this.getSsoPropPath());
        if (file.isFile()) {
            try {
                prop = this.getInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new KissoException(this.getSsoPropPath(), e);
            }
        } else {
            prop = this.getInputStream(this.getSsoPropPath());
        }
        if (prop != null) {
            this.initProperties(prop);
        } else {
            logger.severe("Initializing is not available kissoConfigLocation on the classpath");
        }
    }

    public void shutdownKisso() {
        logger.info("Uninstalling Kisso ");
    }

    private Properties getInputStream(String cfg) {
        return this.getInputStream(WebKissoConfigurer.class.getClassLoader().getResourceAsStream(cfg));
    }

    private Properties getInputStream(InputStream in) {
        Properties p = null;
        try {
            p = new Properties();
            p.load(in);
        }
        catch (Exception e) {
            logger.severe(" kisso read config file error. \n" + e.toString());
        }
        return p;
    }

    public String getSsoPropPath() {
        return this.ssoPropPath;
    }

    public void setSsoPropPath(String ssoPropPath) {
        this.ssoPropPath = ssoPropPath;
    }
}

