/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.captcha.background;

import com.baomidou.kisso.common.captcha.background.BackgroundFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;

public class OvalNoiseBackgroundFactory
implements BackgroundFactory {
    private static final Random rand = new Random();
    private int noises = 20;

    public OvalNoiseBackgroundFactory() {
    }

    public OvalNoiseBackgroundFactory(int noises) {
        this.noises = noises;
    }

    public void fillBackground(BufferedImage image) {
        Graphics graphics = image.getGraphics();
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, imgWidth, imgHeight);
        for (int i = 0; i < this.getNoises(); ++i) {
            graphics.setColor(OvalNoiseBackgroundFactory._getRandColor(150, 250));
            graphics.drawOval(rand.nextInt(imgWidth), rand.nextInt(imgHeight), 5 + rand.nextInt(10), 5 + rand.nextInt(10));
        }
    }

    protected static Color _getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + rand.nextInt(bc - fc);
        int g = fc + rand.nextInt(bc - fc);
        int b = fc + rand.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public int getNoises() {
        return this.noises;
    }

    public void setNoises(int noises) {
        this.noises = noises;
    }
}

