/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOProperties {
    private static final Logger logger = Logger.getLogger("SSOProperties");
    private final Properties properties;

    public SSOProperties(Properties properties) {
        this.properties = properties;
    }

    public SSOProperties(Properties mergeProperties, String runMode) {
        this.properties = SSOProperties.extractRunMode(mergeProperties, runMode);
    }

    public SSOProperties(Properties mergeProperties, String runMode, String currentMode) {
        this.properties = SSOProperties.extractRunMode(mergeProperties, runMode, currentMode);
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public static Properties extractRunMode(Properties prop, String runMode) {
        return SSOProperties.extractRunMode(prop, runMode, "online_mode");
    }

    public static Properties extractRunMode(Properties prop, String runMode, String defaultMode) {
        if (prop == null || runMode == null || defaultMode == null) {
            return null;
        }
        Properties properties = new Properties();
        String mode = System.getProperty(runMode);
        if (mode == null) {
            String str = prop.getProperty(runMode);
            mode = str != null ? str : defaultMode;
        }
        logger.info("sso.run.mode=" + mode);
        properties.put(runMode, mode);
        Set<Map.Entry<Object, Object>> es = prop.entrySet();
        for (Map.Entry<Object, Object> entry : es) {
            String key = (String)entry.getKey();
            int idx = key.lastIndexOf("_mode");
            String realKey = key;
            if (idx > 0) {
                realKey = key.contains(mode) ? key.substring(0, key.lastIndexOf("_" + mode)) : null;
            }
            if (realKey == null || properties.containsKey(realKey)) continue;
            Object value = null;
            value = idx > 0 ? prop.get(realKey + "_" + mode) : prop.get(realKey);
            if (value != null) {
                properties.put(realKey, value);
                continue;
            }
            throw new RuntimeException("impossible empty property for " + realKey);
        }
        return properties;
    }

    public String get(String key, String defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : val;
    }

    public String findValue(String ... keys) {
        for (String key : keys) {
            String value = this.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : Boolean.parseBoolean(val);
    }

    public long getLong(String key, long defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : Long.parseLong(val);
    }

    public int getInt(String key, int defaultVal) {
        return (int)this.getLong(key, defaultVal);
    }

    public double getDouble(String key, double defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : Double.parseDouble(val);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        String val = this.get(key);
        return val == null ? defaultValue : Enum.valueOf(type, val);
    }
}

