/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeUtils {
    public static Node cloneNode(Node node) {
        IIOMetadataNode iioNode;
        Object obj;
        if (node == null) {
            return null;
        }
        IIOMetadataNode newNode = new IIOMetadataNode(node.getNodeName());
        if (node instanceof IIOMetadataNode && (obj = (iioNode = (IIOMetadataNode)node).getUserObject()) instanceof byte[]) {
            byte[] copyBytes = (byte[])((byte[])obj).clone();
            newNode.setUserObject(copyBytes);
        }
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            newNode.setAttribute(attr.getNodeName(), attr.getNodeValue());
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            newNode.appendChild(NodeUtils.cloneNode(child));
        }
        return newNode;
    }

    public static Node getChild(Node parent, String nodeName) {
        if (nodeName == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!nodeName.equalsIgnoreCase(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    public static void removeChild(Node parent, String nodeName) {
        if (nodeName == null) {
            return;
        }
        NodeList children = parent.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!nodeName.equalsIgnoreCase(child.getNodeName())) continue;
            parent.removeChild(child);
            return;
        }
    }

    public static void setAttrValue(Node node, String attrName, String value) {
        if (attrName == null) {
            return;
        }
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (!attrName.equalsIgnoreCase(attr.getNodeName())) continue;
            attr.setNodeValue(value);
            return;
        }
    }

    public static void setAttrValue(Node node, String attrName, int value) {
        NodeUtils.setAttrValue(node, attrName, String.valueOf(value));
    }

    public static void setAttrValue(Node node, String attrName, double value) {
        NodeUtils.setAttrValue(node, attrName, String.valueOf(value));
    }

    public static String getAttr(Node node, String attrName) {
        if (attrName == null) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            if (!attrName.equalsIgnoreCase(attr.getNodeName())) continue;
            return attr.getNodeValue();
        }
        return null;
    }

    public static int getIntAttr(Node node, String attrName) {
        String sValue = NodeUtils.getAttr(node, attrName);
        if (sValue == null) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(sValue);
    }

    public static double getDoubleAttr(Node node, String attrName) {
        String sValue = NodeUtils.getAttr(node, attrName);
        if (sValue == null) {
            return Double.NaN;
        }
        return Double.parseDouble(sValue);
    }
}

