/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import com.alibaba.simpleimage.render.WriteParameter;
import com.alibaba.simpleimage.util.PaletteBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.HashSet;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.ColorQuantizerDescriptor;
import javax.media.jai.operator.ColorQuantizerType;

public class IndexImageBuilder {
    protected RenderedImage src;
    protected WriteParameter.QuantAlgorithm quantAlgorithm;

    public static RenderedImage createIndexedImage(RenderedImage src, WriteParameter.QuantAlgorithm quantAlgorithm) {
        IndexImageBuilder builder = new IndexImageBuilder(src, quantAlgorithm);
        return builder.createIndexedImage();
    }

    public static boolean needConvertToIndex(RenderedImage image) {
        SampleModel sampleModel = image.getSampleModel();
        ColorModel colorModel = image.getColorModel();
        return sampleModel.getNumBands() != 1 || sampleModel.getSampleSize()[0] > 8 || colorModel.getComponentSize()[0] > 8;
    }

    protected IndexImageBuilder(RenderedImage src, WriteParameter.QuantAlgorithm quantAlgorithm) {
        this.src = src;
        this.quantAlgorithm = quantAlgorithm;
    }

    protected RenderedImage createIndexedImage() {
        if (this.quantAlgorithm == WriteParameter.QuantAlgorithm.OctTree) {
            return PaletteBuilder.createIndexedImage(this.src);
        }
        SampleModel sm = this.src.getSampleModel();
        if (sm.getNumBands() == 3 || sm.getDataType() != 0) {
            PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)this.src);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(pi);
            pb.add(this.getQuantizationAlgorithm(this.quantAlgorithm));
            pi = JAI.create((String)"ColorQuantizer", (ParameterBlock)pb);
            return pi;
        }
        return PaletteBuilder.createIndexedImage(this.src);
    }

    private ColorQuantizerType getQuantizationAlgorithm(WriteParameter.QuantAlgorithm quantAlg) {
        if (quantAlg == WriteParameter.QuantAlgorithm.OctTree) {
            return ColorQuantizerDescriptor.OCTTREE;
        }
        if (quantAlg == WriteParameter.QuantAlgorithm.NeuQuant) {
            return ColorQuantizerDescriptor.NEUQUANT;
        }
        if (quantAlg == WriteParameter.QuantAlgorithm.MedianCut) {
            return ColorQuantizerDescriptor.MEDIANCUT;
        }
        throw new IllegalArgumentException("Unknown quantization algorithm " + (Object)((Object)quantAlg));
    }

    RenderedImage createSimpleIndexImage() {
        ColorModel srcCM = this.src.getColorModel();
        if (srcCM instanceof IndexColorModel) {
            return this.src;
        }
        Raster srcRaster = this.src.getData();
        boolean hasTransparent = srcCM.getTransparency() != 1;
        int maxColorCount = 256;
        if (hasTransparent) {
            maxColorCount = 255;
        }
        int num = 0;
        HashSet<Integer> colorSet = new HashSet<Integer>();
        int[] colorArrays = new int[maxColorCount];
        for (int x = 0; x < this.src.getWidth(); ++x) {
            for (int y = 0; y < this.src.getHeight(); ++y) {
                int rgb = srcCM.getRGB(srcRaster.getDataElements(x, y, null)) & 0xFFFFFF;
                if (colorSet.contains(rgb)) continue;
                if (num == maxColorCount) {
                    return null;
                }
                colorArrays[num++] = rgb;
                colorSet.add(rgb);
            }
        }
        if (num == 0) {
            throw new IllegalStateException("This image has no color");
        }
        int[] colors = null;
        if (hasTransparent) {
            colors = new int[num + 1];
            System.arraycopy(colorArrays, 0, colors, 1, num);
            colors[0] = 0;
        } else {
            colors = new int[num];
            System.arraycopy(colorArrays, 0, colors, 0, num);
        }
        Arrays.sort(colors);
        byte[] red = new byte[colors.length];
        byte[] green = new byte[colors.length];
        byte[] blue = new byte[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            red[i] = (byte)(colors[i] >> 16 & 0xFF);
            green[i] = (byte)(colors[i] >> 8 & 0xFF);
            blue[i] = (byte)(colors[i] & 0xFF);
        }
        IndexColorModel destCM = null;
        destCM = hasTransparent ? new IndexColorModel(8, colors.length, red, green, blue, 0) : new IndexColorModel(8, colors.length, red, green, blue);
        BufferedImage image = new BufferedImage(this.src.getWidth(), this.src.getHeight(), 13, destCM);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < this.src.getWidth(); ++x) {
            for (int y = 0; y < this.src.getHeight(); ++y) {
                int argb = srcCM.getRGB(srcRaster.getDataElements(x, y, null));
                if (hasTransparent && (argb & 0xFF000000) != -16777216) {
                    raster.setSample(x, y, 0, 0);
                    continue;
                }
                int index = Arrays.binarySearch(colors, argb & 0xFFFFFF);
                if (index < 0) {
                    throw new IllegalStateException("Some colors not indexed");
                }
                raster.setSample(x, y, 0, index);
            }
        }
        return image;
    }
}

