/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLog {
    private Log log;

    public static ImageLog getLog(Class<?> clazz) {
        Log log = LogFactory.getLog(clazz);
        return new ImageLog(log);
    }

    private ImageLog(Log log) {
        this.log = log;
    }

    protected String formatMsg(Object action, RenderedImage img) {
        String msgFmt = action + ": {0}={1} DataType={2} Width={3} Height={4}";
        String clazz = img.getColorModel().getColorSpace().getClass().getSimpleName();
        int type = img.getColorModel().getColorSpace().getType();
        int dataType = img.getData().getDataBuffer().getDataType();
        int w = img.getWidth();
        int h = img.getHeight();
        String msg = MessageFormat.format(msgFmt, clazz, this.getColorSpaceName(type), this.getDataTypeName(dataType), w, h);
        return msg;
    }

    protected String getColorSpaceName(int type) {
        switch (type) {
            case 0: {
                return "TYPE_XYZ";
            }
            case 1: {
                return "TYPE_Lab";
            }
            case 2: {
                return "TYPE_Luv";
            }
            case 3: {
                return "TYPE_YCbCr";
            }
            case 4: {
                return "TYPE_Yxy";
            }
            case 5: {
                return "TYPE_RGB";
            }
            case 6: {
                return "TYPE_GRAY";
            }
            case 7: {
                return "TYPE_HSV";
            }
            case 8: {
                return "TYPE_HLS";
            }
            case 9: {
                return "TYPE_CMYK";
            }
            case 11: {
                return "TYPE_CMY";
            }
            case 12: {
                return "TYPE_2CLR";
            }
            case 13: {
                return "TYPE_3CLR";
            }
            case 14: {
                return "TYPE_4CLR";
            }
            case 15: {
                return "TYPE_5CLR";
            }
            case 16: {
                return "TYPE_6CLR";
            }
            case 17: {
                return "TYPE_7CLR";
            }
            case 18: {
                return "TYPE_8CLR";
            }
            case 19: {
                return "TYPE_9CLR";
            }
            case 20: {
                return "TYPE_ACLR";
            }
            case 21: {
                return "TYPE_BCLR";
            }
            case 22: {
                return "TYPE_CCLR";
            }
            case 23: {
                return "TYPE_DCLR";
            }
            case 24: {
                return "TYPE_ECLR";
            }
            case 25: {
                return "TYPE_FCLR";
            }
        }
        return "TYPE_UNDEFINED";
    }

    protected String getDataTypeName(int dataType) {
        switch (dataType) {
            case 0: {
                return "TYPE_BYTE";
            }
            case 1: {
                return "TYPE_USHORT";
            }
            case 2: {
                return "TYPE_SHORT";
            }
            case 3: {
                return "TYPE_INT";
            }
            case 4: {
                return "TYPE_FLOAT";
            }
            case 5: {
                return "TYPE_DOUBLE";
            }
        }
        return "TYPE_UNDEFINED";
    }

    public void info(Object msg) {
        if (this.log.isInfoEnabled()) {
            this.log.info(msg);
        }
    }

    public void info(Object action, RenderedImage img) {
        if (this.log.isInfoEnabled()) {
            String msg = this.formatMsg(action, img);
            this.log.info((Object)msg);
        }
    }

    public void debug(Object msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg);
        }
    }

    public void debug(Object action, RenderedImage img) {
        if (this.log.isDebugEnabled()) {
            String msg = this.formatMsg(action, img);
            this.log.debug((Object)msg);
        }
    }

    public void fatal(Object action, RenderedImage img) {
        if (this.log.isFatalEnabled()) {
            String msg = this.formatMsg(action, img);
            this.log.fatal((Object)msg);
        }
    }

    public void fatal(Object msg) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal(msg);
        }
    }

    public void error(Object msg) {
        if (this.log.isErrorEnabled()) {
            this.log.error(msg);
        }
    }

    public void error(Object action, RenderedImage img) {
        if (this.log.isErrorEnabled()) {
            String msg = this.formatMsg(action, img);
            this.log.error((Object)msg);
        }
    }

    public void trace(Object msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(msg);
        }
    }

    public void trace(Object action, RenderedImage img) {
        if (this.log.isTraceEnabled()) {
            String msg = this.formatMsg(action, img);
            this.log.trace((Object)msg);
        }
    }

    public void warn(Object msg) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(msg);
        }
    }

    public void warn(Object action, RenderedImage img) {
        if (this.log.isWarnEnabled()) {
            String msg = this.formatMsg(action, img);
            this.log.warn((Object)msg);
        }
    }
}

